# 0.8.18 Release

Release did not happen yet but is expected for today!

- guid: 190576e0-9fef-486e-b8da-c4e75be08329
- author: Markus Raab
- pubDate: Fri, 16 Sep 2016 23:31:27 +0200



## What is Elektra?

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

## Highlights

- Intercept open syscalls which allows Elektra to dynamically
  generate config files from its database
- Experimental version of cryptographic plugins
- A new zsh completion file (next to the bash completion file)
- Gitresolver allows to directly read and write config files
  from git instead of files present in the file system.
- Survey completed successfully (and debts paid), we now
  prepare raw data


### Crypto Plugin

Gpg is now used to decrypt a master password, which is used
by the individual crypto backends.

Furthermore, a new [botan](https://botan.randombit.net) backend
was implemented.

[See here](http://git.libelektra.org/tree/master/src/plugins/crypto)

Thanks to Peter Nirschl.


### Open Interception

When Elektra directly modifies config files which are on the disc,
and applications read the config files without Elektra, Elektra has
no control over the access, e.g. we cannot dynamically calculate
values. To avoid this, we wrote a library that
intercepts the `open`-call.

Together with the `mozprefs` plugin, we got control over the configuration
of Firefox and can dynamically change config values with all possibilities
Elektra provides.

For easy setup, we implemented the script `configure-firefox`.

[See here](http://git.libelektra.org/tree/master/src/bindings/intercept)

Thanks to Thomas Waser.


### Resolver

Resolvers in Elektra are the code that are responsible to determine where
content should be read from and stored to. They are independent of the
actual configuration file syntax.

The [gitresolver](http://git.libelektra.org/tree/master/src/plugins/gitresolver)
allows you to get/store config data in git.

The [blockresolver](http://git.libelektra.org/tree/master/src/plugins/blockresolver)
allows Elektra to take control of parts of the configuration
file. This is useful for config files such as vim or zsh, which contain
program code. The plugin allows you to split config files with special markers
into parts containing code and others controlled by Elektra.


### zsh completion

Added zsh completion file, and a script (`kdb install-sh-completion`)
that installs bash+zsh completion when the default installation places
do not work (e.g. for Mac OS X).

Thanks to Sebastian Bachmann.


## Documentation

- fix kdb-import man page, thanks to Kurt Micheli
- mark keyIsSystem/keyIsUser as internal
- fix doxygen reference to example
- better document that `global-mount` or `gmount` will overwrite
  previously mounted global plugins
- fix spelling mistake, thanks to René Schwaiger
- Wrote tutorial how to use Elektra-python bindings,
  thanks to Ulrike Schäfer


## Quality

- shell recorder test cases now run during `make test`, thanks to Kurt
  Micheli and René Schwaiger
- find-tools now pep and pyflakes happy, thanks to Kurt Micheli
- fix bashism, thanks to Thomas Waser and Kurt Micheli
- better error message for conditionals plugin, thanks to Thomas Waser
- better error message for augeas plugin, thanks to Felix Berlakovich
- Many compilation warnings fixed, thanks to Gabriel Rauter, Thomas Waser
- GSettings: fix double free, thanks to Gabriel Rauter
- Fix external links and add an external link checker,
  thanks to Kurt Micheli
- Fix openwrt/musl warnings with wrong printf format, thanks to
  Thomas Waser
- Fix NODEP metadata, allows you to build all plugins that do not
  have dependencies.


## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

### Libtools

Libtools got a new major version (SOVERSION 0 -> 1):

- resolveRecommends was never implemented and was now removed
- backend/plugin configs are now validated by plugins (needed
  by gpg plugin, which checks if wrong key IDs are supplied during mount)

### Plugins

The plugins conditionals and mathcheck are incompatible because of changes
in syntax.

## Development

- github descriptions+workflow (showed when creating PRs and issues)
- new trigger phases for github, see
  [doc/GIT](http://git.libelektra.org/tree/master/doc/GIT.md)
  thanks to Mihael Pranjić
- valgrind suppressions are great again, thanks to Peter Nirschl
- Plugins get a new namespace `internal` which can be used for meta-data
  that is not relevant for other plugins.
- kdberrors.h is only generated once, which allows us to use other build
  systems, thanks to René Schwaiger
- `INCLUDE_SYSTEM_DIRECTORIES` in add_plugin allows you to add a include
  path where warnings are suppressed (useful for boost).
- `infos/provides` now allows multiple entries

## Packaging

- Plugin-provider `CRYPTO` can be used to enable/disable all crypto
  plugin variants.
- Config option `ENABLE_OPTIMIZATIONS`, enable by default: trade more
  memory for speed (can be turned off on embedded systems)
- `INSTALL_SYSTEM_FILES` is now off by default on Mac OS X.
- bash-completion is installed to where pkg-config tells us,
  thanks to Gabriel Rauter
  (fallback is now `/usr/share/bash-completion/completions/kdb`)
  was `/etc/bash_completion.d/kdb` (removed)
- zsh is now installed to `/usr/share/zsh/vendor-completions/_kdb`
  (except for Darwin)
- removed /etc/profile.d/kdb.sh: the script `elektraenv.sh` was
  removed (and is no longer installed)
- added scripts install-sh-completion configure-firefox elektrify-open
- added plugins libelektra-blockresolver.so  libelektra-boolean.so
  libelektra-crypto_botan.so libelektra-crypto_openssl.so
  libelektra-desktop.so libelektra-mozprefs.so libelektra-passwd.so
- added tests testmod_blockresolver testmod_boolean
  testmod_crypto_botan testmod_crypto
  gcrypt testmod_crypto_openssl testmod_mozprefs testmod_passwd
  test_opmphm_vheap test_opmphm_vstack
- added test data blockresolver mozprefs passwd

## Other

- Conditionals and mathcheck plugins got support to specify relative
  keys, thanks to Thomas Waser
- `kdb` command-list: commands are written in bold
- GSettings backend can be build standalone, thanks to Gabriel Rauter
- first data structures for order preserving minimal perfect hash map,
  thanks to Kurt Micheli
- added a new passwd plugin, thanks to Thomas Waser
- [boolean]((http://git.libelektra.org/tree/master/src/plugins/boolean)
  plugin to normalize boolean values, thanks to Thomas Waser
- [desktop](http://git.libelektra.org/tree/master/src/plugins/desktop)
  plugin to detect which desktop currently is running (supports kde,
  gnome, tde, unity or any other XDG conformant desktop)
- `doc/paper` contains some info for [joss](https://github.com/openjournals/joss)


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.18.tar.gz)

<<`scripts/generate-hashsums`>>

This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.18/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/190576e0-9fef-486e-b8da-c4e75be08329.html)

For more information, see [http://libelektra.org](http://libelektra.org)










# 0.8.17 Release

- guid: e6153a39-c4bd-41c3-bc86-785d451eb6c5
- author: Markus Raab
- pubDate: Tue, 14 Jun 2016 08:32:44 +0200


## Survey

First off: We created a survey questionnaire to gather more knowledge
about the relevance of configuration systems.  If you are involved in
the development of free and open source software (FLOSS) you are the
person we are looking for.

It would be a great help if you take this survey:

[survey](http://elektra.limequery.org/625192)

It will be available till 18.07.2016 (anywhere on earth).

For every thoroughly and not anonymously finished survey € 40 cent
will be donated to one of the following organizations of your choice:

- LimeSurvey (LimeService, kindly hosts this survey)
- SPI (General Donation: 0 A.D., LibreOffice, Debian, ArchLinux, …)
- FSFE
- GNOME
- KDE
- Mozilla (Firefox)
- Wikimedia Foundation (Wikipedia)

## Why should I use Elektra? ##

The three main points relevant for most people are:

1. Even though Elektra provides a global keydatabase
   configuration files stay human read- and writable
   which allows us to integrate unmodified software.
2. Flexible adoption on how the configuration is accessed
   via plugins: you can run arbitrary code, e.g. do a
   `git commit` or log/notify when configuration files
   are changed.
3. Elektra allows you to specify configuration values:
   - use the value of other configuration values (symbolic links)
   - calculate the values based on other configuration values
   - validation configuration files
   - [generate code based on it](https://github.com/elektrainitiative/libelektra/tree/master/src/tools/gen)
   - [and much more](https://github.com/elektrainitiative/libelektra/tree/master/src/plugins/README.md)

Read more about [Why using Elektra](https://github.com/elektrainitiative/libelektra/tree/master/doc/WHY.md),
which also contains since this release unique features,
further reasons and limitations.

For a small demo see here

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

## Highlights

- Qt-Gui reworked mounting and native icons
- Full Mac OS X Support, Build Server improvements
  and new beginner friendly tasks
- allows us to mount csv, json and xml (and other common provider names)
  without needing to know plugin names
- colored output for kdb tools
- Experimental GSettings support


## Beginner friendly tasks

In this release starting developing Elektra gets easier:

- `ELEKTRA_DEBUG` adds run-time checks and makes stack traces
  as if Elektra would not use plugins
- `CMakeLists.txt` for plugins got simplified, in most cases it
  should be not more than calling a single function,
  even if unit tests and test data are present
- We prepared [beginner friendly tasks](https://github.com/ElektraInitiative/libelektra/issues?q=is%3Aissue+is%3Aopen+label%3A%22beginner+friendly%22)
  for you.

For details about `ELEKTRA_DEBUG` and cmake, see individual points below.



## Find-Tools

There is now a fine collection of external scripts which can
executed by `kdb + <script>`. The new script `kdb find-tools`
provides full text search over the meta data as provided by
the scripts.

   * `kdb find-tools -b BRIEF` to search for a short text.
   * `kdb find-tools -a AUTHOR` to search for a author.
   * `kdb find-tools -d DATE` to search for a creation date.
   * `kdb find-tools -e EXECUTE` to search for a type.

Developers should now [add MetaData for their scripts.](https://github.com/elektrainitiative/libelektra/tree/master/scripts/README.md).

Thanks to Kurt Micheli!

## Mac OS X Support

Because of its POSIX support one might think it would be trivial to
support Mac OS X. Unfortunately there were many small issues, especially
in the regular expression handling and the filesystem.

Nevertheless we finally fully support Mac OS X and the newly added
travis build server makes sure it will stay this way.

A huge thanks to Manuel Mausz and Mihael Pranjić for fixing the
issues and setting up travis:

- jni plugin now can load Elektra (avoids using `.so`)
  thanks to Mihael Pranjić
- initial creation of travis.yml
  thanks to Manuel Mausz
- Add all 3 different XCode setups and some Mac OS X fixes
  thanks to Mihael Pranjić

## jenkins

Now (nearly) every build job can be triggered from Pull Requests.
For example:

* jenkins build [git-buildpackage-jessie](http://build.libelektra.org:8080/job/elektra-git-buildpackage-jessie/) please
* jenkins build [git-buildpackage-wheezy](http://build.libelektra.org:8080/job/elektra-git-buildpackage-wheezy/) please
* jenkins build [icc](http://build.libelektra.org:8080/job/elektra-icc/) please
* jenkins build [local-installation](http://build.libelektra.org:8080/job/elektra-local-installation/) please

For a full list see [here](https://github.com/elektrainitiative/libelektra/tree/master/doc/GIT.md).

Thanks to Mihael Pranjić for the setup!

## Fixes

- fix inconsistency with one excluded compilation variant,
  thanks to Harald Geyer for reporting #698
- fix dynamic searching of installed plugins,
  needed so that kdb list-tools works correctly
  thanks to Harald Geyer for reporting
- kdbtimer, `include <vector>` as needed by some compilers,
  a big thanks to Andreas Bombe for the non-maintainer
  upload in Debian to fix it for upcoming Debian release
- also find yajl header files if installed in non-standard
  include directories,
  thanks to Mihael Pranjić
- glib: make sure we use all definitions returned by pkg-config #719,
  fixes build on FreeBSD
  now glib bindings need cmake 2.8.12
  thanks to Mihael Pranjić for reporting/testing
  and Manuel Mausz  for fixing
- fix INI for Mac OS X (did require some non-portable sorting
  properties of `qsort`.)
- INI makes INI-specific meta-data private by prefixing `ini`.
- `kdb export` also works under MinGW,
  thanks to Gabriel Rauter

## Rework Add Plugin


- prefer to link shared
- add plugin tests when using link shared
- make ADD_TEST simpler (without calling add_plugintest)
- make installation of test data simpler + honor INSTALL_TESTING option
- fix installation of test_data (do not install whole dir)
- introduce cache so that it is enough to pass parameters
  to add_plugin* once
- avoid PLUGIN_DIRECTORY_NAME and change CMAKE_CURRENT_SOURCE_DIR
  and CMAKE_CURRENT_BINARY_DIR instead
- add_plugin: remove unused option SHARED_SOURCES
- implement a 3rd phase to add test cases:
  correctly handles dependencies of testcases to bindings
- fix testmod_jni


## CMake

for maintainers:

- The cmake variables KDB_DB_SYSTEM and KDB_DB_HOME are now STRING and not PATH.
- BUILD_FULL and BUILD_STATIC are now OFF by default
- building with BUILD_SHARED is now preferred (for all examples, test cases,...)
- ELEKTRA_DEBUG_BUILD and ELEKTRA_VERBOSE_BUILD is not used anymore.
- ENABLE_DEBUG was added: it does not add debug symbols but run-time assertions.
- More cmake variables are marked as advanced.

for developers:

- BUILD_STATIC and BUILD_FULL is now OFF by default
  (nearly) all unit tests now also work with BUILD_SHARED
- to support shared unit tests, a third phase was added when
  adding plugins
  inconsistent adding (across phases) of plugins and unit tests is reported
- in `add_plugin` remove SHARED_SOURCES, and add `ADD_TEST` and `INSTALL_TEST_DATA`.

and fixes:

- adding plugin tests is now much simpler, simply use `ADD_TEST`
  in `add_plugin`.
- KDB_DB_SYSTEM and KDB_DB_HOME are now STRING and not PATH because
  of incorrect resolving of `~`.
- lua bindings tests: make sure lua executable matches with the lua libraries version
  thanks to Mihael Pranjić
- lua bindings: do not use hard-coded `lua` executable.
- Fix cmake configure when BUILD_DOCUMENTATION is set to OFF
  thanks to Kurt Micheli

See more about changes to plugin adding in cmake in the
[plugin decision](https://github.com/elektrainitiative/libelektra/tree/master/doc/decisions/cmake_plugins.md).

## Experimental GSettings support

As part of the ongoing work of the bachelor thesis
`Integration of Elektra into the GNOME desktop environment`
we now have experimental support for Elektra as a GSettings backend on Linux
(We will look into getting OS X support on a later date).
When installed, applications using GSettings default backend will write to Elektra
below the `/sw` key. The GSettings bindings are intended as a preview version so
please do not use them in a production system.

To build the GSettings backend you have to explicitly add the binding even if `ALL` is given.
e.g. `-DBINDINGS=gsettings` `-DBINDINGS="ALL;gsettings"`

All needed core functionality of a GSettings backend is already implemented.
This includes notification support if you have your `/sw` mounted with the dbus plugin.

Please report any bugs you encounter.

For further information regarding the status of the implementations
please refer to the corresponding [README](https://github.com/elektrainitiative/libelektra/tree/master/src/bindings/gsettings)
and [ticket](https://github.com/ElektraInitiative/libelektra/issues/775).

## Common Provider Names

Mounting now supports to mount commonly known names even if the name is not a plugin.
If more than one plugin is available automatically the best one is selected.
The selection process works by annotating different qualities of the plugins,
see `infos/status` in the README.md of individual plugins.

E.g. to mount a file using a json plugin (called yajl because of the library's name
it build upon)

    kdb mount file.json json


## New Cachefilter Plugin

stores filtered keys internally so that they
do not get accidentally lost and can be written to the storage again without
the user having to remember including them in the writeout

The longer term goal is to add such global plugins per default, so that
the usage of the API is easier.

For now you can simply add it using:

     kdb global-mount cachefilter

Thanks to Marvin Mall.


## Qt GUI 0.0.12

The Qt GUI receives new features and a better gnome integration.
Its version number was updated to 0.0.12 (beta).
Major features:

- use native icons (Qt GUI xdg icon theme support rework)
  thanks to Gabriel Rauter
- update desktop entry org.libelektra.elektra-qt-editor.desktop
  with new symbolic icon of Elektra's logo
  so that qt-gui can nicely started from within Gnome
  thanks to Gabriel Rauter
- Add new layout elements to backend wizard
  and integrate new BackendBuilder functionality (See Common Provider Names) to qt-gui
  thanks to Raffael Pancheri


Bug fixes:

- Reset to defaults now reverts back to build-in defaults.
- Make clicks on search icon focus on search textfield.
- save settings when settings dialog is closed.
- fix crash of qt-gui when crypto plugin was enabled
  (and added /shutdown option to enable previous behaviour)
  thanks to Peter Nirschl
- fix qt-gui fails to synchronize because of readonly plugins
  thanks to Raffael Pancheri
- Rename desktop file: correct reverse url from org.elektra to org.libelektra.
- Rename elektra-qt to elektra-qt-editor.
- Rename ChooseColorWindow: The ChooseColorWindows will be replaced by a
  AppearanceSettingsWindow, all references to ChooseColor, choose color have been
  replaced by AppearanceSettings or choose appearance.


Other improvements:

- Install `elektra-qt-editor` binary so both the desktop files TryExec works
  and people not starting the gui trough `kdb qt-gui` have a speaking name
  in their process list.
- Replace occurences of `Elektra Editor` with `Elektra Qt Editor` so that
  we use the same name in all places apart from the tools binary.
- Introduce Appearance Settings Window: Appearance Settings Window
  contains both color settings as well as a switch to disable or enable
  the system icon theme. For this to work we had to introduce the setting
  in `guisettings`. We also added a private function in `guisettings` to
  get and set settings with a boolean value.
- Tree reload on Settings close: We now synch and refresh the tree view on
  closing of the settings window if any settings have been changed, so
  changes can be seen imediatly in the tree.
- Add qt5 svg module as dependency: the qt5 svg module is needed so we can
  display icon themes that provide svg as icon format.
- Add and install symbolic icon with the installation of the Elektra
  Qt Editor.


Thanks to Gabriel Rauter and Raffael Pancheri for the engagement in
improving qt-gui.


## Colored kdb tool

A big thanks to Gabriel Rauter for improving the user experience with the kdb tool.
On errors and in `kdb info` it was often quite hard to find the relevant text.

Now important parts are highlighted by bold or colorful text.
This helps to spot the important information immediately without sacrificing
information that would be important for a detailed analysis.

Every tool now has the option `--color` and `-C` which is set to `auto` per default.
By writing to:

    kdb set user/sw/elektra/kdb/#0/color off

one can go back to previous behavior.


## Documentation

- improve documentation about how to pop a key
- document how to avoid running test cases as root in
  [TESTING.md](https://github.com/elektrainitiative/libelektra/tree/master/doc/TESTING.md).
- document guarantees of `elektraPluginGetData`,
  thanks to Marvin Mall
- doc mentions that -1 should be returned
  *always* when an error is set
- many more spelling mistakes were fixed and useless whitespace was removed,
  thanks to René Schwaiger
- describe preferences when plugins are included/excluded
- improvements in `ksCopy`, `ksPop`, `kdbGet` and `kdbSet`
  [API description](http://doc.libelektra.org/api/0.8.17/html/)
- added [WHY document](https://github.com/elektrainitiative/libelektra/tree/master/doc/WHY.md)
- updated [plugin decision](https://github.com/elektrainitiative/libelektra/tree/master/doc/decisions/cmake_plugins.md) to include 3rd phase

## ELEKTRA_DEBUG build

ENABLE_DEBUG now enables a debug build for Elektra.
It has nothing to do with debug symbols, but:

- it enables assertions
- it enables [undefinied behavior sanitizer](http://clang.llvm.org/docs/UndefinedBehaviorSanitizer.html)
  for clang
- plugins will not be closed so that stack traces are more useful
  (using `RTLD_NODELETE`)

`ENABLE_DEBUG` is recommended for every developer, even if you are not
modifying Elektra itself. The assertions will give you hints on API misusage.

For example, `keyNew` was known to be error-prone. `ENABLE_DEBUG` now will report
wrong parameters by an assertion.

The old options `ELEKTRA_DEBUG` and `ELEKTRA_VERBOSE` are not available anymore.

Thanks to:
- Thomas Waser for pointing to `RTLD_NODELETE`
- Gabriel Rauter for fixing qt-gui with `-DENABLE_DEBUG=ON`


The constants plugin was updated to provide `cmake/ENABLE_LOGGER` `cmake/ENABLE_DEBUG`
and will no longer provide `cmake/ELEKTRA_DEBUG_BUILD` `cmake/ELEKTRA_VERBOSE_BUILD`


## Other

- Gabriel Rauter is now listed in
  [AUTHORS](https://github.com/elektrainitiative/libelektra/tree/master/doc/AUTHORS)
- constants plugin: configure_file now uses current binary directory, not cluttering
  the main build directory.
- fix ssize_t for VS2015,
  thanks to Gabriel Rauter
- gtest: fix linking when using arch systemd-nspawn,
  thanks to Marvin Mall
- `LD_LIBRARY_PATH` is added to lua and python bindings needed for Mac OS X,
  thanks to Mihael Pranjić
- Fix external unit test for Ubuntu 15.04 by putting files before
  the flags,
  thanks to Marvin Mall
- symbols in Ni_ namespace are now in elektraNi_
- add more ipv4 and ipv6 test cases for IP adress validation
  checker
- crypto-plugin avoid usage of hardcoded error numbers,
  thanks to Peter Nirschl
- do not use number for resolver position
- to fix a compiler warning in Mac OS X, we made the printf
  format specifier of time_t more portable,
  thanks to René Schwaiger
- many preparations for global plugins and mmap
- in the constants plugin `cmake/BUILTIN_PLUGIN_FOLDER`, `BUILTIN_DATA_FOLDER`
  and `BUILTIN_EXEC_FOLDER` were added.
- doxygen is only run once during build,
  thanks to René Schwaiger
- add script configure-home to build Elektra
  that it will resolve all pathes to home-directories
- add script metaini-to-c that converts METADATA.ini
  to C-code, thanks to Thomas Waser
- add note that default values must be present for
  code generation, thanks to Martin Schleiss
- avoid `seq` as it is not available in some `*BSD`,
  thanks to Mihael Pranjić
- make jni testmod check consistent to others



## Compatibility

As always, the ABI and API is fully forward- and backward-compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile every program without errors
(API). This time you can even compile programs against 0.8.17 and run with 0.8.16.

For the qt-gui the svg module is added as dependency.

New and missing files in the installation:

- `elektra-qt-editor` is installed in the path (needed for TryExec in Desktop file)
- `libelektrasettings.so` will be installed if `gsettings` binding is enabled
- `libelektra-cachefilter.so` is the new cachefilter plugin
- `tool_exec/testmod_cachefilter` is its unit test
- `tool_exec/find-tools` is a new python script to find other tools
- `appdata/org.libelektra.elektra-qt-editor.appdata.xml`
- `icons/hicolor/scalable/apps/elektra-symbolic.svg`
- `share/man/man1/kdb-find-tools.1`

Renamed files:

- `applications/org.elektra.elektra-qt.desktop` got renamed to
  `applications/org.libelektra.elektra-qt-editor.desktop`.

Removed files:

- Some of the installed "test data" actually was source code from
  Elektra. Test data from the following plugins is affected:
  `hosts`, `ini`, `lineendings`, 

Temporarily removed files:

- `testmod_lua`, `testmod_python` and `testmod_python2` do not work in a shared build
  and are temporarily disabled if `BUILD_SHARED` is enabled.
  Also their test data is affected.


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.17.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.17.tar.gz)

- name: elektra-0.8.17.tar.gz
- size: 2459542
- md5sum: e53efdb9a5e0852c58b21280b1e6c07d
- sha1: a1abcd4ac5aabfc60c34da98a02c4636e4634b5c
- sha256: a6a41afb0160feef84f7d1e0d199da26022ff8cb52ed455a0d306b589838d8f5


This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.17.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.17/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/e6153a39-c4bd-41c3-bc86-785d451eb6c5.html)

For more information, see [http://libelektra.org](http://libelektra.org)

Best regards,
Markus


















# 0.8.16 Release

- guid: 9c9247ee-ee9c-4f4a-a68e-76959def9b82
- author: Markus Raab
- pubDate: Fri, 29 Apr 2016 12:45:39 +0200


In case you do not yet know about it, here is an abstract about Elektra:

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
Elektra provides a mature, consistent and easily comprehensible API.
Its modularity effectively avoids code duplication across applications
and tools regarding configuration tasks. Elektra abstracts from
cross-platform-related issues and allows applications to be aware of other
applications' configurations, leveraging easy application integration.

Elektra consists of three parts:

1. *LibElektra* is a modular configuration access toolkit to
   construct and integrate applications into a global,
   hierarchical key database. The building blocks are:
   - language bindings (inclusive high-level interfaces)
   - GenElektra, the code generator for type-safe bindings
   - plugins for configuration access behaviour and validation
2. *SpecElektra* is a configuration specification language
   that is easy to use and self-contained in the same key database (i.e.
   written in any of the configuration file formats Elektra supports).
3. Tools on top of LibElektra for administrators, such as CLI tools and GUIs.

See [http://libelektra.org](http://libelektra.org)

The same text as follows is also available
[here as html](http://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)
and
[here on github](https://github.com/ElektraInitiative/libelektra/blob/master/doc/NEWS.md)

## Highlights

- Elektra now allows applications to support multiple
  profiles with a plugin, thus *without code modifications* in
  Elektra applications.
  That means a user can select multiple configuration files to use,
  even if the application has no explicit support for it.
  It completes the cascading feature (level $HOME before /etc), to allows
  us also to select different configuration for the same level.
- Resolver can now better handle conflicts that happen
  when files are removed and others that happen
  within a single time tick (resolution of your clock)
  and also better handles NFS and older file systems
- Default storage and resolver can be changed by symlink.
  So no need to recompile Elektra to change the default storage
  from INI to dump.
  INI now works quite reliable as default plugin and already
  used by default by its author Thomas Waser.


## Other important features

- shell plugin allows you to execute shell commands on every KDB access
  and curlget plugin allows you to download configuration files
  from a URL during KDB access.
- Improvements in sync/merge of qt-gui with important fix
  (Usage of 0.8.15 qt-gui is discouraged)
- Add plugin for dpkg database (read-only)
- Assignment for conditionals using `assign/condition`.
- Support for multiple and nested statements
- Support for `condition/validsuffix` which allows you to suffix
  numbers with signs such as `%` or `$`.
  It does not check if the suffixes are identical.
- kdb mount now uses topological sorting to always
  find a dependency solution if there is one,
  many effort was put in that ordering is as requested, thanks to
  Thomas Waser for the topological sorting implementation
- Frontend generated by GenElektra now also can reload its
  values with taking the correct context into account.
- Source is now automatically formatted and formatting is checked on build server
- More flexible CMake syntax for PLUGINS


## Plugins

Many new or vastly improved plugins are waiting to be explored.

### curlget

The plugin curlget fetches a configuration file from a remote host before
the configuration is being accessed:

    kdb mount -R noresolver /tmp/curltest.ini system/curltest ini curlget url="https://raw.githubusercontent.com/ElektraInitiative/libelektra/master/src/plugins/ini/ini/plainini"
    kdb ls system/curltest  # every get access will redownload the file

Thanks to Thomas Waser!


### INI

The INI plugin is still under heavy development and
was again nearly rewritten:

- fixed key is below hacks
- fixed ordering
- custom delimiter
- use meta array for comments
- rewritten ordering
- best effort order
- fixed array support


Thanks to Thomas Waser!


### shell

This plugin allows you to executes shell commandos after kdbGet, kdbSet and kdbError (failing kdbSet):

    kdb mount /tmp/test.ini system/shelltest ini array= shell 'execute/set=echo set >> /tmp/log,execute/get=echo get >> /tmp/log'
    kdb set system/shelltest
    cat /tmp/log

Thanks to Thomas Waser!


### validation

The validation plugin is not new, but got many new features.
It allows you to match values by a regex and set your own
error messages in case a validation did not match.

Up to now, the regex was given as is to regcomp, which means
that if the regex is contained *anywhere* in the value, the
value is accepted.

Often this is not what we want, thus Thomas Waser added special
support for icase, word and line validation.
Additionally, flags allow you now to ignore the case or invert
the match. This can be changed for every individual value
or for the whole mountpoint.

Additionally, `kdb vset` validation was updated to use the new
metadata and correctly match against the whole value.

Thanks to Thomas Waser!


### hosts

Only minor improvements were necessary for the host plugin but
it is quite matured already. The contract was changed so that
ipv6 addresses for ipv4 addresses will be rejected:

```
# kdb mount --with-recommends /etc/hosts system/hosts hosts
# kdb set system/hosts/ipv4/localhost ::1
The command set failed...
Reason: localhost value: ::1 message: Address family not supported
# kdb set system/hosts/ipv6/localhost ::1
```

You can also comfortably and safely edit the hosts file
with: `kdb editor system/hosts hosts`, then you have the
functionality `sudoedit` for the hosts file.




### rename

Again not a new plugin, but the plugin was greatly improved
and many test cases were added.

Now you can set upper/lowercase individually for both sides:

1. What applications see.
2. What the configuration file contains.

For example, if you always want the keys in the configuration file upper case,
but for your application lower case you would use:
```
$ kdb mount caseconversion.ini /rename ini rename get/case=tolower,set/case=toupper
$ kdb set user/rename/section/key valu
$ cat ~/.config/caseconversion.ini
[SECTION]
KEY = value
```

Thanks to Thomas Waser!



### Resolver

Resolving by ~ as home directory now also for system and spec namespaces,
thanks to Thomas Waser.

Files keep their previous owner, useful when root edits configuration
files of others, thanks to Thomas Waser.

The resolver has many improvements to better detect conflicts.

The lock is now extended longer after the commit and already requested
in the temporary file.

The warnings were improved when `getcwd` fails.

Resolver now can correctly handle conflicts with empty files.  It can also
better cope with frequent commits of the same binary.  Elektra already
reached some limits filesystems have.










## Bindings

### Java

Marvin Mall improved the Java binding, fixed the appending
of keysets, added lots of documentation, and many unit tests.


### C++

Some kind of misusage of vaargs is now detected at compile-time instead
of crashing at runtime.


### Generated C++

Value now supports convenience activations.
Values can be used to activate context, no more layers are needed.
Topological sorting makes sure that values are activated in the
correct order, loops are not allowed anymore.

The `bool operator<` is now correctly inline (allows to use it in more than
one translation unit)




## Documentation

René Schwaiger<sanssecours> reworked most of the documentation and
fixed countless spelling mistakes and other problems.

- Peter Nirschl updated the status of the crypto-plugin
  and fixed a typo
- Daniel Bugl wrote a cascading tutorial
- Daniel Bugl fixed all broken links
- René Schwaiger also drew a new logo with SVG.
  It is already used on github as avatar for the organisation.
- make all é use the same code point 233.


## Testing

- Tests work if the build path contains spaces
- Tests: Fix problems locating memory checker
- remove obsolete TestScript.cmake

Thanks to René Schwaiger



## Maintainer

By default now ALL plugins except EXPERIMENTAL are included.
Plugins will be automatically excluded if dependencies are missing.

The PLUGINS syntax was vastly improved.  Now many categories can be
intermixed freely and also categories can be used for exclusion.

E.g. to include all plugins without deps,
that provide storage (except yajl) and are maintained, but not include all plugins
that are experimental, you would use:

	-DPLUGINS="NODEP;STORAGE;-yajl;MAINTAINED;-EXPERIMENTAL"

Details see [/doc/COMPILE.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/COMPILE.md).


### Renamed files:

/usr/include/elektra/merging/kdbmerge.hpp ->
  /usr/include/elektra/merging/mergingkdb.hpp

/etc/profile.d/kdb -> /etc/profile.d/kdb.sh

(So that it works on arch linux, thanks to Gabriel Rauter)


### removed files:

- /usr/lib/elektra/libelektra-crypto.so

was only necessary because of limitations of the build system and is
now removed.  It never had actual functionality, but was only a stub
without a crypto provider selected.



### new files:

- /usr/include/kdbease.h
- /usr/lib/elektra4/libelektra-curlget.so*
- /usr/lib/elektra4/libelektra-dpkg.so*
- /usr/lib/elektra4/libelektra-profile.so*
- /usr/lib/elektra4/libelektra-resolver_fm_hpu_b.so
- /usr/lib/elektra4/libelektra-shell.so*

more new files with ALL or EXPERIMENTAL:

- /usr/lib/elektra/libelektra-semlock.so


new tests all in folder /usr/lib/elektra/tool_exec:
testcpp_contextual_update testkdb_conflict test_keyname testmod_curlget
testmod_dpkg testmod_jni testmod_profile testmod_semlock testmod_shell
testtool_mergingkdb


Following Plugins are excluded on specific platforms:

- mathcheck on Intel compiler (reason: failing test cases)
- simpleini on non-glibc systems (reason: not portable printf extension)


### new symlinks:

- /usr/lib/elektra4/libelektra-storage.so
- /usr/lib/elektra4/libelektra-resolver.so

### new releases

The first release of the libraries libelektratools-full, libelektratools
and libelektragetenv. They now have SOVERSION 0.





## Development

You do not need to format the source manually anymore.
Make sure that you run scripts/reformat-source before
creating a PR.

`clang-tidy` helps you to add blocks to have better
maintainable code.

Felix Berlakovich improved the performance of the augeas plugin and
also contributed a script to benchmark different host plugin.
His thesis can be downloaded from [here](http://www.libelektra.org/ftp/elektra/berlakovich2016universal.pdf).
It contains benchmarks and discussions about augeas.

The CMake function `add_plugin` was completely rewritten.
Now you do not have to register your plugin at multiple points
but instead information of README.md is parsed to correctly
register the plugin to categories as stated by `infos/status`
and `infos/provides`.

The code generator for errors also yields macros. This
avoids usage of the IDs, which can be problematic if
multiple pullrequests are prepared at once.


## Compatibility

This might be the last release supporting wheezy, because
it gets more and more time-intensive to find workarounds
for the old compiler. The C++11 regex do not work at all.

### Binary Compatibility Test

When you execute the testcases of 0.8.15 against Elektra 0.8.16
following testcases fail. None of them effect the API.

- test_splitget test_splitset .. Internal restructuring
- testmod_crypto .. not included by default now
- testmod_ini .. section handling changed, line 178:
                `nosectionkey contained no comment`
- testmod_rename .. internal API elektraKeyCreateNewName changed
- testmod_resolver .. internal data structure now contains more
                     members to remember uid and gid
- testmod_template .. not present by default
- testtool_backend testtool_backendbuilder testtool_backendparser
- testtool_specreader .. changes in KDB tool before release
- check_kdb_internal_check .. experimental plugins are now excluded


### Added API

in libease René Schwaiger added:

    extern char const * elektraKeyGetRelativeName(Key const * cur, Key const * parentKey);

in libmeta Thomas Waser added (partly based on ideas/code from Felix Berlakovich):

    extern void elektraMetaArrayAdd(Key *, char const *, char const *);
    extern KeySet * elektraMetaArrayToKS(Key *, char const *);
    extern char * elektraMetaArrayToString(Key *, char const *, char const *);
    extern int elektraSortTopology(KeySet *, Key * *);




## Tools

### Qt-gui

Raffael Pancheri fixed an important issue which broke the synchronization
because an key related to Elektra's internal version information was missing.

Felix Berlakovich updated the qt-gui so that it uses a newly written sync-method
added in libtools.

Gabriel Rauter added a desktop file that uses the new svg logo from
René Schwaiger.






## Portability

- Peter Nirschl fixed code in the resolver that uses EBADMSG which was not
  available in BSD.
- Peter Nirschl improved detection of librt
- Felix Berlakovich fixed searching of FindSystemd
- MinGW64 resolver now handles conflicts correctly and does not ignore them
  anymore and now also is able to create empty files (but still not directories)

### Mac OS X

A lot of effort was invested to all test cases also run on Mac OS X:

- .template syntax
- linking errors
- fix regex in conditionals plugins

Thanks to René Schwaiger


## Bugs

- print null-environment correctly with `kdb getenv`
- keyIs(Direct)Below didn't work with cascading keys
- fix elektraKeyGetRelativeName (needed by ni) for cascading
  keys and move it to libease, thanks to René Schwaiger
- make nickel tests show correct test name, thanks to René Schwaiger
- glib: replace cursor_t with gssize so that GElektra-4.0.gir
  builds with gobject-introspection later than 1.47, thanks to Manuel Mausz
- fixed out-of-bounds bug in timeofday plugin
- elektraMetaArrayToKS correctly adds parent key, thanks to Thomas Waser
- kdb-shell: Do not abort ksOutput on binary data.
- some rework for global hooks, still not stable


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.16.tar.gz)

- name: elektra-0.8.16.tar.gz
- size: 2405443
- md5sum: ef0c138b4a4fda017aa8bb6f812671ce
- sha1: c6a6f9c26addd5fcc274cea635de02ef680cfb1a
- sha256: 3cf0624eb027e533192ca9d612618df3d38ec3674c9cd20474f04ff269fad77e
- sha512: b225e61379907365a423ea75ec7138e5257bb78c526bb05a1ec21f66a52eb4bad9e6f1eb23209d700670b21b86166497b47c3bc46bc9d45f6d366cd544afc326


This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.16/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)

For more information, see [http://libelektra.org](http://libelektra.org)

Best regards,
Markus












# 0.8.15 Release

- guid: 1ab4a560-c286-46d2-a058-1a8e7e208fe8
- author: Markus Raab
- pubDate: Tue, 16 Feb 2016 17:47:00 +0100

In case you do not yet know about it, here is an abstract about Elektra:

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
Elektra provides a mature, consistent and easily comprehensible API.
Its modularity effectively avoids code duplication across applications
and tools regarding configuration tasks. Elektra abstracts from
cross-platform-related issues and allows applications to be aware of other
applications' configurations, leveraging easy application integration.

See [http://libelektra.org](http://libelektra.org)

## Overview

This is one of the largest release up to now. It includes many
user-visible improvements. Some highlights:

- Mounting is vastly improved:
  think about Debian's "dpkg" to "apt"-like functionality
- In previous releases you could already specify the structure
  of the configuration. Now you can also automatically enforce
  this property.
- We split the shared library `libelektra` into smaller parts.
  Now users can link against the parts of the library they need.
- As always, the ABI and API is fully forward-compatible.
- The release contains improvements in the
  [bootstrapping process](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/bootstrap.md).
- We improved the `ini`, `rename` and `crypto` plugins.
- The tool `kdb` now supports bookmarks and profiles.
- The new tool `kdb editor` allows you to edit KDB configuration in
  your favorite text editor.
- We are glad of the new packages for Debian, Arch Linux and OpenWRT.

The same text as follows is also available
[here as html](http://doc.libelektra.org/news/1ab4a560-c286-46d2-a058-1a8e7e208fe8.html)
and
[here on github](https://github.com/ElektraInitiative/libelektra/blob/master/doc/NEWS.md)


## Global Mount

Sometimes you simply want some functionality for the whole key database.
For example, you want to enable logging or notification of configuration
changes. In previous versions, you had to change every mountpoint
individually.  Even more problematic, every mountpoint created its
individual logs and notifications, without any way for someone to know
if an application has issued its last log/notification.

These problems are now solved by global plugins. The same plugins are
reused for this purpose. Also the mounting works nearly in the same way,
you only have to omit the configuration file and the mountpoint:

	kdb global-mount syslog journald dbus

Voilà, from now on every configuration change gets logged to syslog
and journald. Additionally, every application gets notified via dbus.

If you want it more verbose for debugging, you can easily do so by:

	kdb global-mount logchange counter

Which gives you detailed information to standard output which keys
were changed/edited/deleted. Additionally, Elektra counts how often
the `counter` plugin is invoked.

The underlying work for the global plugins, i.e. hooks in the core
libraries and the `list` plugin that allows us to use many plugins
without bloating the core was done by Thomas Waser.


It was already possible in earlier versions of Elektra to specify the
configuration of your program. Until now, this specification could be
mainly used to to generate code as described
[here](https://github.com/ElektraInitiative/libelektra/tree/master/src/tools/gen).
This release adds two more interesting options:

1. the spec plugin, and
2. the spec mount.



## Spec Plugin

The most important global plugin that is now newly introduced with this
release (thanks to Thomas Waser) is the `spec` plugin.  By default it
will be added for every global-mount. So for a new installation make
sure you executed at least once:

	kdb global-mount

The spec plugin is a global plugin that copies metadata from the
`spec`-namespace to other namespaces. That means, it reads the
specification, and makes sure that the configuration conforms to it. The
actual validation is done by the many validation plugins already present.

Lets start by saying a key is a long and must have at least the
value 10:

	kdb setmeta spec/example/longkey check/type long

Then we can create a key in a different namespace and see if the `spec`
plugin applies the meta-data correctly:

	kdb set /example/longkey 25
	kdb lsmeta /example/longkey

Should now at least print `check/type`.
By itself, this is useful for documentation of keys.
For example, the application developer says:

	kdb setmeta spec/example/longkey description "Do not change"
	kdb setmeta spec/example/longkey example 30

The user can retrieve this documentation by:

	kdb getmeta /example/longkey description

But we want `check/type` to be not only a documentation, but also
enforced.


## Spec Mount

Using `kdb setmeta` extensively and always looking out that all plugins
are mounted correctly is error-prone. So instead, one can directly mount
the plugins as specified.  For the example above one simply needs:

	kdb setmeta spec/example mountpoint example.ecf
	kdb spec-mount /example

Now, when we try to modify `/example/longkey` it will be validated:

	kdb set /example/longkey a
	> Error (#52) [...] long [not] matched [...] a

Based on the present meta-data, the correct plugins (in this case `type`
because of the metadata `check/type`) will be loaded.

We can also create a whole specification file, first mount the
specification and then the mountpoint according the specification, e.g
when we have `battery.ini` in the folder `$(dirname $(kdb file spec))`
with following content:

	[]
	mountpoint = battery.ini
	infos/plugins = ini

	[level]
	check/enum = 'critical', 'low', 'high', 'full'

Then we can use:

	# mount the file itself:
	kdb mount battery.ini spec/example/battery ni
	# make sure all plugins are present (e.g. enum for check/enum):
	kdb spec-mount /example/battery

Now lets verify if it worked:

	kdb lsmeta /example/battery/level
	# we see it has a check/enum
	kdb getmeta /example/battery/level check/enum
	# now we know allowed values
	kdb set /example/battery/level low
	# success, low is ok!
	kdb set /example/battery/level wrong
	# fails, not one of the allowed values!

The main idea of the spec-mount is: search a plugin for every
specification (meta-data) found in the spec-namespace.




## General Mount Improvements

In earlier versions `kdb mount` failed when plugin dependencies were
not satisfied.  Now dependencies will automatically be fulfilled, e.g.

	kdb mount /etc/modules system/modules line

In earlier versions you would have got an error because of the missing
`null` plugin. Now it simply adds the needed plugins.

The plugins given in the command-line used to be real plugins. Now also
so called providers are accepted.

To make providers useful we need to actually know which plugin is the
best candidate. To get the information we added a `infos/status` clause
in the contract. In this clause the plugin developer adds many details
how well the plugin is tested, reviewed, documented, maintained and so
on. Based on this information, the best suited plugin will be chosen.
For example, you now can use:

	kdb mount /etc/security/limits.conf system/limits augeas \
		lens=Limits.lns logging

And the best suitable logger will automatically be chosen.

The configuration variable `/sw/kdb/current/plugins` now allows
us to pass plugin configuration with the same syntax as the plugin
specification passed on the commandline. A subtle difference is that
thus the shell-splitting of arguments is missing, it is not possible to
include whitespaces in the plugin configuration that way.

Now it is also possible to include the same plugin multiple times and
also give them individual names. This feature is essential for
script-based plugins, e.g. you now might add:

	kdb mount file.x /example/mountpoint \
		lua#resolver script=resolver.lua \
		lua#storage script=storage.lua

Furthermore, `kdb mount` now supports recommendations, which can be
enabled with `--with-recommends`. E.g. supplied to the mount command
using augeas above, comments will automatically transformed to meta-data
to avoid cluttering of the real configuration.





## Library Split

Up to now, Elektra consisted only of a single shared library,
`libelektra.so`.  Not all symbols in it were relevant to end users, for
example, some were only needed by plugins. Others were only proposed and
not yet part of the stable API. And finally, other symbols were not needed
in some situations, e.g.  the plugins do not need the `kdb` interface.

Thus, we split `libelektra.so`, so that only coherent parts are in the
same library:

- `libelektra-core.so` only contains the `KeySet` data structure and
  module loading.  Every binary using Elektra should link against it.
- `libelektra-kdb.so` contains the missing `KDB` symbols. Together with
  the `core` they contain everything declared in `kdb.h`.
  Michael Zehender  plans to have multiple variants of `libelektra-kdb.so`
  that use different kinds of concurrency.
  Headerfile: `<kdb.h>`
- `libelektra-ease.so` adds functionality missing in `core` to make the
  life for C programmers easier.
  New headerfile: `kdbease.h`
- `libelektra-proposal.so` adds functionality proposed for `core`. It
  directly uses internal structures of `core`, thus they always need to
  have exactly the same version.
  Headerfile: `kdbproposal.h`


The source code is now better organized by the introduction of a `libs`
folder.  The explanation of every library can be found in
[/src/libs/](https://github.com/ElektraInitiative/libelektra/tree/master/src/libs).

The rationale of the library split is documented
[here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/library_split.md).
Shortly put, it was needed for further evolution and allowing us to grow
and enhance without getting a fat core.

Thanks to Manuel Mausz for fixing many bugs related to the library split
and also adapting all the bindings for it.

### Benchmark

To show that the split does not make Elektra slower, Mihael Pranjić made
a small benchmark. The real time of
[benchmarks/large](https://github.com/ElektraInitiative/libelektra/blob/master/benchmarks/large.c)
and revision 634ad924109d3cf5d9f83c33aacfdd341b8de17a

1. kdb-static: Median :0.8800
2. kdb-full: Median :0.8700
3. kdb: Median :0.8700

So it seems that the split does not influence the time of running
elektrified processes.

*Times were measured with time(1) and the median is calculated for 21
runs of benchmarks/large. This was done using
[scripts/benchmark_libsplit.sh](https://github.com/ElektraInitiative/libelektra/blob/master/scripts/benchmark_libsplit.sh)*


## Compatibility

As always, the ABI and API is fully forward-compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile every program without errors
(API).

We added `keyGetNamespace` which allows us to handle all namespaces
in a switch and to iterate all namespaces. This is essential, when
a new namespace is added, thus then the compiler can warn you about
every part where the new namespace is not yet considered. We currently
do not plan to add a new namespace, but better be safe than sorry.

The internal function `keyCompare` now also detects any meta-data
change.

libtools was nearly rewritten. Even though it is mostly API compatible
(you should not use the low-level `Backend` anymore but instead use the
`BackendBuilder`), it is certainly not ABI compatible.  If you have an
undefined symbol: `_ZN3kdb5tools7Backend9addPluginESsNS_6KeySetE` you need
to recompile your tool. Even the merging part has ABI incompatibility
(different size of `_ZTVN3kdb5tools7merging14NewKeyStrategyE`).
Unfortunately, we still cannot guarantee compatibility in `libtools`,
further changes are planned (e.g. implementing mounting of lazy plugins).

The python(2) and lua interfaces changed, an additional argument (the
plugin configuration) is passed to `open`.

The INI plugin was rewritten, so many options changed in incompatible ways.

The default format plugin (e.g. for import/export) is no longer hardcoded
to be `dump`.  Instead KDB_DEFAULT_STORAGE will be used.
To get KDB_DEFAULT_STORAGE you can use the constants plugin:

	kdb mount-info
	kdb get system/info/constants/cmake/KDB_DEFAULT_STORAGE

Thanks to Manuel Mausz plugins do no longer export any method other than
`elektraPluginSymbol`. It now will fail if you directly linked against
plugins and did not correctly use their public interface. Please
use the module loading and access functions via the contract.

The CMake and Pkgconfig Files now only link against `elektra-core` and
`elektra-kdb`.  If you used some symbols not present in `kdb.h`, your
application might not work anymore.

`libelektra.so` is still present for compatibility reasons.  It should
not be used for new applications.  Some unimportant parts, however,
moved to the "sugar" libraries.  E.g. the symbol `elektraKeyCutNamePart`
is no longer part of `libelektra.so`.


### Bootstrapping

When you use `kdbOpen` in Elektra as first step it reads mountpoint
configuration from `/elektra`.  This step is the only hardcoded one,
and all other places of the KDB's tree can be customized as desired
via mounting.

The bootstrapping now changed, so that `/elektra` is not part of the
default configuration `default.ecf` (or as configured with `KDB_DB_FILE`),
but instead we use `elektra.ecf` (or as configured with `KDB_DB_INIT`).
This behaviour solves the problem that `default.ecf` was read twice
(and even differently, once for `/elektra` and once for `/`).

To be fully compatible with previous mountpoints, Elektra will still read
mountpoints from `default.ecf` as long as `elektra.ecf` is not present.

To migrate the mountpoints to the new method, simply use:

	kdb upgrade-bootstrap

which basically exports `system/elektra/mountpoints`, then does `kdb rm
-r system/elektra/mountpoints` so that `default.ecf` will be without an
mountpoint and thus the compatibility mode does not apply anymore. As
last step it will import again what it exported before.

[Details are here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/decisions/bootstrap.md)




## Plugins

We already highlighted the new `spec` plugin, but also other plugins
were improved at many places.  Small other changes are:

- Conditionals now also support `assign/condition` syntax,
  thanks to Thomas Waser
- Lua and Python are not tagged experimental anymore.
  They now correctly add their configuration to the open-call.
- The plugin `yajl` (the json parser and generator) now also accepts the
  type `string` and yields better warnings on wrong types.
- Improved error message in the `type` plugin.

Larger changes were done in the following plugins:

### INI

The INI plugin was rewritten and a huge effort was taken so that it
fully-roundtrips and additionally preserves all comments and ordering.
Currently, it is brand new. It is planned that it will replace `dump`
in the future.

Currently is has some minor problems when used as KDB_DEFAULT_STORAGE.
You can avoid most problems by mounting a different file into root:

	kdb mount root.ini /

Read [here about the details](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/ini).

A huge thanks to Thomas Waser.

### Rename

Thanks to Thomas Waser `rename` is now fixed for cascading keys.
Additionally, it does not change the `sync` status of the keys so
that notification plugins work properly afterwards.

### Crypto

The crypto plugin is a facility for securing sensitive Keys by symmetric
encryption of the value. It acts as a filter plugin and it will only
operate on Keys, which have the meta-key „crypto/encrypt“ set.

The key derivation is still work-in-progress, so the plugin does not
work with kdb yet. A planned method for key derivation is to utilize
the gpg-agent.

For now the plugin requires the following Keys within the plugin
configuration in order to work properly:

1. /crypto/key - the cryptographic key (binary 256 bit long)
2. /crypto/iv  - the initialization vector (binary 128 bit long)

Please note that this method of key input is for testing purposes only
and should never be used in a productive environment!

Thanks to Peter Nirschl, especially the patience for also supporting
different platforms where dependencies need to be handled differently.


## KDB

A technical preview of a new tool was added: `kdb editor` allows you
to edit any part of Elektra's configuration with any editor and any
syntax. It uses 3-way merging and other stable technology, but it
currently does not provides a way to abort editing. So you only should
use it with care.

The tool `kdb list` now searches in the rpath for libraries and thus
will also find plugins not present at compile time (using `glob`).
Additionally, it sorts the plugins by `infos/status` score, which can
also be printed with `-v`. The last plugins printed are the ones ranked
highest.

When running as root, `kdb` will now use the `system` namespace when
writing configuration to cascading key names.

Long paths are cumbersome to enter in the CLI.  Thus one can define
bookmarks now. Bookmarks are key-names that start with `+`.  They are
only recognized by the `kdb` tool or tools that explicitly have support
for it. Applications should not depend on the presence of a bookmark. For
example, if you set the bookmark kdb:

	kdb set user/sw/elektra/kdb/#0/current/bookmarks
	kdb set user/sw/elektra/kdb/#0/current/bookmarks/kdb user/sw/elektra/kdb/#0/current

You are able to use:

	kdb ls +kdb/bookmarks
	kdb set +kdb/format ini


The kdb tool got much more robust when the initial configuration is broken,
no man page viewer is present or Elektra was installed wrongly.

The `--help` usage is unified and improved.

The new keyname naming conventions are now used for
configuration of the `kdb`-tool itself: `/sw/elektra/kdb/#0/%/`
and `/sw/elektra/kdb/#0/current/` are additionally read.  The option
`-p`/`--profile` is now supported for every command, it allows to fetch
configuration from `/sw/elektra/kdb/#0/<profile>/` instead of `current`.
KDB is more robust when it cannot fetch its own configuration due to
KDB errors.





## Coding Guidelines

Thanks to Kurt Micheli the code guidelines are
[now properly documented](https://github.com/ElektraInitiative/libelektra/blob/master/doc/CODING.md).
Thanks to René Schwaiger we also provide a style file for clang-format.

Furthermore we unified and fixed the source:
- only use @ for doxygen commands
- always use elektra* functions for allocation
- added a file header for every file

## C++11 migration

Since we now only use C++11, we applied `clang-modernize` which simplified
many loops and replaced many `0` to `nullptr`. Additionally, we added
`override` and `default` at many places.

We removed all places where we had `ifdefs` to use `auto_ptr` if no
modern smart pointer is available.

Because of these changes there is no easy way to compile Elektra without
C++11 support, except by avoiding the C++ parts all together.

The C++ `KeySet` now also supports a `get` to retrieve whole containers
at once.  By specializing `KeySetTypeWrapper` you can support your own
containers.  Currently only `map<string, T>` is supported (T is any type
supported by `Key::get`).

If you haven't removed it from your flags already, there is no use
anymore to set `ENABLE_CXX11`.

## Documentation

The documentation was improved vastly.  Most thanks to Kurt Micheli who
did a lot of editing and fixed many places throughout the documentation
Also thanks to Michael Zehender who added two paragraphs in the main
README.md.

Keynames of applications should be called `/sw/org/app/#0/current`,
where `current` is the default profile (non given). `org` and
`app` is supposed to not contain `/` and be completely lowercase.
Keynames are documented [here](/doc/help/elektra-key-names.md).
[See also here](/doc/tutorials/application-integration.md). The main
reason for long paths is the provided flexibility in the future
(e.g. to use profiles and have a compatible path for new major versions
of configuration). By using bookmarks, users should not be confronted
by it too often.

- many man pages were improved
- many typos were fixed, thanks to Pino Toscano!
- Fix documentation for kdb list, thanks to Christian Berrer
- Compilation variants are explained better,
  thanks to Peter Nirschl for pointing out what was missing
- document ronn as dependency, thanks to Michael Zehender
- fix broken links, thanks to Daniel Bugl

Thanks to Kurt Micheli, developers are now warned during compilation on
broken links in Markdown.  The output format is the same as for gcc.
Additionally, the markdown documentation of plugins now get a proper
title in the pdf and html output of doxygen.


## Qt-Gui 0.0.10

Raffael Pancheri again updated qt-gui with many nice improvements:

- update existing nodes in case the config was changed outside the gui
- safely update tree
- add update signal to metadata
- fix crash when closing the GUI
- move Actions in separate file to make main.qml less clustered
- plugins do not output messages at startup
- `BackendBuilder` is now used, which automatically takes cares of the correct ordering of plugins
- Qt 5.4 compatibility is still ensured
- C++11 is now used in Qt-Gui, too

## Packaging and Build System

Elektra 0.8.14 now in Debian with qt-gui, man pages,
thanks to Pino Toscano
[read more here](https://packages.qa.debian.org/e/elektra/news/20151215T000031Z.html)

Thanks to Gustavo Alvarez for updating and splitting the packages on
Arch Linux!

Thanks to [Harald Geyer](http://friends.ccbib.org/harald/supporting/),
Elektra is now packaged for OpenWRT.  We fixed a number of
cross-compilation issues and now officially support building against musl
libc, with one minor limitation: RPATH works differently on musl so you
need to install all plugins directly in /usr/lib/ or set LD_LIBRARY_PATH.
Report any bugs in
[Harald's OpenWRT packaging issue tracker](https://github.com/haraldg/packages).

- export errors/symbols are now called `elektra-export-symbols` and
  `elektra-export-symbols` and can be installed using `INSTALL_BUILD_TOOLS`
  (by default off).  This is needed for cross-compilation.
  Thanks to Harald Geyer for reporting.
- some header files are renamed because they endlessly included themselves
  if the header files were found in wrong order.
  Thanks to Harald Geyer for reporting.
- fixed compilation when built on more than 20 cores with >= -j15,
  thanks to Gustavo Alvarez for reporting and Manuel Mausz for analyzing
- lua 5.1 now works too (except for iterators),
  thanks to Harald Geyer for reporting.
  thanks to Manuel Mausz for adding a new FindLua.cmake
- pdf builds do not fail due to half written files,
  reported by René Schwaiger and fixed by Kurt Micheli

Read about [other packages here](https://github.com/ElektraInitiative/libelektra#packages).

## Fixes and Improvements

- 3 way merge now properly deals with binary data,
  thanks to Felix Berlakovich
- getenv: fix wrapping on powerpc, thanks to Pino Toscano
- markdownlinkconverter: fix char/int mismatch, thanks to Pino Toscano
- wresolver: use KDB_MAX_PATH_LENGTH instead of PATH_MAX,
  thanks to Pino Toscano
- Cleaning up #ifdefs that break statements, thanks to Romero Malaquias
- Daniel Bugl tested the INI plugin
- cmake list_filter was broken because of different behaviour in
  cmake_parse_arguments, thanks to Christian Berrer for reporting
- g++5.3 is now supported
- gtest does not link against pthread if not needed
- testcases that are built with BUILD_SHARED also successfully work
- kdb list works when libs are in same path as plugins,
  thanks to Harald Geyer for reporting
- fix Mac OS issues,
  thanks to Peter Nirschl, René Schwaiger and Mihael Pranjic
- fix resolver-baseflag docu, thanks to Harald Geyer for reporting
- do not create wrong directories called `(` and `)` in source,
  thanks to René Schwaiger
- fix cmake for systems where iconv is not part of libc,
  thanks to Michael Zehender and Peter Kümmel (for FindIconv.cmake)
- fix segfault in libgetenv if root keys are present
- lua: fix Key:tostring(), thanks to Manuel Mausz
- add list of [supported bindings](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings),
  thanks to Manuel Mausz


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.15.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.15.tar.gz)

- name: elektra-0.8.15.tar.gz
- size: 2338297
- md5sum: 33ec1e5982fb7fbd8893bf7b579b80f0
- sha1: 6b1fdd5aa5aaad6ba377b4bb5ef437e0c85319ff
- sha256: 6a406986cecb8d4a44485ced118ee803bc039b0824b72298e123b4dd47eb0b22
- sha512: 86a408dd546b33e3b437f92f415de7aee6a235189f9eab0762b3f44ab4c453ee369a53de10a9f5b0df1b446460b12c57c6b8b77c282648ec2a49f2328d9af13d



This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.15.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.15/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/1ab4a560-c286-46d2-a058-1a8e7e208fe8.html)

For more information, see [http://libelektra.org](http://libelektra.org)

Best regards,
Markus















# 0.8.14 Release

- guid: 519cbfac-6db5-4594-8a38-dec4c84b134f
- author: Markus Raab
- pubDate: Thu, 19 Nov 2015 17:48:14 +0100

Again we managed to release with many new features and plugins (lua, enum,
list, crypto, csvstorage, conditionals, mathcheck, filecheck, logchange)
many fixes, and especially with a vastly improved polished documentation.

## Documentation Initiative

The Documentation Initiative is a huge success and now the documentation
of Elektra is in a state where someone (preferable a linux guru),
never heard of Elektra, still can use Elektra only by reading man pages.

There are now many ways to show a man page:

- [on github](http://libelektra.org/blob/master/doc/help/kdb.md)
- [in the API docu](http://doc.libelektra.org/api/latest/html/md_doc_help_kdb.html)
- by using `kdb --help` or `kdb help <command>`
- by using `man kdb`

### Help system

Ian Donnelly wrote man pages for all the tools delivered with Elektra.
Additionally, nearly all README.md are now also converted to man pages
and also to Doxygen.

### Doxygen Filter

Kurt Micheli did an amazing work with a new doxygen filter.
The filter allows all Elektra markdown pages to be also included
in the doxygen documentation. Thus all technical concepts are now
explained in Markdown pages, this filter is essential.

But even more, the filter also includes all man pages written
for the tools, giving a nice html view for them. (In addition to
the markdown rendering on github).

Enjoy the [result](http://doc.libelektra.org/api/0.8.14/html/).

A big thanks to Kurt Micheli!

### Further Docu fixes

- getenv debugging docu was improved
- typo fix: Specify, thanks to Pino Toscano
- [Design decisions](http://libelektra.org/blob/master/doc/decisions)
  Definition of Bool, capabilities and
  Publish Subscribe (thanks to Daniel Bugl)
- Improve iconv docu
- usage examples for many plugins
- improve README for line plugin (thanks to Ian Donnelly)
- add docu about dependencies for some plugins (thanks to Ian Donnelly)
- create many new links within the documentation


## Simplicity

We shifted our [goals](http://git.libelektra.org/blob/master/doc/GOALS.md)
a bit: We want to prefer simplicity to flexibility.  Not because we
do no like flexibility, but because we think we achieved enough of it.
Currently (and in future) you can use Elektra:

- obviously as primitive key/value storage
- with specifications and dozens of plugins driven by it
- with code generation
- ...

But we cut flexibility regarding:

- namespaces are only useful for configuration (not for arbitrary key/value)
- the semantics of [metadata](http://git.libelektra.org/blob/master/doc/METADATA.ini)
- mounting functionality
- error code meanings are fixed, if a resolver detects a conflict, our defined
  error must be used
- of course ABI, API



# Qt-gui 0.0.9

Raffael Pancheri again updated his qt-gui to version 0.0.9 (beta)
with important of fixes and improvements:

- Fixes for Qt 5.5
- Handling of merge-conflicts improved
- Avoid rewriting on merge-conflicts
- Allow QML to destroy C++ owned model
- Dialog at startup
- Reduce memory footprint
- add man page

A bit thanks to Raffael Pancheri!



## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs
compiled against an older 0.8 versions of Elektra will continue to work.

The behaviour of some plugins, however, changed:

- the INI plugin, the section handling was improved.
- in the NI plugin, the symbol Ni_GetVersion vanished
- in the resolver plugin files of other namespaces which are not
  mounted are not resolved anymore

### Build System

ENABLE_CXX11 does not exist anymore, it is always on.
We do not care about 199711L compilers anymore, which
makes development easier, without losing any actually
used platform.

Some programs that are only used in-source are not installed
anymore. (by Pino Toscano)

Python and Lua plugins are enabled now in `-DPLUGINS=ALL`.

Python3 plugin was renamed to python.

## Lua Plugin

Manuel Mausz add a lightweight alternative to the python plugin:
[the lua plugin](http://libelektra.org/blob/master/src/plugins/lua/).
In a similar way, someone can write scripts, which are executed on every
access to the
[key database](http://libelektra.org/blob/master/doc/help/elektra-glossary.md).

To mount a lua based filter, you can use:

    kdb mount file.ini /lua ini lua script=/path/to/lua/lua_filter.lua

Even though it works well, it is classified as technical preview.

Thanks to Manuel Mausz for this plugin!


## Cryptography Plugin

In this technical preview, Peter Nirschl
[demonstrates how a plugin](http://libelektra.org/blob/master/src/plugins/crypto/)
can encrypt Elektra's values. In testcases it is already able to do so,
but for the end user an easy way for key derivation is missing.

A big thanks to Peter Nirschl!


## INI Plugin

The INI plugin got a near rewrite. Now it handles many situations better,
has many more options and features, including:

- preserving the order
- using keys as meta-data
- many new testcases
- fix escaping

Thanks to Thomas Waser for this work!


## Mathcheck plugin

This plugin allows you to check and even calculate keys from
other keys using an polish prefix notation.
It supports the typical operations `+ - / *` and
`<, <=, ==, !=, =>, >, :=`. To mount, check and
calculate values, one would use:

    kdb mount mathcheck.dump /example/mathcheck dump mathcheck
    kdb setmeta user/example/mathcheck/k check/math "== + a b"
    kdb setmeta user/example/mathcheck/k check/math ":= + a b"

For details [see the documentation](http://libelektra.org/blob/master/src/plugins/mathcheck/).

Thanks to Thomas Waser for this important plugin!


## List Plugin

Currently, Elektra has some limitations on how many plugins can be
added to certain
[placement](http://libelektra.org/blob/master/doc/help/elektra-plugins-ordering.md).
Because of the rapidly growing number of plugins, some combinations
are not possible anymore.

This plugin tackles the issue, by delegating the work to an arbitrary
number of subplugins. As a bonus, it works lazily and thus might avoid
the loading of some plugins all together.

Thanks to Thomas Waser for this plugin!


## Conditionals

Brings `if` inside Elektra. It lets you check if some keys have
the values they should have.

	kdb mount conditionals.dump /tmount/conditionals conditionals dump
	kdb set user/tmount/conditionals/fkey 3.0
	kdb set user/tmount/conditionals/hkey hello
	kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '3.0')" # success
	kdb setmeta user/tmount/conditionals/key check/condition "(hkey == 'hello') ? (fkey == '5.0')" # fail

For details [see the documentation](http://libelektra.org/blob/master/src/plugins/conditionals/).

Again, thanks to Thomas Waser for this plugin!

## Csvstorage Plugin

You can now mount csv-files. To mount `test.csv` simply use:

    kdb mount test.csv /csv csvstorage

There are many options, e.g. changing the delimiter, use header
for the key names or predefine how the columns should be named.
For details [see the documentation](http://libelektra.org/blob/master/src/plugins/csvstorage/).

Thanks to Thomas Waser!

## Filecheck plugin

This plugin lets you validate lineendings, encodings, null, bom and
unprintable characters.

The also new plugin lineendings is already superseded by the filecheck
plugin.

Thanks to Thomas Waser!

## Enum plugin

The Enum plugin checks string values of Keys by comparing it against a
list of valid values.

Thanks to Thomas Waser!


## Elektrify Machinekit.io

We are proud that [Machinekit](http://www.machinekit.io/) starts using
Elektra.

Alexander Rössler is digging into all details, and already enhanced
the DBUS Plugin for their needs. DBus now can emit a message for every
changed key.

A big thanks to Alexander Rössler!


## Bugfixes

- libgetenv did not reinitalized its mutexes on forks
- add needSync also in C++ binding
- handle removed current working directories (fallback to /)
- avoid segfault on missing version keys (when doing `kdb rm system/elektra/version`)
- fix glob plugin + kdb mount with
  [config/needs usage](http://libelektra.org/blob/master/doc/help/elektra-contracts.md)
- fix different handling of strerror_r in Mac OS X (thanks to Daniel Bugl)
- do not change the users parentKey in early-error scenarios
- do not try to interpret some binary keys as function keys


## Other Gems

- getenv example: do not link to elektra/elektratools,
  thanks to Pino Toscano
- fixes in other examples
- avoid useless UTF-8 chars and fix typos, thanks to Kurt Micheli
- fix kdb check return code (open fail)
- pdf now also allows UTF-8 characters if added to
  elektraSpecialCharacters.sty, thanks to Kurt Micheli
- libgetenv: lookup also used for layers
- handle wrong arguments of metals better, thanks to Ian Donnelly
- Improvement of error messages in the augeas plugin
- `kdb set` avoids fetching unnecessary namespaces
- verbose unmount
- logchange: small demonstration plugin to show how to log added,
  removed and changed keys
- setmeta will use spec as default
- libtools: avoid useless getName, add verbosity flag for findBackend
- Improve iconv error messages
- That mount needs permissions to /etc should now really be obvious
  with new error message
- many fixes in the template for new plugins


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.14.tar.gz)

- name: elektra-0.8.14.tar.gz
- size: 2252008
- md5sum: a87cd3845e590bf413959dfd555e3704
- sha1: 2360603c347ae3f3a28e827eb9260ff0b9881e46
- sha256: af681a38c9c2921b8d249f98ab851c3d51371735471d8a1f833a224c4446fe2e



This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.14.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.14/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/519cbfac-6db5-4594-8a38-dec4c84b134f.html)

For more information, see [http://libelektra.org](http://libelektra.org)

Btw. the whole release happened with
[elektrify-getenv](http://libelektra.org/blob/master/src/libs/getenv/README.md)
enabled.

Best regards,
Markus

























# 0.8.13 Release

- guid: 3c00a5f1-c017-4555-92b5-a2cf6e0803e3
- author: Markus Raab
- pubDate: Thu, 17 Sep 2015 17:32:16 +0200


Again we managed to release with many new features, many fixes
and also other improvements.

## Elektrify-getenv

getenv(3) is one of the most popular ways to retrieve configuration,
even though it has many known problems:

- no standard way to modify it
- relogin (or restart of shell) necessary
- names are flat (no hierarchical structure)
- cannot be set for individual applications
- different in at, cron and similar scripts

With elektrify-getenv we wrote a solution which solves most of the
problems. We use the LD_PRELOAD technique to *additionally* retrieve
values from Elektra, and not only the environment.

You simply can do:

```bash
kdb set user/env/override/HTTP_PROXY "http://my.proxy:8080"
```

This will set the `HTTP_PROXY` environment variable to `http://my.proxy:8080`.
Configuration can be retrieved with `kdb get`:

```bash
kdb get user/env/override/HTTP_PROXY
lynx   # or start another www-browser with the newly set HTTP_PROXY
```

Or using the man pages:

    kdb elektrify-getenv man man --elektra:MANWIDTH=40

Will use MANWIDTH 40 for this invocation of man man.
This feature is handy, if an option is only available
by environment, but not by command-line arguments,
because sometimes environment variables are not trivial
to set (e.g. in Makefiles).

Some more examples:

    kdb set user/env/override/MANOPT -- "--regex -LC"
    kdb elektrify-getenv getenv MANOPT   # to check if it is set as expected
    kdb getenv MANOPT   # if /etc/ld.so.preload is active


So is this the final solution for configuration and manual elektrification
of applications is not needed anymore?

The answer is: no and yes.

It is quite satisfactory for configuration that is inherently sharable
(not different from one application to another) *and* needs the environment
semantics, i.e. some subprocesses should have different configuration
than others, e.g. in a specific terminal.

But it might not be a good solution for your own application, because
libgetenv(3) implies many architectural decision, that other elektrified
applications would decide differently, e.g.:

- it uses global variables (getenv(3) has no handle)
- it uses mutex for multi-threading safety
- the API getenv(3) only returns `char*` and has no support for other data types

For more information see [src/libgetenv/README.md](http://git.libelektra.org/blob/master/src/libs/getenv/README.md)




## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs compiled against an
older 0.8 versions of Elektra will continue to work.

Because `keyUnescapedName` and `keyGetUnescapedNameSize` is added in this release, it is not backward-compatible,
i.e. programs compiled against 0.8.13, might *not* work with older 0.8 libraries.

The function `keyUnescapedName` provides access to an unescaped name, i.e. one where `/` and `\\` are
literal symbols and do not have any special meaning. `NULL` characters are used as path separators.
This function makes it trivial and efficient to iterate over all path names, as already exploited
in all bindings:

 - [jna (java)](http://git.libelektra.org/blob/master/src/bindings/jna/HelloElektra.java)
 - [lua](http://git.libelektra.org/blob/master/src/bindings/swig/lua/tests/test_key.lua)
 - [python2](http://git.libelektra.org/blob/master/src/bindings/swig/python2/tests/testpy2_key.py)
 - [python3](http://git.libelektra.org/blob/master/src/bindings/swig/python/tests/test_key.py)

Other small changes/additions in bindings:

- fix key constructor, thanks to Manuel Mausz
- add copy and deepcopy in python (+examples,+testcases), thanks to Manuel Mausz
- dup() in python3 returned wrong type (SWIG wrapper), thanks to Toscano Pino for reporting, thanks to Manuel Mausz for fixing it

Doxygen 1.8.8 is preferred and the configfile was updated to this version.

The symbols of nickel (for the ni plugin) do not longer leak from the Elektra library.
As such, old versions of testmod_ni won't work with Elektra 0.8.13.
A version-script is now in use to only export following symbols:

- kdb*
- key*
- ks*
- libelektra* for module loading system
- elektra* for proposed and other functions (no ABI/API compatibility here!)

In this release, ENABLE_CXX11 was changed to `ON` by default.

Note that in the next release 0.8.14 there will be two changes:

- According to [issue #262](http://git.libelektra.org/issues/262), we plan to remove the option ENABLE_CXX11
  and require the compiler to be C++11 compatible.
  If you have any system you are not able to build Elektra with -DENABLE_CXX11=ON (which is
  the default for 0.8.13) please report that immediately.
- the python3 bindings will be renamed to python

By not having to care for pre-C++11 compilers, we hope to attract more developers.
The core part is still in C99 so that Elektra can be used on systems where libc++ is not available.
Many new plugins are still written in C99, also with the purpose of not depending on C++.


## Python Plugins

A technical preview of [python3](http://git.libelektra.org/blob/master/src/plugins/python)
and [python2](http://git.libelektra.org/blob/master/src/plugins/python2) plugins has been added.

With them its possible to write any plugin with python scripts.

Note, they are a technical preview. They might have severe bugs
and the API might change in the future.
Nevertheless, it is already possible to, e.g. develop storage plugins
with it.

They are not included in `ALL` plugins.  To use it, you have to specify it:

    -PLUGINS="ALL;python;python2"

Thanks to Manuel Mausz for to this work on the plugins and the patience in all
the last minute fixes!


## Qt-gui 0.0.8

The GUI was improved and the most annoying bugs are fixed:

- only reload and write config files if something has changed
- use merging in a way that only a conflict free merge will be written, thanks to Felix Berlakovich
- made sure keys can only be renamed if the new name/value/metadata is different from the existing ones
- fixed 1) and 2) of #233
- fixed #235
- fixed qml warning when deleting key
- fixed qml typerror when accepting an edit

A big thanks to Raffael Pancheri!


## KDB Tool

The commandline tool `kdb` also got some improvements.
Most noteworthy is that `kdb get -v` now gives a complete trace for
every key that was tried. This is very handy if you have a complex
specification with many fallback and override links.

It also shows default values and warnings in the case of context-oriented
features.

Furthermore:

- Add `-v` for setmeta
- Copy will warn when it won't overwrite another key (behaviour did not change)
- improve help text, thanks to Ian Donnelly

## Documentation Initiative

As Michael Haberler from [machinekit](http://www.machinekit.io/) pointed out it was certainly not easy for someone
to get started with Elektra. With the documentation initiative we are going to change that.

- The discussion in [github issues](http://git.libelektra.org/issues) should clarify many things
- We start writing man pages in ronn-format(7), thanks to Ian Donnelly for current work
- Kurt Micheli is woring on improved doxygen docu + pdf generation
- Daniel Bugl already restructed the main page
- Daniel Bugl also improved formatting
- doc: use @retval more, thanks to Pino Toscano
- doxygen: fix template to use `@` and not `\\`.
- SVG logo is preferred, thanks to Daniel Bugl
- doc: use @retval more, thanks to Pino Toscano
- many typo fixes, thanks to Pino Toscano
- fix broken links, thanks to Manuel Mausz, Daniel Bugl and Michael Haberler

Any further help is very welcome! This call is especially addressed to beginners in Elektra because
they obviously know best which documentation is lacking and what they would need.


## Portability

`kdb-full` and `kdb-static` work fine now for Windows 64bit, thanks to Manuel Mausz.
The wresolver is now more relaxed with unset environment.

All issues for Mac OS X were resolved. With the exception of elektrify-getenv
everything should work now, thanks to Mihael Pranjic:

- fix mktemp
- testscripts
- recursive mutex simplification
- clearenv ifdef

and thanks to Daniel Bugl:

- RPATH fixed, so that `kdb` works

furthermore:

- fix `__FUNCTION__` to `__func__` (C99), thanks to Pino Toscano
- avoid compilation error when JNI_VERSION_1_8 is missing
- fix (twice, because of an accidental revert) the TARGET_CMAKE_FOLDER, thanks to Pino Toscano

Thanks to Manuel Mausz for to testing and improving portability!


## Packaging and Build System

- [0.8.12 packaged+migrated to testing](https://packages.qa.debian.org/e/elektra/news/20150726T155000Z.html), thanks to Pino Toscano
- fix build with external gtest, thanks to Pino Toscano
- switch from FindElektra.cmake to ElektraConfig.cmake, thanks to Pino Toscano
- use `cmake_parse_arguments` instead of `parse_arguments`, thanks to Manuel Mausz


## Further Fixes

- Key::release() will also work when Key holds a null-pointer
- Key::getName() avoids std::string exception
- support for copy module was introduced, thanks to Manuel Mausz
- be more POSIX compatible in shell scripts (`type` to `command -v` and avoid `echo -e`) thanks to Pino Toscano
- fix vararg type for KEY_FLAGS, thanks to Pino Toscano
- fix crash of example, thanks to Pino Toscano
- add proper licence file for Modules (COPYING-CMAKE-SCRIPTS), thanks to Pino Toscano
- fix XDG resolver issue when no given path in XDG_CONFIG_DIRS is valid
- make dbus example work again
- fix compiler warnings for gcc and clang
- fix valgrind suppressions
- Installation of GI binding is fixed, thanks to Dāvis
- make uninstall is fixed and docu improved


## Notes

There are some misconceptions about Elektra and semi structured data (like XML, JSON).
Elektra is a key/value storage, that internally represents everything with key and values.
Even though, Elektra can use XML and JSON files elegantly, there are limitations what
XML and JSON can represent. XML, e.g., cannot have holes within its structure, while this
is obviously easily possible with key/value. And JSON, e.g., cannot have non-array entries
within an array. This is a more general issue of that configuration files in general
are constrained in what they are able to express. The solution to this problem is
validation, i.e. keys that does not fit in the underlying format are rejected.
Note there is no issue the other way round: special characteristics of configuration
files can always be captured in Elektra's metadata.



## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.13.tar.gz)

- name: elektra-0.8.13.tar.gz
- size: 2141758
- md5sum: 6e7640338f440e67aba91bd64b64f613
- sha1: ca58524d78e5d39a540a4db83ad527354524db5e
- sha256: f5c672ef9f7826023a577ca8643d0dcf20c3ad85720f36e39f98fe61ffe74637



This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.13/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/3c00a5f1-c017-4555-92b5-a2cf6e0803e3.html)

For more information, see [http://libelektra.org](http://libelektra.org)

Best regards,
Markus


















# 0.8.12 Release

- guid: 98770541-32a1-486a-98a1-d02f26afc81a
- author: Markus Raab
- pubDate: Sun, 12 Jul 2015 20:14:09 +0200

Again we managed to release with new features, many build system
fixes and also other improvements.

## dir namespace

This namespace adds per-project or per-directory (hence the name) configurations.
E.g. think how git works: not only /etc and ~ are relevant sources
for configuration but also the nearest .git directory.

This technique is, however, much more widely useful than just for git
repositories! Nearly every application can benefit from such a per-dir
configuration. Its almost certain that you have already run into the
problem that different projects have different guidelines
(e.g. coding conventions, languages, whitespace requirements, line breaks, ..).
Obviously, thats not a per-user configuration and
its also not a per-file issue (thats how its usually solved today).
So in fact you want, e.g., your editor to have an additional per-project layer
to choose between such settings.

The technique is useful for nearly every other tool:
- different color palettes in gimp, inkscape,..
- different languages for libreoffice
- different security settings for media players, interpreters (e.g. when in Download folder)
- per-folder .htaccess in apache or other web servers
- any other per-dir configuration you can imagine..

It is simple to use, also for the administrative side. First, change to the folder to your
folder (e.g. where a project is):

    cd ~/projects/abc

Then add some user (or system or spec) configuration to have some default.

    kdb set user/sw/editor/textwidth 72

Then verify that we get this value back when we do a cascading lookup:

    kdb get /sw/editor/textwidth

The default configuration file for the dir-namespace is `pwd`/KDB_DB_DIR/filename:

    kdb file dir/sw/editor/textwidth

- KDB_DB_DIR can be modified at compile-time and is `.dir` per default
- filename can be modified by mounting, see below, and is `default.ecf` by default

We assume, that the project abc has the policy to use textwidth 120, so
we change the dir-configuration:

    kdb set dir/sw/editor/textwidth 120

Now we will get the value 120 in the folder ~/projects/abc and its
subdirectories (!), but everywhere else we still get 72:

    kdb get /sw/editor/textwidth

Obviously, that does not only work with kdb, but with every elektrified tool.


### mount files in dir namespaces

For cascading mountpoints, the dir name is also automatically mounted, e.g.:

    kdb mount editor.ini /sw/editor ini

But its also possible to only mount for the namespace dir if no cascading mountpoint is
present already:

    kdb mount app.ini dir/sw/app tcl

In both cases keys below dir/sw/editor would be in the INI file
`.dir/editor.ini` and not in the file `.dir/default.ecf`.


### dir together with spec namespace

In the project P we had the following issue: We needed on a specific computer the
configuration in /etc to be used in favour of the dir config.

We could easily solve the problem using the specification:

    kdb setmeta spec/sw/P/current/org/base override/#0 /sw/P/override/org/base


Hence, we could create system/sw/P/override/org/base which would be in favour of dir/sw/P/current/org/base.
So we get system/sw/P/override/org/base when we do:

    kdb get /sw/P/current/org/base

Alternatively, one could also use the specification:

    kdb setmeta spec/sw/P/current/org/base namespace/#0 user
    kdb setmeta spec/sw/P/current/org/base namespace/#1 system
    kdb setmeta spec/sw/P/current/org/base namespace/#2 dir

Which makes dir the namespace with the least priority and system would be preferred.
This was less suitable for our purpose, because we needed the override
only on one computer. For all other computers we wanted dir
to be preferred with only one specification.


### Conclusion

The great thing is, that every elektrified application, automatically gets all the mentioned features.
Not even a recompilation of the application is necessary.

Especially the specification provides flexibility not present in other configuration systems.


## Qt-Gui 0.0.7

Raffael Pancheri again did a lot of stabilizing work:
- show errormessage on exception when starting gui
- Correctly update keyAreaView property when selecting item in TreeView
- Fix crash when creating key in MountingWizard
- Remove information on successful export
- Show error dialog on failed import
- Remove namefilters (every syntax can have any file extension)
- other namespaces (including dir) are included

The GUI can be handy for many purposes, e.g. we use it already as xml and json editor.
Note that there are still [some bugs](http://git.libelektra.org/issues).


## Other fixes

- constants now additionally gives information about SPEC and DIR.
- Doku about CMake variables `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD` fixed, thanks to Kurt Micheli
- Fixed compilation of `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD`, thanks to Manuel Mausz
- Example with error handling added, thanks to Kurt Micheli
- Add design decision about global plugins
- Split dependencies document to individual README.md, thanks to Ian Donnelly
- Fix nearly all compilation warnings of SWIG, thanks to Manuel Mausz
- CMake: Fix gtest to be build if `BUILD_TESTING` activated, but not `ENABLE_TESTING`
- CMake: Allow compilation without BUILD_STATIC
- Explain compilation options more, thanks to Kai-Uwe Behrmann for asking the question
- CMake: always build examples, allow one to only build documentation
- add common header file for C++ plugins (used by plugins struct and type)
- fix compilation of race tool under oS-11.4 thanks to Kai-Uwe Behrmann
- CMake: find python3 correctly
- CMake: fix BUILD_SHARED_LIBS
- Doxygen: remove `HTML_TIMESTAMP` to make build reproduceable
- Doxygen: rewrite of main page+add info about all five namespaces
- CMake: allow one to use qt-gui with qt built with -reduce-relocations
- fix kdb ls, get to list warnings during open
- during kdbOpen() use Configfile: to state phase
- add -f option to kdb check+improve docu
- improve readability of warning output
- run_all always uses dump for backups
- line plugin roundtrips correctly
- untypical resolvers have their non-existant filename handled correctly + sync ignored them correctly
- cmake-3.0 fixes
- cascading merging, a big thanks to Felix Berlakovich for the last minute fix

## Compatibility

As always, the API and API is fully compatible. Because nothing was added, its even
possible to link against an older version of Elektra (if compiled against 0.8.12).

In plugins some small changes may effect compatibility:
- in rename the handling of parent key is different (see #206)
- resolving of spec absolute and relative paths are no more handled identical.
  Instead absolute paths will be searched absolutely, while relatives are below KDB_DB_SPEC (as before).
  This behaviour is consistent to the behaviour of the other namespaces.

These two points are also the only unit tests that fail when Elektra 0.8.12 is used with 0.8.11 unit tests.


## Build Server

- special github command to build bindings "jenkins build bindings please", thanks to Manuel Mausz
- open build service update
  For [OpenSUSE, CentOS, Fedora, RHEL and SLE](https://build.opensuse.org/package/show/home:bekun:devel/elektra)
  Kai-Uwe Behrmann kindly provides packages [for download](http://software.opensuse.org/download.html?project=home%3Abekun%3Adevel&package=libelektra4).


## Get It!

You can download the release from
[here](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz)
and now also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.12.tar.gz)

- name: elektra-0.8.12.tar.gz
- size: 2102450
- md5sum: a40a33ae6661ebfa096378f0986ede6c
- sha1: 3594ef58b6e3b0ffa9589d787679b6e739fbb0dd
- sha256: 562432bea9455a61ff6e6b3263078ea9b26bef2ed177a04b5f9b181d605bc021



This release tarball now is also available
[signed by me using gpg](http://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.12/html/)


## Stay tuned! ##

Subscribe to the
[RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](http://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/98770541-32a1-486a-98a1-d02f26afc81a.html)

For more information, see http://libelektra.org

Best regards,
Markus

















# 0.8.11 Release

- guid: 7d4647d4-4131-411e-9c2a-2aca39446e18
- author: Markus Raab
- pubDate: Fri, 03 Apr 2015 02:39:37 +0200

From the beginning of the Elektra Initiative, Elektra aimed at avoiding
hard-coded information in the application and to make the application's
configuration more transparent. While avoiding any paths to files was
reality from the first released Elektra version, now also hard-coding
default values, fallback mechanisms and even Elektra's paths to keys
can be avoided.

How does that work?

Elektra 0.8.11 introduces a so called specification for the
application's configuration. It is located below its own namespace
`spec` (next to user and system).

Once the base path is known, the user can find out all Elektra
paths used by an application, using:

    kdb ls spec/basepath

Keys in `spec` allow us to specify which keys are read by the application,
which fallback it might have and which is the default value using
meta data. The implementation of these features happened in `ksLookup`.
When cascading keys (those starting with `/`) are used following features
are now available (in the meta data of respective `spec`-keys):

- `override/#`: use these keys *in favour* of the key itself (note that
    `#` is the syntax for arrays, e.g. `#0` for the first element,
    `#_10` for the 11th and so on)
- `namespace/#`: instead of using all namespaces in the predefined order,
    one can specify which namespaces should be searched in which order
- `fallback/#`: when no key was found in any of the (specified) namespaces
    the `fallback`-keys will be searched
- `default`: this value will be used if nothing else was found

This technique does not only give you the obvious advantages, but
also provides complete transparency how a program will fetch a configuration
value. In practice that means that:

    kdb get "/sw/app/#0/promise"

will give you the *exact same value* as the application uses when it
lookups the key `promise`. Many `if`s and hardcoded values are avoided,
we simply fetch and lookup the configuration by following code:

    Key *parentKey = keyNew("/sw/app/#0", KEY_CASCADING_NAME, KEY_END);
    kdbGet(kdb, ks, parentKey);

    ksLookupByName(ks, "/sw/app/#0/promise", 0);

We see in that example that only Elektra paths are hardcoded in
the application.  But those can be found out easily, completely without
looking in the source code. The technique is simple: append a
logger plugin and the KDB base path is printed to:

- stdout in the case of the plugin tracer
- syslog in the case of the plugin syslog
- journald in the case of the plugin journald

What we do not see in the program above are the default values and
fallbacks. They are only present in the so specification (namespace `spec`).
Luckily, the specification are key/value pairs, too. So we do not have
to learn something new, e.g. using the ni plugin we can specify:

    [promise]
    default=20
    fallback/#0=/somewhere/else
    namespace/#0=user

1.) When this file is mounted to `spec/sw/app/#0` we specify, that
    for the key `/sw/app/#0/promise` only the namespace `user` should be
    used.
2.) If this key was not found, but `/somewhere/else` is present, we will use
    this key instead.  The `fallback` technique is very powerful: it allows
    us to have (recursive) links between applications. In the example above,
    the application is tricked in receiving e.g. the key `user/somewhere/else`
    when `promise` was not available.
3.) The value `20` will be used as default, even if no configuration file
    is found.

Note that the fallback, override and cascading works on *key level*,
and not like most other systems have implemented, on
configuration *file level*.


## Namespaces

The specification gives the namespaces clearer semantics and
purpose. Key names starting with a namespace are connected to a
configuration source. E.g. keys starting with:

- `user` are keys from the home directory of the current user
- `system` are keys from the `/etc` directory of the current system
- `spec` are keys from the specification directory (configurable
    with KDB_DB_SPEC, typically `/usr/share/elektra/specification`)

When a key name starts with an `/` it means that it is looked up by
specification. Such a cascading key is not really present in the keyset
(except when a default value was found). They are neither received
nor stored by `kdbGet` and `kdbSet`.

Applications shall only lookup using cascading keys (starting with `/`).
If no specification is present, cascading of all namespaces is used as before.

Elektra will (always) continue to work for applications that do not have a
specification. We strongly encourage you, however, to write such a
specification, because:

- it helps the administrator to know which keys exist
- it documents the keys (including lookup behaviour and default value)
- and many more advantages to come in future releases..

For a tutorial how to actually elektrify an application and for more
background to Elektra,
[read this document](https://github.com/ElektraInitiative/libelektra/blob/master/doc/tutorials/application-integration.md).

For a full list of proposed and implemented meta-data,
[read this document](https://github.com/ElektraInitiative/libelektra/blob/master/doc/help/elektra-namespaces.md).


## Simplification in the merging framework

As it turned out the concept of very granular merge strategies was hard to understand
for users of the three-way merging framework that emerged in the last year's
GSoC. While this granularity is desirable for flexibility, we
additionally wanted something easy to use. For that reason merge
configurations were introduced. These are simply preconfigured configurations for a merger
that arrange required strategies for the most common merging scenarios. Especially
they make sure that meta merging is handled correctly.

Have a look at the changes in the example
[/src/libs/tools/examples/merging.cpp](https://github.com/ElektraInitiative/libelektra/blob/master/src/libs/tools/examples/merging.cpp)
for an glimpse of the simplifications.

A big thanks to Felix Berlakovich!

The header files will be installed to /usr/include/elektra/merging, but they are
subject to be changed in the future (e.g. as they did in this release).

From the merging improvements some minor incompatibility happened in
`kdb import`. Not all merging strategies that worked in 0.8.10 work
anymore. Luckily, now its much simpler to choose the strategies.


## API

The main API kdb.h has two added lines. First a new method was added:

    ssize_t keyAddName(Key *key, const char *addName);

This method is already used heavily in many parts. Contrary to `keySetBaseName` and
`keyAddBaseName` it allows us to extend the path with more than one Element at once,
i.e. `/` are not escaped.

The other new line is the new enum value `KEY_FLAGS`.
This feature allows bindings to use any flags in keyNew without actually
building up variable argument lists.  (Thanks to Manuel Mausz)

As always, API+ABI is stable and compatible.


## Proposed

Many new functions are proposed and can be found in
[the doxygen docu](http://doc.libelektra.org/api/0.8.11/html) and in
[kdbproposal.h](https://github.com/ElektraInitiative/libelektra/blob/master/src/include/kdbproposal.h).

Noteworthy is the method `keyGetNamespace` which allows us to query all
namespaces. Since this release we changed every occurrence of namespaces
(except documentation) with switch-statements around `keyGetNamespace`.
This allows us to add new more namespaces more easily. (Although its
currently not planned to add further namespaces.)

Finally, a bunch of new lookup options were added, which might not be
useful for the public API (they allow us to disable the
specification-aware features mentioned in the beginning).


## Obsolete and removed concepts

### umount

The concept that backends have a name (other than their mountpoint)
is now gone. Backends will simply be named with their escaped mountpath
below system/elektra/mountpoints without any confusing additional name.

Unmounting still works with the mountpath.

Removing this concept makes Elektra easier to understand and it also
removes some bugs. E.g. having mountpoints which do not differ except
having a `_` instead of a `/` would have caused problems with the
automatic name generation of Elektra 0.8.10.

Old mountpoints need to be removed with their 0.8.10 name
(`_` instead of `/`).

### directory keys

Additionally, the so called directory keys were also removed.
Elektra was and still is completely key/value based. The `/` separator
is only used for mountpoints.

### fstab

The plugin fstab is also improved: Slashes in mountpoints are
escaped properly with the internal escaping engine of keyAddBaseName()
(i.e. without any problematic `/` replacements).

### dirname

getDirName() was removed from C++, gi-lua, gi-python2, gi-python3,
swig-lua, swig-python2 and swig-python3. It was never present in C and
did not fit well with keyBaseName() (which returns an unescaped name,
which is not possible for the dirname). (Thanks to Manuel Mausz)

### invalid parent names

While empty (=invalid) names are still accepted as parentName to `kdbGet`
and `kdbSet` for compatibility reasons, but the parentKey

    Key *parentKey = keyNew("/", KEY_END);

should be used instead (if you want to get or store everything).
They have identical behaviour, except that
invalid names (that cannot be distinguished from empty names) will
produce a warning. In the next major version invalid parentNames
will produce an error.


## KDB Behaviour

It is now enforced that before a kdbSet() on a specific path a kdbGet()
on that path needs to be done. This was always documented that way and
is the only way to correctly detect conflicts, updates and missing
configuration files. Error #107 will be reported on violations.

Additionally, the handling with missing files was improved. Empty
keysets for a mountpoint now will remove a file. Such an empty file
is always up-to-date. Removing files has the same atomicity guarantees
as other operations.

The concurrency behaviour is at a very high level: as expected many processes
with many threads can each concurrently write to the key database,
without any inconsistent states: This is noted here because Elektra
works on standard configuration files without any guarding processes.

Filesystem problems, e.g. permission, now always lead to the same errors
(#9, #75, #109, #110), regardless of the storage plugin.


## Qt-Gui 0.0.6

Raffael Pancheri was very busy and did a lot of stabilizing work:

- Added markdown converter functionality for plugin documentation
- Integrated help (Whats this?)
- Added credits to other authors
- do not show storage/resolver plugins if a plugin of that kind has been selected
- added menu to newkey toolbar button to allow new array entries
- added option to include a configuration keyset when adding a plugin
- show included keys when creating the plugin configuration
- Added all storageplugins to namefilters
- Reimplement ErrorDialog
- Added undo/redo of all commands and correctly update the view
- modified ToolTip size
- Color animation on search results
- Refactored Buttons to accept shortcuts
- Updated Translations
- Colors are now customizeable
- Many small fixes

The gui is already used and the remaining small bugs (see github)
are going to be fixed soon. One of the highlights is undo for
nearly every action, so nothing prevents you from trying it out!

A huge thanks to Raffael Pancheri for his contributions. His thesis can
be found at [here](http://www.libelektra.org/ftp/elektra/pancheri2015gui.pdf).


## Bug fixing

- fix issues with escaped backslashes in front of slashes
- atomic commits across namespaces work again
- memleak on ReadFile error in ni plugin
- `kdb getmeta` reports errorcode if key, but no meta was found
- `ksLookup` now will also work if a key of the keyset is used as
    search-key (aliasing problem fixed by dup() on namelock)
- resolver regex does not match to wrongly written plugins
- jna plugin is now named libelektra-0.8.11.jar, with proper symlink to current version, for every CMake version
- fix bashism ($RANDOM)
- new keys are correctly renamed, fixes OpenICC (thanks to Felix Berlakovich)
- comments in host keys are correctly restored (thanks to Felix Berlakovich)
- output stream in type checking is no longer locale dependent (thanks to Manuel Mausz)
- cmake uninstall works again
- simplify CMAKE_DL_LIBS (thanks to Manuel Mausz)

## Further gems

- Examples were improved, added (e.g. cascading, namespace) and included in
  [Doxygen docu](http://doc.libelektra.org/api/0.8.11/html).
- [METADATA specification](https://github.com/ElektraInitiative/libelektra/blob/master/doc/METADATA.ini)
    was nearly completely rewritten (thanks to Felix Berlakovich)
- benchmarks were greatly enhanced (runtime+heap profiling),
    and some important performance improvements were done
- All plugins now use the cmake function `add_plugin`
    (thanks to Ian Donnelly for most of the work)
- data directory (keysets as C-files) is now shared between different
    kinds of test suites.
- many more tests were added, e.g. distribution tests, KDB API tests;
  and allocation tests were readded
- now all kdb commands accept cascading keys.
- More compiler warning-flags are added and many warnings are fixed
- cleanup of old unused `keyName` methods
- The key `system/elektra/mountpoints` itself was always created and a
    left-over on a freshly installed system after the unit tests run the
    first time. The physical presence of the key is now irrelevant and
    it won't be created automatically.
- Bash completion was greatly improved (thanks to Manuel Mausz)
- Configure scripts were refactored and are now much shorter (thanks to Manuel Mausz)
- New Debian build agents were added that are magnitutes faster than the old ones (a big thanks to Manuel Mausz)
- Many KDB tests, written in C, lua and python were added (thanks to Manuel Mausz)
- SWIG3 is preferred when available
- add the plugin counter that counts how often the methods of a plugin are called
- `kdb list-tools` is now advertised in `kdb --help`
- Mac OS X support was greatly improved, thanks to Peter Nirschl
  and Kai-Uwe Behrmann. The feature rich resolver, now also works
  for Mac OS X.  wresolver is now only needed for mingw.
- Elektra still compiles with gcc (also mingw variants), icc and clang.


## Further Notes

With 471 files changed, 27978 insertions(+), 11512 deletions(-) this
release is huge. With 773 commits over four month much more changes
happened which did not find their place in these release notes, even
though the notes are much less detailed than usual.

Thanks for all contributions that are not enlisted here!

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
or elektra@markus-raab.org.


## Get It!

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.11.tar.gz)

- name: elektra-0.8.11.tar.gz
- size: 2022129
- md5sum: c53a8151aab760851842d745e904a4f8
- sha1: d7929d17d1a6529089d156f1910d87f678b84998
- sha256: c20fefcfba62cc906228f9b55d1f411ef8f884ff9d75774a0dd4f8eb8f5b48f6



This release tarball now is also available
[signed by me using gpg](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.11.tar.gz.gpg)

already built API-Docu can be found [here](http://doc.libelektra.org/api/0.8.11/html/)


## Stay tuned! ##

Subscribe to the
[new RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/7d4647d4-4131-411e-9c2a-2aca39446e18.html)

For more information, see http://www.libelektra.org

Best regards,
Markus








# 0.8.10 Release

- guid: 6ce57ecf-420a-4a31-821e-1c5fe5532eb4
- author: Markus Raab
- pubDate: Tue, 02 Dec 2014 18:37:51 +0100

Hello,

we are delighted to announce our latest feature release providing
major updates in:

- compatibility with standards,
- tooling,
- plugins (hosts, rename),
- Qt-Gui and
- a new Java binding



## XDG Compatibility

Elektra now is
[fully XDG 0.8](http://standards.freedesktop.org/basedir-spec/basedir-spec-0.8.html)
compliant. Following changes were necessary:

- newly created configuration files for user/ now have the permissions
  0600
- newly created configuration directories for user/ now have the
  permissions 0700
- existing configuration files will retain their permissions.
- The default path to store user configuration is now ~/.config
- A new resolver variant x (for user and system) is introduced
 - implements handling of XDG environment variables
 - ignores empty dirs and absolute paths in envvar
- add new shell based test suite for (xdg)-resolver

For example, we could use resolver_fm_xhp_x:

    kdb mount --resolver=resolver_fm_xhp_x file.dump /example dump
    kdb file user/example
    kdb file system/example

Will show you that for both user+system the resolver respects
XDG environment variables, e.g. above lines will print:

    /home/m/.config/file.dump
    /etc/xdg/file.dump

Of course, any attempts to get and set keys below user/example and
system/example will also be in these files.

The letters after _ describe the variant of the resolver:

- f .. file based locking
- m .. mutex based locking (for multiple KDB per process)
- for user configuration (after next _)
 - x .. first check XDG_CONFIG_HOME environment
 - h .. then check HOME environment
 - p .. then fall back to passwd
- for system configuration (after next _)
 - x .. check all paths in XDG_CONFIG_DIRS and falls back to /etc/xdg

A lot of such resolver variants are added when -DPLUGINS=ALL is used.
Of course you can create new variants with different behaviour by adding
them to PLUGINS.

To make your application (that uses Elektra) XDG aware, you have nothing
to do: you get it to free. Make sure to always use cascading lookup.
Additionally, an XDG conforming application should not write system/
keys.




## OpenICC Compatibility

Based on that, Elektra now also implements the draft for
[the OpenICC specification](http://www.openicc.info/wiki/index.php?title=OpenICC_Configuration_0.1).

The mount command looks like quite complicated, but it consists of
simple parts:

    kdb mount --resolver=resolver_fm_xhp_x \
      color/settings/openicc-devices.json /org/freedesktop/openicc \
      yajl rename cut=org/freedesktop/openicc

We already know the first two lines: we use the XDG resolver already
introduced above. Only the file name and the path where it should be
mounted differs.

The plugin yajl is a storage plugin that reads/writes json. The plugin
rename was the missing link to support OpenICC (thanks to Felix
Berlakovich for closing this gap). It is needed, because every OpenICC
file starts like this:

    { "org": { "freedesktop": { "openicc": {

Because the backend is mounted at /org/freedesktop/openicc, it would
lead to keys below /org/freedesktop/openicc/org/freedesktop/openicc
which we obviously do not want. So we simply get rid of the common
prefix by cutting it out using the rename plugin.

Of course this renaming functionality can be used in every situation and
is not limited to OpenICC.




## Tools

A large number of old and new tools were added, mostly for convenience
e.g.:

    kdb mount-openicc

saves you from writing the long mount command we had in the previous
section.

To get a list of all tools that are installed, now the command (which is
also an external tool and as such currently not displayed in kdb --help):

    kdb list-tools

is available. Do not be surprised: on typical installations this will
be a large list. You can run each of these tools by using kdb <command>.
Most of the tools, however, are part of the test suite,
which you can run using:

    kdb run_all

Other tools are "old friends", e.g. convert-fstab written in 2006 by Avi
Alkalay still works:

    kdb convert-fstab | kdb import system/filesystems xmltool

It will parse your /etc/fstab and generate a XML. This XML then can be
imported. Other convert tools directly produce kdb commands, though.

kdb now uses KDB itself for many commands:

- /sw/kdb/current/resolver .. You always want a different default
    resolver than that was compiled in as default when mounting
    backends?
- /sw/kdb/current/format .. If you are annoyed by the default format
    dump format for import/export.
- /sw/kdb/current/plugins .. If you always forget to add some plugins
    when mounting something.

By default the plugin "sync" is added automatically (it makes sure that
fsync is executed on config files, the directory is already done by the
resolver), you should not remove it from /sw/kdb/current/plugins
otherwise the next mount command will not add it. To preserve it use a
space separated list, e.g.:

    kdb set user/sw/kdb/current/plugins "sync syslog"

Last, but not least, kdb get now supports cascading get:

    kdb get /sw/kdb/current/plugins

This feature allows you to see the configuration exactly as seen by the
application.

Other options:

- -123 options for hiding nth column in `kdb mount`
- hide warnings during script usage of `kdb mount`
- -0 option accepted in some tools (null termination)
- Mount got a new -c option for backend configuration. For example
  -c cut=org/freedesktop/openicc would be the parameter cut for all
  plugins. Have a look at #146 if you want to use it.



## Compatibility

The core API (kdb.h), as always, stayed API/ABI compatible. The only
changes in kdb.h is the addition of KEY_CASCADING_NAME and
KEY_META_NAME. So applications compiled against 0.8.10 and using these
constants, will not work with Elektra 0.8.9.

The constants allow us to create following kinds of keys:

- empty names: this was always possible, because invalid names
  (including empty names) did not cause keyNew to abort
- meta names: this is a new feature that allows us to compare key names
  with meta keys
- cascading names: names starting with / have the special meaning that
  they do not specify which namespace they have. When such names are
  used for
  - kdbGet() and kdbSet() keys are retrieved from all namespaces
  - ksLookup() keys are searched in all namespaces
  - ksLookupByName() is now just a wrapper for ksLookup().
      The method does not do much except creating a key and passing
      them to ksLookup().

Usage in C is:

    Key *c = keyNew("/org/freedesktop", KEY_CASCADING_NAME, KEY_END);
    Key *m = keyNew("comment/#0", KEY_META_NAME, KEY_END);

The same functionality exists, of course, in available in all bindings,
too.

Changes in non-core API are:

- xmltool now does not output default (unchanged) uid,gid and mode
- ksLookupBySpec from kdbproposal.h was removed, is now integrated into
    ksLookup
- extension keyNameGetNamespace was removed
- the hosts comment format has changed
- the default resolver has changed (uses passwd)
- kdb::tools::Backend::Backend constructor, tryPlugin and addPlugin
  have changed:
 - mountname is now automatically calculated
 - addPlugin allows us to add a KeySet to validate plugins with different
     contracts correctly
- C++ binding now throws std::bad_alloc on allocation problems (and not
  InvalidName)


## CMake

It is now possible to remove a plugin/binding/tools by prefixing a name
with "-".  The new "-element" syntax is accepted by TOOLS, BINDINGS and
PLUGINS. It is very handy in combination with ALL, e.g.:

    -DPLUGINS="ALL;-xmltool"

will include all plugins except xmltool.



## Improved comments

Comment preserving was improved a lot. Especially, the hosts plugin was
rewritten completely. Now multiple different comment styles can be
intermixed without losing information. E.g. some INI formats support
both ; and # for comments. With the new comments it is possible to
preserve that information and even better: applications can iterate
over that information (meta data).

To mount the new hosts plugin use (if you already have mounted it, you
have nothing to do):

    kdb mount /etc/hosts system/hosts hosts

The hosts plugin now seperates from ipv4 and ipv6 which makes the host
names canonical again, e.g.:

    kdb get system/hosts/ipv4/localhost
    kdb get system/hosts/ipv6/localhost

To access the inline-comment, use:

    kdb getmeta system/hosts/ipv4/localhost "comment/#0"

For other meta information, see:

    kdb lsmeta system/hosts/ipv4/localhost

Additionally, a small API for specific meta-data operations emerges.
These operations will be moved to a separate library and will not stay
in Elektra's core library.



## Proposal

- lookup options:
 - KDB_O_SPEC uses the lookup key as specification
 - KDB_O_CREATE creates a key if it could not be found
- elektraKeyGetMetaKeySet creates a KeySet from meta data
- elektraKsFilter allows us to filter a KeySet arbitrarily (not only
    keyIsBelow in case of ksCut). It reintroduces more functional
    programming.
- keyGetNamespace was reintroduced. In one of the next versions of
  Elektra we will introduce new namespaces. keyGetNamespace allows the
  compiler to output a warning when some namespaces are not handled in
  your C/C++ code.



## Java binding

Elektra now fully supports applications written in Java and also Plugins
written in the same language.

The
[new binding was developed using jna.](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/jna)
For the
[plugin interface JNI](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/jni)
was used.
We developed already
[some plugins](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/jna/elektra/plugin).


## Qt-Gui

Raffael Pancheri released the version 0.0.2 of the Qt-Gui:

* added Backend Wizard for mounting
* user can hover over TreeView items and quickly see keyname, keyvalue
  and metakeys
* it is now easily possible to create and edit arrays
* added header to MetaArea for better clarity
* many small layout and view update fixes


## Further stuff and small fixes

- Two new error/warnings information: mountpoint and configfile.
    It is added automatically and all tools will print it.
- C++ I/O for key(s) now allows null terminator next to new-line
    terminator
- fix error plugin: now use on_open/trigger_warnings to be consistent
- fix metaset: now correctly append new key
- arrays are also available when compiled with mingw
   (but tests still have to be excluded for successful compilation)
- fix #136
- fix long help text in `kdb check`
- signed release tags are now used


## Get It! ##

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.10.tar.gz)

- size: 1915277
- md5sum: 2b16a4b555bc187562a0b38919d822a1
- sha1: 08b1d0139fc5eb0d03c52408478e68b91b1825dc
- sha256: 526e2ed61e87d89966eb36ddad78d8139b976e01ce18aab340d8a1df47132355

already built API-Docu can be found
[here](http://doc.libelektra.org/api/0.8.10/html/)


## Stay tuned! ##

Subscribe to the
[new RSS feed](http://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

[Permalink to this NEWS entry](http://doc.libelektra.org/news/6ce57ecf-420a-4a31-821e-1c5fe5532eb4.html)

For more information, see http://www.libelektra.org

Best regards,
Markus











# 0.8.9 Release

- guid: 38640673-3e07-4cff-9647-f6bdd89b1b08
- author: Markus Raab
- pubDate: Tue, 04 Nov 2014 10:48:14 +0100

Again we managed to do an amazing feature release in just two month.
In 416 commits we modified 393 files with 23462 insertions(+) and
9046 deletions(-).

## Most awaited

The most awaited feature in this release is certainly the *qt-gui*
developed by Raffael Pancheri. It includes a rich feature set including
searching, unmounting, importing and exporting. A lot of functionality
is quite stable now, even though its version is 0.0.1 alpha. If you find
any bugs or want to give general feedback, feel free to use the issue
tracker of the Elektra project. A screenshot can be found
[here](https://github.com/ElektraInitiative/libelektra/blob/master/doc/images/screenshot-qt-gui.png)
To compile it (together with Elektra), see the README
[here](https://github.com/ElektraInitiative/libelektra/tree/master/src/tools/qt-gui)

Manuel Mausz also has been very active and developed glib+gi bindings.
These bindings make Elektra more friendly to the glib/gtk/gnome world.
Using the gobject introspection python3 and lua bindings were developed.
Additionally he got rid of all clang warnings.

Felix Berlakovich also made progress: [the ini
plugin](https://github.com/ElektraInitiative/libelektra/tree/master/src/plugins/ini)
now supports multiline and
which can be dynamically turned on and off, i.e. during mounting
(thanks to Felix)

Last, but not least, Kai-Uwe ported Elektra to Windows7. MinGW is now
one more supported compiler (tested on build-server, see later).
Astonishingly, it was only little effort necessary:
Basically we only needed a new implementation of the resolver, which
is now called *wresolver*. Different from the *resolver* it lacks the
sophisticated multi-process and multi-thread atomicity properties. On
the plus side we now have a resolver that is very easy to study and
understand and still works as file resolver (_noresolver_ does not).


## Interfaces

ABI/API of the C-API is still completely stable even though under the
hood a lot was changed. All testcases compiled against the previous
version still run against Elektra 0.8.9.

This is, however, not the case for libtools. For MinGW porting it was
necessary to rename an enum related to merging because it conflicted
with an already defined MACRO.

For maintainers also some changes are necessary. For MinGW and to
actually use the flexibility of the new resolver variants two new CMake
Variables are introduced: KDB_DEFAULT_RESOLVER and KDB_DEFAULT_STORAGE.

More importantly for maintainers the CMake variables regarding SWIG
bindings are now abandoned in favour to the new variable BINDINGS that
works like PLUGINS and TOOLS. Just start with

	-DBINDINGS=ALL

and CMake should remove the bindings that have missing dependencies
on your system. Remember that glib and gi (i.e. *gi_python3* and
*gi_lua*) bindings were introduced, too. Additionally, the *cpp*
binding can now be deactivated if not added to BINDINGS.

Finally, the *gen* tool added a Python package called `support`.



## Other Bits

A proof of concept storage plugin `regexstore` was added. It allows one to
capture individual configuration options within an otherwise not
understood configuration file (e.g. for vimrc or emacs where
the configuration file may contain programming constructs).

Most tests now also work with the BUILD_SHARED variant (from our
knowledge all would work now, but some are still excluded if
BUILD_FULL and BUILD_STATIC is disabled. Please report issues
if you want to use uncommon CMake combinations).

A small but very important step towards specifying configuration files
is the new proposed API method ksLookupBySpec (and ksLookup implementing
cascading search). It introduces a `logical view` of
configuration that in difference to the `physical view` of
configuration does not have namespaces, but everything is below the root
"/". Additionally, contextual values now allow one to be compile-time
configured using C++-Policies. These are small puzzle pieces that will
fit into a greater picture at a later time.

A (data) race detection tool was implemented. Using it a configurable
number of processes and threads it tries to kdbSet() a different
configuration at (nearly) the same time.

With this tool the resolver could be greatly be improved (again). It now
uses stat with nanosecond precision that will be updated for every
successful kdbSet(). Even if the configuration file was modified
manually (not using Elektra) the next kdbSet() then is much more likely
to fail.  Additionally a recursive mutex now protects the file locking
mechanism.

The build server now additionally has following build jobs:

- [i386 build:](http://build.libelektra.org:8080/job/elektra-gcc-i386/):
  We had an i386 regression, because none of the developers
  seems to use i386 anymore.
- [Configure Debian Script](http://build.libelektra.org:8080/job/elektra-gcc-configure-debian/)
  Calls the scripts/configure-debian(-wheezy).
- [Local Installation:](http://build.libelektra.org:8080/job/elektra-local-installation/)
  We had an regression that local installation was not possible because
  of a bash completion file installed to /etc. This build tests if it is
  possible to install Elektra in your home directory (and calls kdb
  run_all afterwards)
- [Test bindings:](http://build.libelektra.org:8080/job/elektra-test-bindings/)
  Compiles and tests ALL bindings.
- [Mingw:](http://build.libelektra.org:8080/job/elektra-gcc-configure-mingw-w64/)
  Compiles Elektra using mingw.

Many more examples were written and are used within doxygen. Most
snippets now can also be found in compilable files:


- [keyNew examples](https://github.com/ElektraInitiative/libelektra/tree/master/examples/keyNew.c)
- [keyCopy examples](https://github.com/ElektraInitiative/libelektra/tree/master/examples/keyCopy.c)
- [C++ deep dup](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/cpp/examples/cpp_example_dup.cpp)
- [How to put Key in different data structures](https://github.com/ElektraInitiative/libelektra/tree/master/src/bindings/cpp/examples/cpp_example_ordering.cpp)
- [Mount some config files using augeas](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/mount-augeas)
- [Mount system information](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/mount-info)

Most plugins now internally use the same CMake function `add_plugin`
which makes plugin handling more consistent.

Felix converted the METADATA spec to ini files and added a proposal
how comments can be improved.

### Refactoring:

- reuse of utilities in gen code generator
- the gen support library is now in its own package (`support`)
- refactor array handling
- internal comparision functions (keyCompareByName)

### Optimization:

- lookupByName does not need to allocate two keys
- lookups in generated code
- prefer to use allocation on stack

### Fixes:

- disable cast that segfaults on i386 (only testing code was affected)
- fix keyAddBaseName in xmltool and testing code
- support non-system installation (e.g. in home directory)
- rewrote test cases to use succeed_if_same to avoid crashes on
  null pointers
- allow one to use python 2.6 for kdb gen
- improve exception messages
- use memcasecmp (fix lookup ignoring case)
- fix memory leaks (ini)
- text messages for some warnings/errors
- fix many issues regarding CMake, more variants of setting CMake
  options are now allowed.
- cmake policies fixes allow us to use cmake version > 3

## Get It! ##

You can download the release from
[here](http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.9.tar.gz)

- size: 1936524
- md5sum: 001c4ec67229046509a0cb9eda223dc6
- sha1: 79ea9b83c08ed4c347ed0100b5e0e2d3309b9d04
- sha256: e0895bba28a27fb37f36f59ef77c95235f3a9c54fb71aa6f648566774d276568


already built API-Docu can be found
[here](http://doc.libelektra.org/api/0.8.9/html/)

For more information, see http://www.libelektra.org

Best regards,
Markus







# 0.8.8 Release

- guid: eca69e19-5ddb-438c-ac06-57c20b1a9160
- author: Markus Raab
- pubDate: Tue, 02 Sep 2014 17:31:42 +0200


In this release we changed 578 files in 473 commits
(68596 insertions(+), 59260 deletions(-) compared to Elektra 0.8.7).
We assume thats the largest change set for any of Elektra's releases
up to now. It happened only within a bit more than a month up
(0.8.7 was released 28.07.2014).


## New features

GSoC finished successfully (thanks Ian and Felix)
See http://community.libelektra.org/wp for the latest results.
So Elektra now has a 3-way merging framework that is superior
to text-based merging in many scenarios (e.g. moving configuration
options within a file or with in-line comments) iff a storage plugin
creates key names that are not only line numbers.
We love to get Feedback!

Writing plugins is now even more comfortable.
A plugin writer tutorial was written (thanks Ian):
https://github.com/ElektraInitiative/libelektra/blob/master/doc/tutorials/plugins.md
The documentation was completely reworked:
http://doc.libelektra.org/api/0.8.7/html/group__plugin.html
And two new macros allow printf formating for warnings and errors
(ELEKTRA_ADD_WARNINGF and ELEKTRA_SET_ERRORF).

The ini plugin was greatly improved (tested with samba configurations
and added to ALL plugins) and the hosts plugin was rewritten to support
ipv6 properly (thanks to Felix).

The constants plugin was added and allows introspection of Elektra's
cmake variables. Because such non-file based plugins (e.g. also uname)
do not need resolving, the plugin noresolver was added. It supersedes
the success plugin.

Elektra now allows one to correctly fsync its configuration files
(sync plugin) and the folders where files are stored (resolver plugin).
Just make sure to add the "sync" plugin using kdb mount.
The resolver plugin now reads from passwd and no longer needs
environment variables.  Additionally, the resolver plugin was prepared
to support other variants by so called compilation variants.

The error plugin now allows, next to list all possible errors, to
provoke errors when opening plugins. We fixed some issues related
to plugins having errors when they initialize themselves.

So following plugins were added: sync noresolver line ini constants
Nearly all plugins now have a README.md for further information
(thanks to Ian). An overview of all plugin is on with links to them:
https://github.com/ElektraInitiative/libelektra/blob/master/src/plugins/

The kdb tools were greatly improved (thanks to Felix):
- added remount tool
- umount now also accepts mountpath
- mount allows one to specify different resolvers
- import now can use merge strategies
- check without arguments checks key database
- mount is now more verbose when validation fails

New/improved scripts/make targets (note that scripts can be executed by
kdb scriptname):
- mounting, unmounting scripts were added
- generate template for a new plugin was improved
- configure-debian was added
- added targets run_all and run_memcheck
- bash completion file now installed
- ucf integration
- merging scripts were added for the usage with ucf
- scripts doing internal checks on source of plugins


## Compatibility

This time we had to break compatibility. We did not change the ABI (your
application still will be able to use Elektra 0.8.8) and we did not
change the API (your application still will compile against Elektra). We
changed the third part of our interface: the semantic interface.

The problems were following:
keyAddBaseName/keySetBaseName did something obvious when no special
characters were in the baseName. But once there were, there are two
different interpretations what it should do:
1.) add/set a basename, so escape characters that are not canonical
    in the basename
2.) add all parts of the name given (with slashes)

The methods were used in both ways, so it was obvious that something is
very wrong. We decided that it should do what the name says, that is
add/set a basename (variant 1).

The variant 2, to add any name was added and is called keyAddName() and
added as proposal.

(Thank Felix for implementations and Manuel for investigations)

When keys are renamed after adding to a keyset is a bad thing because it
destroys the order of the keyset. This is now avoided by keyLock.
Use keyDup() to get rid of such locks.

Another, even larger, change is also about ordering of keys in keysets.
Elektra now internally has an null-terminated unescaped keyname.
Ordering of keysets will always happen on this name. The keyCmp() tool
can be used to check this order. It works very efficiently with
memcmp() and never gets confused by ASCII ordering of / (because / is
0 in the unescaped keyname).

The syntax, semantics and conventions of key names is now documented in
detail:
http://doc.libelektra.org/api/0.8.8/html/group__keyname.html

ksNew() does now return a keyset with a properly set cursor (ksRewind).

Because its always possible that software relies on bugs the
better way to deal with such a situation (as the keySetBaseName()
situation described above) is to provide the same function twice.
Manuel said he will create a prototype to introduce symbol versioning
in Elektra. With that, old customers would still receive the old
behaviour, but people compiling against a new version would get the new
behaviour. So in one of the next releases we will also avoid semantic
interface changes when there is a valid use case for it (there is none
if the program e.g.  crashes).

Symbol versioning also allows one to compile against old versions on
purpose if you do not want the new behaviour.

We have prepared an ABI-test suite, that also checks behaviour,
for that purpose, but we also improved testing in other parts:
- (New Test strategy)[/doc/TESTING.md]
- New resolver tests for conflicts (needs tty)

If you try to execute test_ks from 0.8.7 with libelektra 0.8.8 it will
crash, but not because of any incompatibility, but because of strcmp in
the test itself gets a null pointer. The pointer is now null, because
ksNew correctly rewinds its internal cursor (see above). Amusingly,
it says on that line 94 in test_ks.c:
  // TODO: why is the cursor here?

## API Proposals

see above for more information:
- keyAddName         ..  add key name without escaping, like keySetName
- keyUnescapedName   ..  get access to null-separated unescaped name
- keyLock            ..  to allow one to secure keys against modifications

some new ideas:
- keySetStringF      ..  printf format-style changing of the key string
- elektraKeySetName  ..  to allow one to set meta + cascading keys

elektraArrayIncName() now works correctly with empty arrays embedded in
other arrays (yajl+line plugin)

elektraArrayValidateName() was also added, thanks to Felix.

These methods are declared in the file kdbproposal.h
but do not guarantee any forms of compatibility (they might
even be removed).


## Issues

Many issues were resolved as you can see in github:
https://github.com/ElektraInitiative/libelektra/issues
Alone for the milestone 0.8.8 we closed 17 issues, including
those mentioned in "Compatibility". Other issues (not all were
tracked on github):

- fix undefined errors in kdbOpen() or kdbClose()
- Now Python 2+3 work in parallel
- python2 interpreter is found correctly (also on Arch)
- Sentinel now makes sure that you cannot forget KS_END to end ksNew
- Fixes for architecture-specific problems by Pino
- fix .pc file
- fix compilation problem with KDB_MAX_PATH_LENGTH
- tmpnam to mkstemp (security)
- make test data naming consistent (thanks Pino)
- use LIB_SUFFIX for TARGET_TOOL_EXEC_FOLDER thanks to Kai Uwe
- Fix search for boost (thank Pino)

## Other Stuff ##

Thanks to Pino Toscano Elektra 0.8.7-4 is now available in Debian
Testing: https://packages.debian.org/search?keywords=elektra
So it is only a matter of time that other (debian-based) distributions
will follow and replace the dusty Elektra 0.7.

Debian Continuous Integration http://ci.debian.net/packages/e/elektra
(thanks Pino)
greatly complement our tests running on http://build.libelektra.org:8080/

Elektra's buildserver also was improved:

 - now also compiles with icc
 - runs make run_memcheck
 - checks if plugins are added correctly in-source
 - runs ABI + behavioural tests

Raffael Pancheri now made a merge request for qt-gui
https://github.com/ElektraInitiative/libelektra/pull/103/files
in which copy, paste and delete of keys already works.
It is, however, still work in progress.

Manuel Mausz made great progress in script-based Elektra plugins. He is
also working on glib+gobject-introspection based bindings.
He investigated some issues, e.g. a crash of the python binding which
was only triggered if python3 is build with a specific flag/module
combination, see:
https://github.com/ElektraInitiative/libelektra/issues/25


## Get It! ##

You can download the release from:

http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.8.tar.gz

- size: 1644441
- md5sum: fe11c6704b0032bdde2d0c8fa5e1c7e3
- sha1: 16e43c63cd6d62b9fce82cb0a33288c390e39d12
- sha256: ae75873966f4b5b5300ef5e5de5816542af50f35809f602847136a8cb21104e2


already built API-Docu can be found here:

http://doc.libelektra.org/api/0.8.8/html/

Best regards,
Markus
