/**
 * @file
 *
 * @brief exports all available actions so they can be imported from ./actions
 *
 * @copyright BSD License (see LICENSE.md or https://www.libelektra.org)
 */

export {
  fetchInstances, INSTANCES_REQUEST, INSTANCES_SUCCESS, INSTANCES_FAILURE,
  updateInstance, INSTANCE_UPDATE_REQUEST, INSTANCE_UPDATE_SUCCESS, INSTANCE_UPDATE_FAILURE,
  deleteInstance, INSTANCE_DELETE_REQUEST, INSTANCE_DELETE_SUCCESS, INSTANCE_DELETE_FAILURE,
  createInstance, CREATE_INSTANCE_REQUEST, CREATE_INSTANCE_SUCCESS, CREATE_INSTANCE_FAILURE,
} from './instances'

export {
  fetchClusters, CLUSTERS_REQUEST, CLUSTERS_SUCCESS, CLUSTERS_FAILURE,
  updateCluster, CLUSTER_UPDATE_REQUEST, CLUSTER_UPDATE_SUCCESS, CLUSTER_UPDATE_FAILURE,
  deleteCluster, CLUSTER_DELETE_REQUEST, CLUSTER_DELETE_SUCCESS, CLUSTER_DELETE_FAILURE,
  createCluster, CREATE_CLUSTER_REQUEST, CREATE_CLUSTER_SUCCESS, CREATE_CLUSTER_FAILURE,
} from './clusters'

export {
  addInstance, unaddInstance, ADD_INSTANCE, UNADD_INSTANCE,
  addCluster, unaddCluster, ADD_CLUSTER, UNADD_CLUSTER,
  selectInstance, SELECT_INSTANCE,
} from './container'

export {
  getKey, getClusterKey, GET_KEY_REQUEST, GET_KEY_SUCCESS, GET_KEY_FAILURE,
  setKey, setClusterKey, SET_KEY_REQUEST, SET_KEY_SUCCESS, SET_KEY_FAILURE,
  deleteKey, deleteClusterKey, DELETE_KEY_REQUEST, DELETE_KEY_SUCCESS, DELETE_KEY_FAILURE,
} from './kdb'

export {
  configureInstance, CONFIGURE_INSTANCE_REQUEST, CONFIGURE_INSTANCE_SUCCESS, CONFIGURE_INSTANCE_FAILURE,
  configureCluster, CONFIGURE_CLUSTER_REQUEST, CONFIGURE_CLUSTER_SUCCESS, CONFIGURE_CLUSTER_FAILURE,
  returnToMain, RETURN_TO_MAIN,
} from './router'
