# 0.8.19 Release

- guid: 8e05231a-4f3d-488b-8dc2-5f0d5c474c39
- author: Markus Raab
- pubDate: Tue, 22 Nov 2016 22:04:59 +0100
- shortDesc: adds more tutorials, ruby bindings & cleanup of core

## What is Elektra?

Elektra solves a non-trivial issue: how to abstract configuration
in a way that software can be integrated and reconfiguration can
be automated.  Elektra solves this problem in a holistic way.
Read [why Elektra](https://master.libelektra.org/doc/WHY.md)
for an explanation of why such a solution is necessary. It can be seen as a
[virtual file system](https://master.libelektra.org/doc/BIGPICTURE.md)
for configuration files.

## Highlights

- more tutorials and getting started guides
- new Ruby bindings
- cleanup of core (only 124K for main library on Debian/amd64)

### More Tutorials

Elektra already has an open and welcoming environment, with many
interesting discussions.  It is our interest that we keep it
that way.  To make this a bit more formal we added a [code of
conduct](https://master.libelektra.org/CODE_OF_CONDUCT.md).

But without good introductions, it is easy to get lost in such
a large initiative like Elektra. Thus we focused on writing
great tutorials for this release!

- We wrote an [overview readme](https://master.libelektra.org/doc/tutorials/README.md)
- We wrote new tutorials about [mounting](https://master.libelektra.org/doc/tutorials/mount.md)
  and [validation](https://master.libelektra.org/doc/tutorials/validation.md)
  (thanks to Christoph Weber)
- We wrote a readme to shell recorder transpiler
  which allows us to execute tutorials and verify that the examples in
  them work. (thanks to Thomas Waser)
- [Lua](https://master.libelektra.org/src/plugins/lua) and
  [Python](https://master.libelektra.org/src/plugins/python)
  plugins got tutorials and better explanations!
  (Thanks to Marvin Mall)
- The [doxygen](https://doc.libelektra.org/api/0.8.19/html/) docu now also
  uses links to directories, thanks to Kurt Micheli!

Thanks to Armin Wurzinger for pointing to areas of improvement.
A big thanks to Marvin Mall, Kurt Micheli, Christoph Weber and Thomas Waser!

If you like the tutorials, we would love to read from you.
Please feel free to [start a discussion or ask a
question](https://git.libelektra.org/issues/new).
We also added a
[FAQ](https://master.libelektra.org/doc/help/elektra-faq.md)
and updated
[CONTRIBUTING](https://master.libelektra.org/.github/CONTRIBUTING.md)

### Ruby Bindings

We now provide Ruby bindings for Elektra. The bindings are based on the
C++ bindings and are generated by SWIG. A strong focus was put on a good
integration with standard Ruby features and conventions, such as naming
conventions, predicates, key and meta data iteration...

A [short introduction](https://master.libelektra.org/src/bindings/swig/ruby/README.md)
shows some basic usage scenarios.  More detailed examples can be found in the
[examples directory](https://master.libelektra.org/src/bindings/swig/ruby/examples).

A big thanks to Bernhard Denner!

### Cleanup of Core

Following methods were hidden (`static`) or removed:

- `mount*` methods
- `trie*` methods
- `backend*`
- `split*`
- `keyGetParentNameSize`
- `keyGetParentName`

These are dozens of methods and it was required to adapt
the unit tests to work with the hidden methods.

A big thanks to Kurt Micheli!

## Usability

- Improved many error messages
 - spelling
 - be more friendly to the user
 - capitalization
 - mention `sudo !!`
- `kdb set`: do not print what was not done
- `kdb editor` handles non-modified files (will not do anything)
- Be more chatty about what `kdb` does, can be disabled with `-q` or
  `/sw/elektra/kdb/#0/current/quiet`.
- Furthermore, `-v` now tells even more details (e.g. `kdb-import` outputs
  the key about to import)

## Plugins

### New

- [c plugin](https://master.libelektra.org/src/plugins/c) generates C code that represents
  configuration. This is useful for unit tests or if you need to have hard-coded
  fallback configuration in your C application.
- [base64 plugin](https://master.libelektra.org/src/plugins/base64) allows you to encode
  binary data. This is especially handy in combination with the
  [crypto plugin](https://master.libelektra.org/src/plugins/crypto)
  to avoid problems with non-printable characters in configuration files.
  (Thanks to Peter Nirschl)
- [fcrypt plugin](https://master.libelektra.org/src/plugins/fcrypt) allows you to
  fully encrypt configuration files. They are only decrypted when applications
  access them. (Thanks to Peter Nirschl)
- [required plugin](https://master.libelektra.org/src/plugins/required) rejects
  every key that is not required by an application.
- [simple spec lang](https://master.libelektra.org/src/plugins/simplespeclang) allows you
  to define metadata for [enum](https://master.libelektra.org/src/plugins/enum)
  and required in a more compact way.

### Major Enhancements

- [simpleini](https://master.libelektra.org/src/plugins/simpleini) got a configurable
  format in which it will read and write configuration files. For example, one
  can use `format=% -> %` to have `key -> value`.
- [enum](https://master.libelektra.org/src/plugins/enum) got support for multi-enums,
  i.e., multiple separated values within one value. The error reporting was improved,
  too. (Thanks to Thomas Waser)
- [glob](https://master.libelektra.org/src/plugins/glob) accepts a list of named flags
  instead of an integer value and aborts matching after first hit.
  (Thanks to Felix Berlakovich)
- [hosts](https://master.libelektra.org/src/plugins/hosts) now only accepts `ipv4` and
  `ipv6` keys.
  (Thanks to Felix Berlakovich)

## Development

In the perpetual effort to improve software quality, we made several improvements:
(This information is mainly intended for Elektra’s developers.)

- A new logger encourages developers to write more comments (`ELEKTRA_LOG`)
- `ELEKTRA_ASSERT` prints better messages on failure and does not need `&&` trick.
- get rid of previous `VERBOSE` macro at many places.
- Many assertions were added in the low-level helpers (memory management)
- Using the assertions we fixed some undefined behavior.
  (Thanks to Thomas Waser)
- added new `configure-debian-debug` and `configure-debian-log` helper scripts
- The build server now checks if builds with active logger and debugging
  work correctly.
- Improved Coding Style in crypto_botan (thanks to Peter Nirschl)
- add `external-links.txt` to `outputs`
  (The file is generated in the build directory and contains
   all external-links. To validate them, use `./scripts/link-checker`)
  (Thanks to Kurt Micheli)
- `markdownlinkconverter` handles directories correctly (using `stat`).
  (Thanks to Kurt Micheli)
- Fixed compiler warning caused by libxml2 (different behavior since 2.9.4),
  thanks to René Schwaiger
- added often used links in [main README](https://master.libelektra.org/README.md)
- Improve documentation about failing test cases and what to do about it.
- added [decisions](https://master.libelektra.org/doc/decisions/) about `plugin_variants`
  and `array`.
  (Thanks to Marvin Mall)
- Rename to metadata, metakey, mountpoint
  (Thanks to Peter Nirschl)
- std::ios_base::showbase can be used to output metadata when streaming keys (C++)
- New `infos/status`: `readonly`, `writeonly`, `limited`
  (Thanks to Marvin Mall)
- The tool `update-infos-status` orders `infos/status` and allows devs to easily add/rem
  entries.  (Thanks to Kurt Micheli)
- Automatic setting of `infos/status`: `nodoc`, `nodep`, `unittest`, `memleak`, `configurable`
  (Thanks to Kurt Micheli)
- Improve `create_lib_symlink`, add `PLUGIN` argument
  and make it useful also for other library symlinks.
- New markdown style applied to most markdown files.
  (Thanks to Marvin Mall)
- Tracer is now disabled, even for `ENABLE_DEBUG`.
  (Thanks to Marvin Mall)
- Updated [SECURITY document](https://master.libelektra.org/doc/SECURITY.md)
- Macro naming convention `ELEKTRA_`, added `kdbmacros.h`
- `ENABLE_DEBUG` also works with `clang` and `ENABLE_ASAN` now allows devs
  to additionally enable sanitizers.
  Thanks to Gabriel Rauter.

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

It is now possible to enquiry which plugins provide a specific format.
This needed changes in libtools, which got a new major revision.
Changes in the plugin's contract are fully compatible:
You can now use `storage/ini` instead of `storage ini` in `infos/provides`
which gives you the information that `ini` is a storage format (and not
anything else the plugin might provide). For compatibility reasons,
the build system still adds `storage ini` even if only `storage/ini`
is specified.

That means that `kdb mount file.json /examples/json json` still will find
`json` plugins even if they are not called `json` but
[yajl](https://master.libelektra.org/src/plugins/yajl).

Another breaking change in `libtools` is that `appendNamespace` was renamed
to `prependNamespace`.

Error messages changed a bit, so if you tried to parse them, make sure
to make the `e` of error case-insensitive (`[eE]`).

In the C++ binding, `rewindMeta` is now `const` and some methods
to check if a key is in a namespace were added.

The intercept libraries were moved to a [common
folder](https://master.libelektra.org/src/bindings/intercept).
They can now be included or excluded like other `BINDINGS`.
For consistency reasons the libraries were also renamed
(`libelektraintercept-fs.so` and `libelektraintercept-env.so.0`),
but symlinks allow you to link against their old names
(`lib/libelektraintercept.so` and `lib/libelektragetenv.so.0`).

## Package Maintainers

This information is intended for package maintainers.

- GI Bindings were removed from `BINDINGS=ALL`.
  It is recommended to use `SWIG` bindings instead, which
  will be added with `ALL`.
- Intercept libraries are part of `BINDINGS`.
  They will be added on glibc systems where `BINDINGS=ALL` is used.
- Documentation in textfiles is now installed,
  `TARGET_DOCUMENTATION_TEXT_FOLDER` was added for that purpose.
  The files are:
  - `BIGPICTURE.md`, `GOALS.md`, `LICENSE.md`, `METADATA.ini`, `SECURITY.md`, `AUTHORS`, `CONTRACT.ini`, `NEWS.md`, and `WHY.md`

Other new files are:

- Plugins: `libelektra-base64.so`, `libelektra-c.so`, `libelektra-fcrypt.so`
           `libelektra-required.so`, `libelektra-simplespeclang.so`
  (only in `EXPERIMENTAL`, not added by default, but with `ALL`)
- `site_ruby/_kdb.so` (ruby binding, only in `ALL`)
- `testcpp_keyio`, `testkdb_error`, `testmod_base64`,
  `testmod_fcrypt` (test binaries in `TARGET_TOOL_EXEC_FOLDER`)

Changed files are:

- `libelektraintercept-env.so` (renamed from `libelektragetenv.so.`, but still available as symlink)
- `libelektraintercept-fs.so` (renamed from `libelektraintercept.so`, but still available as symlink)
- version upgrade: `libelektratools.so.2`

## Portability

Elektra should work on every system that has `cmake` and a `C/C++` compiler.

For this release we increased portability to better work with macOS,
CentOS 7, and OpenSuse 42.

- macOS:
 - Travis build server now also build qt-gui
 - Support for xcode8 added (xcode6 still supported)
- fix lua != 5.2 issues (wrong output), update docu
- remove hard dependency to `pkg-config`
- remove hard dependency to version 3 of `cmake`
  (most parts still work with version 2)
- make search for swig 2 visible
- fix plugin names and mounting on OpenSuse 42.1

A big thanks to Kai-Uwe Behrmann, Mihael Pranjić and
Sebastian Bachmann.

## Fixed Issues

- simpleini: use correct error number when open file fails
- yajl: improve error message on non-utf8 text.
  (Thanks to Christoph Weber)
- drop multiple `/` from `~` paths
  (Thanks to Thomas Waser)
- fix failing testcases with `ENABLE_DEBUG` #988
  (Thanks to Thomas Waser)
- csvstorage: files in source are rewritten  #987
  (Thanks to Thomas Waser)
- fix RTLD_NODELETE for OpenBSD
  (Thanks to Thomas Waser)
- better handle adding/deleting of read-only (info) plugins.
- fix behavior of multiple plugins setting errors (first error wins,
  later errors are transformed to warnings)
  (Thanks to Thomas Waser)
- fix resolver logic for missing files
- regex string in conditionals
  (Thanks to Thomas Waser)
- use `KDB` environment variable in shell tests and fix counting of tests
  for `kdb run_all`.
- output to `stderr` for `elektrify-*` scripts
- make [desktop plugin](https://master.libelektra.org/src/plugins/desktop)
  mountable
- avoid cmake warnings in `make uninstall` (avoid `@`)
- fix quoting in ini plugin
  (Thanks to Thomas Waser)
- fix plugin names and mounting with plugin pre/postfixes
  (Thanks to Kai-Uwe Behrmann)
- mount-openicc: rename to openicc.json
  (Thanks to Kai-Uwe Behrmann)

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.19.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.19.tar.gz)

- name: elektra-0.8.19.tar.gz
- size: 2681639
- md5sum: 6669e765c834e259fb7570f126b85d7e
- sha1: 82cefe4cea58d6e6b0a99ddbda24d1b57e98d93a
- sha256: cc14f09539aa95623e884f28e8be7bd67c37550d25e08288108a54fd294fd2a8

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.19.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.19/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/8e05231a-4f3d-488b-8dc2-5f0d5c474c39.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus
