- infos = Information about the yanlr plugin is in keys below
- infos/author = René Schwaiger <sanssecours@me.com>
- infos/licence = BSD
- infos/needs = directoryvalue yamlsmith
- infos/provides = storage/yaml
- infos/recommends =
- infos/placements = getstorage
- infos/status = maintained unittest preview experimental unfinished nodoc concept discouraged
- infos/metadata =
- infos/description = This storage plugin use a parser generated by ANTLR to read YAML files

# Yan LR

## Introduction

This plugin uses ANTLR to generate a parser for the [YAML](http://yaml.org) serialization format. Apart from the hand written [lexer](yaml_lexer.cpp), all other parts of the plugin use standard ANTLR tools, such as

- an ANTLR [parser grammar](YAML.g4),
- a [listener](listener.cpp), that reacts to matches in the grammar building a key set, and
- an [error listener](error_listener.cpp) that reacts to syntax errors

.

## Examples

### Mappings

```sh
# Mount plugin to namespace `user/tests/yanlr`
sudo kdb mount config.yaml user/tests/yanlr yanlr

# Manually add some mappings to the configuration file
printf 'all : circles presuppose\n' >  `kdb file user/tests/yanlr`
printf 'hello : world\n'            >> `kdb file user/tests/yanlr`

kdb ls /tests/yanlr
#> user/tests/yanlr/all
#> user/tests/yanlr/hello

kdb get user/tests/yanlr/all
#> circles presuppose

# Store value at root of mountpoint
kdb set user/tests/yanlr 'Mount Eerie'
kdb get user/tests/yanlr
#> Mount Eerie

# Add new key-value pairs
# Yan LR actually uses the YAML Smith plugin to write data
kdb set /tests/yanlr/brand new
kdb set /tests/yanlr/brand/new eyes
kdb set /tests/yanlr/dance/gavin 'Dance!'

kdb ls /tests/yanlr
#> user/tests/yanlr
#> user/tests/yanlr/all
#> user/tests/yanlr/brand
#> user/tests/yanlr/brand/new
#> user/tests/yanlr/dance/gavin
#> user/tests/yanlr/hello

kdb get /tests/yanlr/hello
#> world
kdb get user/tests/yanlr/brand
#> new
kdb get /tests/yanlr/dance/gavin
#> Dance!

# Undo modifications to the key database
kdb rm -r user/tests/yanlr
sudo kdb umount user/tests/yanlr
```

### Arrays

```sh
# Mount plugin to cascading namespace `/tests/yanlr`
sudo kdb mount config.yaml user/tests/yanlr yanlr

# Manually add a sequences to the configuration file
printf 'primes:\n'   >  `kdb file user/tests/yanlr`
printf '  - two\n'   >> `kdb file user/tests/yanlr`
printf '  - three\n' >> `kdb file user/tests/yanlr`
printf '  - five\n'  >> `kdb file user/tests/yanlr`

kdb ls user/tests/yanlr
#> user/tests/yanlr/primes
#> user/tests/yanlr/primes/#0
#> user/tests/yanlr/primes/#1
#> user/tests/yanlr/primes/#2

kdb set user/tests/yanlr/primes/#3 seven

# Retrieve index of last array element
kdb getmeta user/tests/yanlr/primes array
#> #3

# Undo modifications to the key database
kdb rm -r user/tests/yanlr
sudo kdb umount user/tests/yanlr
```

## Limitations

- The plugin does **not support**

  - plain scalars that span **multiple lines**,
  - **special characters** inside double quoted scalars,
  - other **line endings** than `\n` (Unix line endings),
  - **block scalars**,
  - **flow collections**,
  - **tags**,
  - **anchors & aliases**,
  - **multiple documents**, and
  - document **start and end markers**

  .

- Yan LR does not provide write support for data. Please use the [YAML Smith](../yamlsmith/) plugin for that purpose.

### Comments

The [lexer](yaml_lexer.cpp) does currently tokenize comments. Consequently the [plugin grammar](YAML.g4) of the plugin does also match comments. However, the [listener](listener.cpp) does currently **ignore comments**.
