# Elektrify LCDproc

- guid: d52657b5-60da-4a21-9679-f8aacf6d6b72
- author: Markus Raab
- pubDate: Sat, 18 Mar 2017 20:43:03 +0100
- shortDesc: Elektrify LCDproc

> LCDproc is a piece of open source software that displays real-time
> system information from your `Linux`/`*BSD` box on a LCD.

LCDproc's [website](http://lcdproc.omnipotent.net/) is a bit outdated
but LCDproc itself is now well-maintained on
[GitHub](https://github.com/lcdproc/lcdproc) and had a
[release recently](https://github.com/lcdproc/lcdproc/releases).

Like in many projects, it invented its own configuration access and
INI parser which did not evolve with the needs of the project. As a
consequence inconsistencies and code duplication spread over the source.
For example, the LCDproc configuration access does not support values
that represent display's size (such as `20x4`). Thus every LCDproc's
module has its own parsing code for such values.

Some days ago (16.03.2017), we met with Harald Geyer and discussed the
current situation. We decided that we will elektrify LCDproc and remove
all the configuration access and parsing code within LCDproc.
To **elektrify** an application means to change the application so
that it uses LibElektra afterwards.

## Goals

We formulated three goals:

1. We (Elektra Initiative, mainly Thomas Waser) remove as much code
   as possible from LCDproc's code base.
2. Users of LCDproc should be able to use `LCDd.conf` as they use it now.
3. We avoid the current duplications of configuration specifications.
   (Currently in `LCDd.conf`, the docbook, in code checking the limits,
   and the default parameter in the code.)

Nice-to-have is:

- Safe updates: `make install` should not break the current `LCDd.conf`.
  (As it is already done in Debian.)
- The robustness of LCDproc on misconfiguration should be improved
  (Thomas Waser writes the specification).
- Automatic reloading of the daemon when using Elektra to update configuration.
  (Manual `SIGHUP`-signals will work in any case.)
- Have physical units with metric prefix like `500ms` for `0.5s` (seconds).

Possible limitations are:

- We break support for systems that only have very old compilers.
- The `-c` option to specify a different configuration file is
  against the abstraction Elektra should deliver. We might create a
  [wrapper script](https://github.com/ElektraInitiative/libelektra/issues/1416)
  that emulates `-c` via mountpoints.
- LCDproc will depend on the yet-to-be-released
  [0.8.20](https://github.com/ElektraInitiative/libelektra/milestone/11).
  We will delay the 0.8.20 release until all parts for LCDproc are tested and ready.

In any case, the [advertised benefits of Elektra](https://www.libelektra.org)
will automatically apply (incomplete list):

- Global key database: you can connect other configuration files with the
  LCDproc's configuration and validation.
- Allows users to easily modify the specifications, for example to have different
  command-line options, or support for environment variables.
- [Profile support](https://www.libelektra.org/plugins/profile): Having multiple
  complete configuration settings you can easily choose from. (thanks to Thomas Waser)
- Introspectibility: you can check with `kdb`-tool which configuration
  settings LCDproc will receive.
- Other configuration file formats can be used instead, e.g. JSON or XML.
  (Only if wanted as personal preference, by default INI will be used to
  remain compatibility with `LCDd.conf`.)
- Easy migration paths to use other configuration file formats such as YAML
  as default in future. (thanks to René Schwaiger)
- Elektra's tool can be used to configure LCDconf, including:
  - `kdb set` to modify individual settings within scripts and validation.
  - `kdb editor`, which spawns your favourite editor but validates
    the configuration file before writing it out.
  - `kdb qt-gui`, the Qt GUI (thanks to Raffael Pancheri).
  - The web UI of Elektra (thanks to Daniel Bugl).
- Elektra's website can be used to share LCDproc's configuration files,
  and you can use the [curlget plugin](https://www.libelektra.org/plugins/curlget)
  to mount files from the website. (thanks to Marvin Mall)
- You can use Shell, Python, or Lua to write small scripts that are executed on
  configuration access.
- Elektra allows you to directly read and write from git
  using the [git plugin](https://www.libelektra.org/plugins/gitresolver).
  (Even if `LCDd.conf` is not checked out, thanks to Thomas Waser)
- We extensively [test](https://www.libelektra.org/devgettingstarted/testing)
  Elektra with modern techniques such as fuzzing.

## Validation

Instead of `if`s within the code, we will use SpecElektra for validation.
[SpecElektra](https://www.libelektra.org/manpages/elektra-glossary)
is a configuration specification language that allows us to describe
which configuration is valid.

This specification will be installed as part of LCDproc to
`/usr/share/elektra/specifications`.
It uses the [metadata](https://www.libelektra.org/docgettingstarted/metadata)
as defined by the plugins to validate configuration changed via
Elektra.

For broken installations or when executing LCDproc from the source
repository, there is also a built-in specification. The specification
will only be used if the installed one cannot be found.

Thus the configuration validation specification is a normal configuration
file also integrated in Elektra, also the specification can be introspected:
useful for system administrators who want to know about valid entries, but
also for tools like our newly developed web-UI by Daniel Bugl.

The web-UI automatically restricts the interface so that only valid
entries can be entered. For example, if you should enter a boolean,
only a check box is presented to you.

- For more information about validation, see the [tutorial](https://www.libelektra.org/tutorials/validate-configuration)

## Code Generation

We (mainly Dominik Hofer) are currently developing
[a high-level API](https://www.libelektra.org/decisions/high-level-api),
whose first user will be LCDproc. In this API, we will make sure during
compilation, that configuration access is done correctly.

This is especially useful when configuration settings get renamed.
Then all places where out-dated configuration settings are used will fail to compile.

In particular using code generation developers do not need to use strings
to refer to configuration settings and they get easy-to-use enums consistent
with the configuration specification.

Furthermore, code generation will make sure that a specification (and default configuration settings)
will be found even if no `/etc` or no `/usr` is found.

We also found that we cannot use code generation everywhere.
In generic access code, code generation obviously is limited.

- For more information about code generation, see the [tutorial](https://www.libelektra.org/tools/gen)

## Risks

Understandably, users might be concerned that such a change will not work or create
problems in the future. Here we will discuss some of the concerns.

> Elektra might be discontinued.

From history perspective, Elektra received steady development since 2004.
Elektra is a FLOSS project and welcomes everyone to join. In the last
years several people did, with an increasing number per year.
Currently following people are working on substantial new features in Elektra
(sorted by first name):

- Armin Wurzinger: Quality Improvements
- Bernhard Denner: [Puppet Module](https://github.com/ElektraInitiative/puppet-libelektra)
- Daniel Bugl: [WebUI](https://www.libelektra.org/tools/web)
- Dominik Hofer: [the high-level API](https://www.libelektra.org/decisions/high-level-api)
- Kurt Micheli: Order Preserving Minimal Hash Map
- Markus Raab: Maintainer
- Michael Zehender: Quality Improvements
- Mihael Pranjić: mmap plugin
- Peter Nirschl: [crypto plugin](https://www.libelektra.org/plugins/crypto)
- René Schwaiger: YAML plugin
- Sebastian Bachmann: Shell Completion
- Thomas Waht: Notification
- Thomas Waser: Validation and Transformations of Configuration
- Vanessa Kos: Misconfiguration Bug Database

Obviously, there are many more casual contributors.

Elektra has a large set of [automated tests](https://build.libelektra.org)
and only a small amount of technical dept. Elektra has no required external
dependencies except libc. So without internal changes, only minimal maintenance
cost is required.

> Elektra is unfinished.

Technically this is true: we did not reach
[1.0](https://git.libelektra.org/milestone/12).
We are, however, on track to reach this goal within this summer.
Now is the best time to join because we can provide more support
and are more flexible for changes and wishes.

Some [time ago](https://www.libelektra.org/news/2016-06-14_0.8.17.md) we asked in a survey in
which direction Elektra should develop. Most open issues are (in)direct
responses from this wanted direction.

Some plugins are experimental or proof-of-concept, but they are clearly
marked as such.

> It seems a bit to me like [xkcd: Standards](https://xkcd.com/927/).

Elektra does not invent a new configuration file format nor new standards
where to store configuration files but abstracts over these issues.

> Elektra not being available in my distribution.

For the following Linux Distributions Elektra 0.8 packages are available:

- [Openwrt](https://github.com/openwrt/packages/tree/master/libs/elektra) (by Harald Geyer)
- [Gentoo](http://packages.gentoo.org/package/app-admin/elektra)
- [Arch Linux](https://aur.archlinux.org/packages/elektra/)
- [Debian](https://packages.debian.org/de/jessie/libelektra4)
- [Ubuntu](https://launchpad.net/ubuntu/+source/elektra)
- [OpenSuse](https://software.opensuse.org/package/elektra)
- PLDLinux
- [LEDE](https://lede-project.org/packages/pkgdata/libelektra-core?s[]=elektra)
- [Linux Mint](https://community.linuxmint.com/software/view/elektra-bin)

See [INSTALL](https://www.libelektra.org/docgettingstarted/installation)
for the complete and up-to-date list.

> If Elektra does not take off and achieve world dominance,
> will we be worse off than before?

Making sure that projects will not be worse off is what we did the last
years: Not only offer an API and wait for world dominance but to offer
an implementation that can compete with any configuration library out
there. We are not completely there yet (there are some details where
specific other libraries are better than Elektra in specific points)
but these are not points that the current configuration system of
LCDproc supports (not even close). And the libraries that can compete
with Elektra have a completely different level on which dependencies
they have: Elektra is the only one only requiring libc.

> Do we retain the old way of configuring things,
> i.e. manually editing an ini file in /etc?

Absolutely, you can think of libelektra as a small library in C that
reads a configuration file and returns a data structure if you do not
use any of its advanced features.

> Do we retain the old way reloading/restarting the system service?

Elektra does not interfere with restarting. It is a passive library.
It provides some techniques for reloading but they are optional (but we
recommend that you keep the in-memory and persistent configuration in
sync via notification).

For more information, see the [FAQ](https://www.libelektra.org/manpages/elektra-faq).

## Win-Win

We can both profit from it:

1. For LCDproc it will be a simplification of code while getting many more tools.
2. For Elektra it will improve its adoption and packaging.

For oyranos it already worked well on both sides, see our discussions in the issue tracker, for example [#1134](https://issues.libelektra.org/1134).

If you also maintain an free or open source (FLOSS) project with an out-dated configuration system, please contact us.

Obviously, we cannot fully port every FLOSS project ourselves, instead we will handle requests on a first come, first serve basis.
Earlier projects will also have an higher impact on the feature set of Elektra, thus you will less likely need to implement your own plugin.

## See Also

- Progress can be viewed [here](https://git.libelektra.org/projects/7)
- We discussed about alternatives to Elektra [here](https://issues.libelektra.org/1266).

Best regards,
Markus
