# Introduction

We use decision template is based on
[''using patterns to capture architectural decisions''](http://www.cs.rug.nl/~paris/papers/IEEESW07.pdf)
and [arc42 decisions](http://docs.arc42.org/section-9/)

To add a new decision copy `template.md` and add a link in the appropriate
section here.

## Implemented

- [Holes](holes.md)
- [Unit Testing](unit_testing.md)
- [Script Testing](script_testing.md)
- [Capabilities](capabilities.md)
- [Library Split](library_split.md)
- [Bootstrap](bootstrap.md)
- [Empty Files](empty_files.md)
- [CMake Plugins](cmake_plugins.md)
- [Logging](logging.md)
- [Elektra Web Structure](elektra_web.md)
- [Elektra Web Recursive Structure](elektra_web_recursive.md)
- [Cryptographic Key Handling](cryptograhic_key_handling.md)
- [Relative Storages](relative.md)
- [Deferred Plugin Calls](deferred_plugin_calls.md)
- [High Level API](high_level_api.md)
- [High-level API Help Message](highlevel_help_message.md)
- [Global KeySet](global_keyset.md)
- [Rest API Documentation](rest_api_documentation.md)
- [Ingroup Removal](ingroup_removal.md)
- [Commit Function](commit_function.md)
- [Error Message Format](error_message_format.md)
- [Default Values](default_values.md)
- [High Level API](high_level_api.md)

## Decided

- [Array](array.md)
- [Relative Storages](relative.md)
- [Definition of Boolean](boolean.md)
- [Plugin Variants](plugin_variants.md)
- [Error code implementation](error_code_implementation.md)

## In Discussion

- [Global Plugins](global_plugins.md)
- [Vendor Spec](vendor_spec.md)
- [Error codes](error_codes.md)
- [Array for Warnings](warning-array.md)

## Rejected

- [CMake spec](cmake_spec.md)
- [Null Pointer Checks](null_pointer_checks.md)
- [Elektra Web Publish Subscribe](elektra_web_pubsub.md)

## Drafts

- [Specification](specification.md)
- [Global Validation](global_validation.md)
- [Internal Cache](internal_cache.md)
