# 0.8.6 Release

- author: Markus Raab
- pubDate: Sat, 21 Jun 2014 12:00:00 +0100
- shortDesc: adds technical previews & other improvements

## Introduction

The Elektra Initiative moved to GitHub for following reasons:

- We were seriously missing a bug tracker
- It may make collaboration easier
- Build Server Integration:
  - Build on MergeRequests waits for the first merge request to be built!
  - And the build status is now published for this job

The main entrance point and URL for any advertisement and linking stays

https://www.libelektra.org

(which points to GitHub at the moment).

Additionally (not related to GitHub), we now have a
[LCOV code coverage report](https://doc.libelektra.org/coverage/master/debian-buster-full)!

## Improvements

The hosts plugin got documentation and several bug fixes.
Multiline comments now remove the comment start sequences within
the metadata comment.
Additionally the kdb tool has an improved error message on invalid
filenames. (thanks to Manuel Mausz)

Fix an issue that the resolver plugin did not delete tmpfile in some
error situations and add test cases with error plugin.

Fix KS_END in C++ that did not specify the namespace.

"kdb run_all" will now run all tests using Elektra from your system.
Because not all testdata will be installed, some test cases fail unless
you copy the data manually. Those are:

    testmod_yajl testmod_augeas testmod_fstab testmod_hosts test_xml

Virtually all clang compiler warnings were fixed
(thanks to Felix Berlakovich).

kdb mv now is atomic. (API was used wrongly in the tool)

Clang, icc and gcc are now all supported and tested.

## Technical Previews

A plugin that logs write operations and errors via the native
journald interface was added (thanks to Felix Berlakovich).

A preview of the augeas plugin was added. In cmake add "augeas" to PLUGINS
and then run "kdb info augeas" for further instructions. Additionally,
see Outlook below (thanks to Felix Berlakovich).

A preview of python3 and lua bindings were added. In cmake enable the
options `BUILD_SWIG BUILD_SWIG_LUA BUILD_SWIG_PYTHON` so that they are
compiled (thanks to Manuel Mausz).

The code generator was extended to support contextual values, more
information about that topic later.

The libtools library is back to life again! It has the same idea as its
predecessor, but it is much more powerful. Because of the plugin system
libtools is able to export and import any configuration format
Elektra supports. Additionally it adds support for mounting backends.
While most of its functionality is mature, the API is not final, though.

## API Changes

The API and ABI is as always backwards-compatible within the 0.8 series.

This time it is, however, not forward-compatible (that means programs
linked against 0.8.6 might not work with 0.8.5), because ksAtCursor()
was added.

ksAtCursor() provides the means for an external iterator. This
was immediately exploited by an implementation of the C++
iterators. These new C++(11) (reverse)iterators allow multi-pass
algorithm over the same KeySet.

ksSort was in the kdb.h header file, even though it never was
needed nor available in 0.8. Automatic compatibility checkers may
wrongly tell that the API is not compatible, but this is not the case
(thanks to Manuel Mausz).

The C++ API changed, including:

- does not wrongly convert garbage to default types using `get<T>`
- getMeta now internally uses `get<T>` and both throw the
  KeyTypeConversion Exception
- KeySet::at directly allows one to use ksAtCursor()
- KeyTypeConversion (or former KeyBadMeta) is not thrown anymore if key
  is not available
- Key::hasMeta allows one to directly check if metadata is available

CMake: ENABLE_CXX11 is now default OFF (because gcc 4.6 and older won't
work with it). It disables some tests, though.
`unique_ptr` will automatically be used instead of `auto_ptr` in this mode.

Note for maintainers: libelektratools now needs to be installed so that
the kdb tool will work.

## Outlook

One drawback of Elektra is the small number of available storage
plugins. While writing storage plugins isn't too hard, it still requires
knowledge of Elektra’s plugin architecture. In addition it is always
necessary to keep both translation directions in mind (from file to
Elektra and back). In order to mitigate this issue Felix Berlakovich
is working on an Elektra storage plugin which uses Augeas [1] to read
and manipulate configuration files. Augeas uses a concept called lenses
to translate between files and abstract trees (i.e. trees that hide
unimportant details like whitespaces). In brief, what makes lenses special
is the fact that they automatically disallow translations that cannot be
reversed. This means that one of the translation directions comes for free
as it is implicitly described by the other one. Therefore writing lenses
is much simpler than programming both directions explicitly as done in
traditional Elektra storage plugins. Furthermore many lenses for common
applications like Apache, MySQL, DHCPd and many more [2] already exist.
Besides these benefits, Augeas lacks many features of Elektra. Although
this is mostly intended because Augeas aims to concentrate just on
configuration file manipulation some of these features would be valuable
for administrators and developers. Some of these mentioned Elektra
features include but are not limited to: logging of all configuration
changes done, transformation of character encoding as needed, import and
export of configuration data in any format, e.g. XML or JSON (Augeas has
a similar feature for XML), file conflict detection and several different
validations for configuration options (see [3] for a full list of
features). With the Augeas storage plugin these features cannot be used
with only the applications already integrated into Elektra, but with all
applications for which lenses exist. This storage plugin targets system
administrators as well as developers, that wish to take advantage of
Elektra’s features, but were unable to do so because of missing plugins. If
no lens exists already, writing a new one requires neither programming
skills nor knowledge of Elektra’s plugin architecture. Furthermore,
implementing a new configuration file format is just a matter of writing a
lens instead of writing a full-fledged parser.
[1] http://augeas.net/
[2] http://augeas.net/stock_lenses.html
[3] https://www.libelektra.org

Since Elektra is written in C, integration is limited to projects
written in C and languages compatible with C like C++. In order to
change this situation Manuel Mausz is working on the implementation of
language bindings using two different techniques. The first technique
uses SWIG as a generic generator for various languages. In a nutshell,
SWIG is a compiler that takes C/C++ declarations and creates the wrappers
needed to access those declarations from other languages. The second
technique is called GObject Introspection. In contrast to SWIG, GObject
Introspection generates a language independent metadata file. For dynamic
languages the GObject Introspection support in the target language will
load this metadata file to generate bindings at run-time. In order to
provide bindings for static languages a compiler on the metadate file
will be used. This is comparable to using SWIG. Manuel will focus on
implementing language bindings for Python and Lua though both techniques
will support various other languages. As language bindings only allow
to call into Elektra’s API Manuel will also embed the interpreters of
both Python and Lua into two generic plugins. Using these plugins in
combination with the languages bindings it will be fully possible to
write plugins for Elektra in languages other than C/C++.

While Elektra offers sophisticated methods to store and manipulate
configuration, currently there is only a command line tool (kdb)
available to interact with the database. This requires the user to study
and learn the possible commands and does not allow free exploration of the
options of the application. To enable new ways to interact with Elektra,
Raffael Pancheri is designing and implementing a Graphical User Interface
(GUI). To increase the probability to create a GUI that is indeed usable
and beneficial, Pancheri is following the design principles proposed by
Ben Shneiderman and Jakob Nielson.

Finally, as you already noticed, Ian Donnelly is working on a semantic
3-way merge to make distribution and package upgrades smoother.
This is done as GSOC project. The progress is documented here:
http://community.libelektra.org/wp/

## Get It!

You can download the release at:
http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.6.tar.gz

- size: 1188337
- md5sum: 4a59824e70a29295e9ef9ae7605d9299
- sha1: 2570710b0057470223611ca00d61a0196e54e7b2
- sha256: e815cf69b070c339784472841aa0ee0b169fab7c78f41cbbd7044f53fa9ed216

Docu can be found here:
https://doc.libelektra.org/api/0.8.6/html/

You can install the debian packages for debian (wheezy, amd64 only,
some packages will be added later) by adding following lines to your
/etc/apt/sources.list:
deb http://markus-raab.org/ftp/wheezy wheezy main

and install or upgrade the packages with:

```sh
sudo apt-get update
sudo apt-get install libelektra-core4 libelektra-full4 libelektra-bin libelektra-dev libelektra-test libelektra-xmltool4 libelektra-json4 libelektra-dbus4 libelektra-doc
```

Best regards,
Markus
