# 0.8.22 Release

- guid: 4884a54f-996a-4564-a138-38a70166fed7
- author: Markus Raab
- pubDate: Tue, 27 Feb 2018 19:35:58 +0100
- shortDesc: Logo, INI, Lookup

We are proud to release Elektra 0.8.22!
In 429 commits, 8 authors changed 548 files with 60369 insertions(+), 6783 deletions(-).

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.22-release)

You can read the [FOSDEM interview](https://fosdem.org/2018/interviews/markus-raab/) and watch the
[FOSDEM main talk](https://fosdem.org/2018/schedule/event/elektra/) given recently.

Elektra is now an official part of [Homebrew](http://formulae.brew.sh/formula/elektra).

## Highlights

- New Logo and Website Theme
- INI plugin greatly improved
- Notifications API and Bindings for Asynchronous I/O
- Plugin Processes
- Lookup with the Order Preserving Minimal Perfect Hash Map

### New Logo and Website Theme

We are proud to present our new logo.
It has a new shape and cooler colors.

<img src="https://cdn.rawgit.com/ElektraInitiative/libelektra/master/doc/images/logo/logo_color.svg" alt="Elektra" width="150" />

Thanks to Philipp Frei!

We also gave the website a new look. It has the colors from the logo and new
fonts ([Lato](https://fonts.google.com/specimen/Lato) and
[Libre Franklin](https://fonts.google.com/specimen/Libre+Franklin)) that improve
readability and add to a unique look. The restructured start page contributes to
the new look as well.

We also updated asciinema-player to 2.6.0.

Thanks to Thomas Wahringer.

We also fixed security issues in the Website due to an old version of jquery,
thanks to Marvin Mall.

Thanks to Bernhard Denner for keeping our infrastructure running.

### INI plugin greatly improved

- `dini` is no longer experimental anymore and adds the binary plugin.
- We added a crash test for the INI plugin that feeds the plugin with problematic input data we determined using [AFL](http://lcamtuf.coredump.cx/afl)
- We fixed various small bugs that could potentially cause the INI plugin to crash and fixes the problems as reported by AFL
- The INI plugin now [converts a section to a normal key-value pair](https://github.com/ElektraInitiative/libelektra/issues/1793) if you store a value inside it. This has the advantage that you will not [lose data unexpectedly anymore](https://github.com/ElektraInitiative/libelektra/issues/1697).
- The [INI plugin](https://www.libelektra.org/plugins/ini) should now read most key-value pairs containing delimiter characters (`=`) properly.

Thanks to René Schwaiger!

Nevertheless, we did not switch to INI as default format.
This has some reasons:

- In many workflows, `dump` is the better choice: e.g. with `kdb editor` you can edit any parts of Elektra with any format (e.g. INI) more safely.
  (With the INI plugin in some of these situations metadata is wrongly shown.)
- The code base of INI is not fully tested and partly not well understood.
- We plan to switch to a newly written parser (most likely YAML) and want to avoid that users have two migrations.
  The migration from `dump` is easier (especially compared with INI) because the `dump` format is recognisable without ambiguity.
  (Thus the INI file parses nearly any file, it is hard to detect that a file is not INI)

But for those who want to switch, the migration will be smooth:
The `dini` plugin makes sure that old dump files are still being read.
Only when writing out configuration files, configuration files are converted to INI.
To change to INI during compilation, simply use:

`-DKDB_DEFAULT_STORAGE=dini`

Or simply switch for your installation with:<br>
`sudo kdb change-default-storage dini`

You can also mount INI (or dini) as root:<br>
`sudo kdb mount default.ini / dini`

### Notification API and Bindings for Asynchronous I/O

This release contains an experimental implementation of Elektra's notification feature.
This feature enables applications to get updates when configuration is changed at run-time.
For more details see the preview tutorial at
[doc/tutorials/notifications.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/tutorials/notifications.md)

The
[Notification API](https://doc.libelektra.org/api/latest/html/kdbnotification_8h.html)
is implemented by a new library called `elektra-notification`.
To use the library you need the new internalnotification plugin.
Since the plugin is experimental it needs to be enabled when building Elektra
from source (e.g. by passing
`-DPLUGINS="ALL;-EXPERIMENTAL;internalnotification"` to `cmake`).

New bindings for asynchronous I/O called "I/O bindings" also have been added.
These bindings allow Elektra's plugins and other parts to perform _asynchronous_ operations.
I/O bindings are opt-in for application developers.
New features of Elektra that take advantage of I/O bindings will have fallbacks where viable.
These fallbacks will use synchronous I/O thus keeping the status quo.

This release includes an experimental I/O binding for [uv](http://libuv.org/).
The interface for I/O bindings is currently experimental and might change in the future.

Elektra's notification feature is not complete yet.
So-called "transport plugins" will be responsible for sending and receiving
notifications using different protocols or libraries (like ZeroMQ or D-Bus).
These plugins will make use of the new I/O bindings.
We plan to introduce the first transport plugins with the next release of Elektra.

### Plugin Processes

A new library called [pluginprocess](https://github.com/ElektraInitiative/libelektra/tree/master/src/libs/pluginprocess)
has been added. This library contains functions that aid in executing plugins in
a separate process. This child process is forked from Elektra's main process
each time such plugin is used and gets closed again afterwards. It uses a simple
communication protocol based on a KeySet that gets serialized through a pipe via
the `dump` plugin to orchestrate the processes.

Such a behavior is useful for plugins which cause memory leaks to be
isolated in an own process. Furthermore this is useful for runtimes or libraries
that cannot be reinitialized in the same process after they have been used.

### Lookup with the Order Preserving Minimal Perfect Hash Map

The `ksLookup (...)` has a new search algorithm, that acts as an alternative to the
binary search. The Order Preserving Minimal Perfect Hash Map (OPMPHM) is a non-dynamic,
randomized hash map and is very effective for mostly static configurations.
The OPMPHM can be enabled for a search by passing the in [kdbproposal.h](https://github.com/ElektraInitiative/libelektra/blob/master/src/include/kdbproposal.h)
defined option `KDB_O_OPMPHM` to the lookup.
Be aware that if the KeySet changes often using the OPMPHM might not be a good
idea, read more about the [OPMPHM](https://github.com/ElektraInitiative/libelektra/blob/master/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm).

When you are not sure if the OPMPHM will speed up you searches, wait for the next release,
that one will include a hybrid search algorithm that combines the best properties of
both search algorithms.

To disable OPMPHM (e.g. on systems with tight memory constraints), you can pass
`-DENABLE_OPTIMIZATIONS=OFF`

## Other New Features

We added even more functionality, which could not make it to the highlights:

- The Web UI was greatly improved, thanks to Daniel Bugl
  The version of clusterd was increased from 1.0.0 to 1.1.0.
- Elektra is now part of the official [Homebrew repository](http://formulae.brew.sh/formula/elektra). We still provide a
  [tap](http://github.com/ElektraInitiative/homebrew-elektra), if you want to install Elektra together with plugins or bindings that require
  additional libraries.
- The building and linking of the Haskell bindings and Haskell plugins has been
  [greatly improved](https://github.com/ElektraInitiative/libelektra/pull/1698).
- The invoke library can now [report errors](https://github.com/ElektraInitiative/libelektra/pull/1801) upon opening/closing a plugin,
  thanks to Armin Wurzinger.
- The [YAML CPP plugin](https://www.libelektra.org/plugins/yamlcpp) does not require [Boost](http://www.boost.org) anymore, if you
  installed [yaml-cpp 0.6](https://github.com/jbeder/yaml-cpp/releases/tag/yaml-cpp-0.6.0).
- Improved colored output in `kdb` tool.
- We added two build jobs: docker and haskell.
  Thanks to Bernhard Denner and Armin Wurzinger.
- [YAML CPP](https://www.libelektra.org/plugins/yamlcpp) does not write binary data to a config file, if you forget to load the [Base64 plugin](https://www.libelektra.org/plugins/base64).
- [YAML CPP](https://www.libelektra.org/plugins/yamlcpp) now encodes empty binary keys as NULL values (`~`), and also adds the metakey `binary` for such values automatically.

## Documentation

We improved the documentation in the following ways:

- We have [documented how you can setup a build node for Jenkins using a Docker container](https://github.com/ElektraInitiative/libelektra/tree/master/scripts/docker/jenkinsnode/README.md)
  We also provide an example Dockerfile based on Debian Stretch for that purpose,
  thanks to Armin Wurzinger.
- Document how `rlwrap` might be used for `kdb shell`.
- Fixed docu in `hosts` plugin.
- Greatly improved the [license documentation](https://git.libelektra.org/blob/debian/debian/copyright)
  in `debian/copyright` in the `debian` branch, thanks to Thomas Wahringer.
- Various fixes in doc/METADATA.ini

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

We executed old test cases against the latest Elektra version and all
tests passed.

In `kdbinvoke.h` we changed the API so that `elektraInvokeOpen`
and `elektraInvokeClose` can yield error messages.

We added:

- the public headerfiles `kdbnotification.h`, `kdbio.h`, `kdbiotest.h`.
- the private headerfiles `kdbnotificationplugin.h`, `kdbioprivate.h`.

## Portability

- Fix bash shebang of bash scripts, thanks to Jakub Jirutka
- Remove unportable unneeded asm, thanks to Timo Teräs and Jakub Jirutka
- Fixed syntax in shell recorder, thanks to René Schwaiger
- Used `mktemp` in `check_distribution.sh` to allow parallel run of test cases,
  thanks to Armin Wurzinger.

## Notes for Maintainer

These notes are of interest for people maintaining packages of Elektra:

- `dini` is no longer experimental.
- CMake: `BINDINGS` now behaves like `PLUGINS`
  By default now all MAINTAINED bindings except EXPERIMENTAL and DEPRECATED are included.
  For more details see
  [/doc/COMPILE.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/COMPILE.md).
  To include both intercept bindings, you now need to write `INTERCEPT`, to only include getenv
  interception `intercept_env`. `intercept` in lower-case does not work anymore.

The following files are new:

- Libs: `libelektra-notification.so`, `libelektra-io.so`, `libelektra-io-uv.so`, `libelektra-pluginprocess.so`
- Headers: `kdbgetenv.h`, `kdbio.h`, `kdbpluginprocess.h`
- Plugins: `base64/Base64.pdf`
- Binaries: `getenv`, `test_context`, `test_fork`, `test_getenv`, `test_ks_opmphm`, `test_opmphm`
- Other: `elektra-io.pc`

The following files were removed:

- Tests: `testmod_semlock`

## Notes for Elektra's Developers

These notes are of interest for people developing Elektra:

- We now use `clang-reformat-5.0` for formatting.
  Please upgrade your clang.
- Build Agent `ryzen v2` was added to speed up `jenkins build all please`,
  thanks to Armin Wurzinger.
- Travis maintenance (Qt 5 and other problems),
  thanks to René Schwaiger.
- `BINDINGS` was greatly improved and the CMake functions were simplified.
  Bindings now also have a `README.md` with metadata.
  A big thanks to Thomas Wahringer.
- Decision: Logging with `ELEKTRA_LOG` is only for C/C++.
- Including `kdberrors.h` in a C++ files now also works, if you do not add the statement

  ```cpp
  using namespace ckdb;
  ```

  before you import `kdberrors.h`.

- The CMake code for Elektra’s [Qt-GUI](https://www.libelektra.org/tools/qt-gui) now detects the location of Qt 5 automatically if you
  installed Qt via Homebrew.
- All Shell Recorder tests should not now correctly restore your old configuration after you execute them,
  thanks to René Schwaiger.
- The [Base64 plugin](https://www.libelektra.org/plugins/base64) does not encode empty binary values in meta mode anymore. This update allows plugins such as YAML CPP to handle empty keys properly.

## Fixes

Many problems were resolved with the following fixes:

- `kdb global-umount` also removed other mountpoints
- We fixed [internal inconsistency](https://github.com/ElektraInitiative/libelektra/pull/1761) in the CMake code of the [Augeas plugin](https://www.libelektra.org/plugins/augeas)
- We fixed the [haskell bindings and plugins on Debian Stretch](https://github.com/ElektraInitiative/libelektra/pull/1787)
  and added a new build server job to test that in the future.
- Cleanup in list plugin, thanks to Thomas Wahringer
- The Shell Recorder now exports and imports the root of a mountpoint instead of the mountpoint itself. This change makes sure that Shell
  Recorder test do not change the configuration directly below the specified mountpoint.

## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.22.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.22.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.22.tar.gz.hashsum?raw=true)

- name: elektra-0.8.22.tar.gz
- size: 5885118
- md5sum: 5cbd9e33daf51f6f33791ff3f99342a6
- sha1: 4954ff16cfe7dc69e45e6a748556262b8fb1a9fa
- sha256: 962598315619d5dff3a575d742720f076dc4ba3702bd01609bfb7a6ddb5d759f

The release tarball is also available signed by me using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.22.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.22.tar.gz.gpg?raw=true)

Already built API-Docu can be found [online](https://doc.libelektra.org/api/0.8.22/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.22).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
issue tracker [on GitHub](http://issues.libelektra.org)
or me by email using elektra@markus-raab.org.

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.22-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
