# 0.9.10 Release

- guid: CC66FD33-7491-4BFA-975A-36FAB67D45D6
- author: Mihael Pranjić
- pubDate: Sat, 09 Jul 2022 09:40:18 +0200
- shortDesc: Kotlin Binding, Remove Internal Iterators

We are proud to release Elektra 0.9.10.

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

You can also read the news [on our website](https://www.libelektra.org/news/0.9.10-release).

You can try out the latest Elektra release using our docker image [elektra/elektra](https://hub.docker.com/r/elektra/elektra).
This is the quickest way to get started with Elektra without compiling and other obstacles, simply run:

```sh
docker pull elektra/elektra
docker run -it elektra/elektra
```

## Highlights

- Kotlin Binding
- Remove internal iterators

### Kotline Binding

We created a new Binding for Kotlin with convenience functions and various utilities.
There is also the possibility to convert KeySets to Kotlin data classes or collections and back.
Read the [Kotlin Readme](../../src/bindings/jna/libelektra-kotlin/README.md) for more information.

A big thanks to _(@Gratla and @mandoway)_ for this beautiful work.

### Remove Internal Iterators

In Elektra there are currently two different ways to iterate over KeySets.
The so-called "internal" iterator is, however, inferior and creates several problems, e.g. it was a side effect to be considered for every function call that involved a KeySet.

With this release, we started removing the internal iterators by removing `keyRewindMeta`, `keyCurrentMeta`, `ksHead`, and `ksTail` functions.
The external iterators are now the way to go, see [Iterators](/doc/dev/iterators.md).

A huge thanks to _(Florian Lindner @flo91)_ for doing this thankless cleanup task.

## Plugins

The following section lists news about the [plugins](https://www.libelektra.org/plugins/readme) we updated in this release.
Overall changes:

- We changed all plugins, except `directoryvalue` to use external iteration of `KeySet`s _(Florian Lindner @flo91)_

### Python

- Added `.pop()`, `.cut()`, `.head()` and `.tail()` examples to keySet example _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_
- Added a new [DNS plugin](/src/plugins/python/python/dns/README.md) fully written in Python _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_

### lineendings - Plugin

- Enable emitting of warnings during kdbGet(), refactor and update methods and return values to match the conventions
  (e.g. #defined constants for return values) _(Michael Langhammer @milangs, Florian Lindner @flo91)_

### date

- Exclude the tests for formats that require GNU extensions of `strptime` on non-GNU systems. _(@kodebach)_

### Length

- Warnings are now added on `kdb get` _(@mandoway)_

### Curlget

- Removed usages (and contents) of VERBOSE macro _(@mandoway)_

### Sorted

- Added new validation plugin: Sorted. It checks whether an Elektra array is sorted by its value or a given key in a configurable direction _(@mandoway @Gratla)_

### mini

- Fix usage of bitwise operator with boolean operands. _(Mihael Pranjić @mpranj)_

## Libraries

The text below summarizes updates to the [C (and C++)-based libraries](https://www.libelektra.org/libraries/readme) of Elektra.

### Compatibility

- Remove `keyRewindMeta`, `keyCurrentMeta`, `ksHead`, and `ksTail` functions for internal iteration of `Keyset`s and Metadata of `Key`s _(Florian Lindner @flo91)_

### Core

- Removed mentions of VERBOSE and replaced debug prints with the logger _(@mandoway)_

## Bindings

Bindings allow you to utilize Elektra using [various programming languages](https://www.libelektra.org/bindings/readme). This section keeps
you up-to-date with the multi-language support provided by Elektra.

- Remove internal iterators for SWIG (Python, Lua, Ruby) and go-bindings _(Florian Lindner @flo91)_

### Java

- Implement NavigableSet in JNA KeySet _(Burkhard Hampl @bhampl)_
- Added a Java example for meta keys and arrays _(@mandoway)_
- Added examples to HelloElektra.java _(Leonard Guelmino @leothetryhard, Lukas Hartl @lukashartl)_
- Added example which shows how to add a basename for a key. _(Philipp Leeb @Gratla)_
- Introduced Key#setNull, ReadableKey#isNull _(Michael Tucek @tucek)_
- Fixed Key#setBoolean, ReadableKey#isBoolean _(Michael Tucek @tucek)_
- Fixed Java Whitelist plugin tests _(Michael Tucek @tucek)_
- Fixed missing Javadoc in Java Sorted plugin _(Michael Tucek @tucek)_

### Ruby

- Replace `NULL` in `rb_funcall` with `Qnil` to avoid compiler errors/warnings on some systems. _(@kodebach)_

### Kotlin

- Added new JNA subproject which builds an Elektra extension library for Kotlin _(@mandoway & @Gratla)_
- Added get(), getOrNull() extension with type inference for primitive types _(@mandoway)_
- Added set() extension with type inference for primitive types _(@mandoway)_
- Added keySet serialization capabilities (to any format and data classes, with array support) _(@mandoway)_
- Added keyOf() extension and keyOf{} builder for key creation _(@Gratla)_
- Added keySetOf() extension and keySetOf{} builder for keySet creation _(@Gratla)_
- Added withKDB() extension which wraps the try block _(@Gratla)_
- Added nameParts extension value which provides a sequence of key name parts _(@mandoway)_
- Added various utility functions like Key.isEmpty, Key.getMetaOrNull, ... _(@Gratla & @mandoway)_
- Added example project for kotlin binding _(@Gratla & @mandoway)_
- Added lookupOrThrow(), lookupOrNull(), and get operator to search for keys in KeySets without Java Optionals _(@mandoway)_
- Fixed setting null, by using new JNA setNull() function _(@mandoway)_

### Python

- Deleted occurrences of removed property key.fullname _(@mandoway)_

### CPP

- Removed mentions of VERBOSE _(@mandoway)_

### Python

- Deleted occurrences of removed property key.fullname _(@mandoway)_

### CPP

- Removed mentions of VERBOSE _(@mandoway)_

## Tools

### elektrad

- improve logging in `elektrad` _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_
- Update `elektrad` to use last version of the `go`-bindings without internal iterators for `Keyset`s and Metadata _(Florian Lindner @flo91)_

### `webui`

- fix issues from namespace-overhaul _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_
- apply non-breaking updates to packages _(Leonard Guelmino @leothetryhard, Lukas Hartl @lukashartl)_

### `webd`

- fix path building for requests to `elektrad` _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_

### QT GUI

- Removed mentions of VERBOSE _(@mandoway)_
- Fixed dependency for Debian packages _(Markus Raab)_

## Scripts

- Fix `kdb reset`. _(Markus Raab)_

## Documentation

- Small readability improvement _(@Toniboyyy)_
- Python: add guide for Debian 11 (bullseye) _(Lukas Hartl @lukashartl)_
- Fix some errors in the tutorials `Cascading Lookups` and `Command-line Options` _(Florian Lindner @flo91)_
- Extend and update the tutorial for writing specifications,
  add section about using specs in production _(Florian Lindner @flo91)_
- Tutorial: add cleanup section to the specification tutorial _(Lukas Hartl @lukashartl)_ and _(@leothetryhard)_
- Add readme-file [Iterators](/doc/dev/iterators.md) about cm2022s project showcasing usage in various programming languages _(Florian Lindner @flo91 and Michael Langhammer @Milangs)_
- Updated elektra-web installation manual (doc/tutorials/install-webui.md) _(Leonard Guelmino @leothetryhard, Lukas Hartl @lukashartl)_
- Improve jna documentation _(Burkhard Hampl @bhampl)_
- Add Stream API example in Java binding documentation _(Richard Stöckl @Eiskasten)_
- Minor readability improvement in `CODING.md` _(@loessberth)_
- Fix dead link and compile instructions _(Burkhard Hampl @bhampl)_
- Update links from certificate section _(Richard Stöckl @Eiskasten)_
- Fix wrong KDBException reference in java tutorial and improve it _(Burkhard Hampl @bhampl and Richard Stöckl @Eiskasten)_
- Update [FAQ](/doc/help/elektra-faq.md). _(Markus Raab)_

### Tutorials

- The tutorial for [Contributing from Windows](../tutorials/contributing-windows.md) has been updated. _(@kodebach)_
- The tutorial for [CLion](../tutorials/contributing-clion.md) now contains a section for setting up the WSL compiler _(@mandoway)_
- Rephrased sentence in code-generator.md to enhance readability _(@Gratla)_

## Tests

- Add tests for the Error/Warnings-Factory in libtools _(Florian Lindner @flo91)_
- Add tests for keySet in the python binary _(Lukas Hartl @lukashartl, Leonard Guelmino @leothetryhard)_
- Added test for JNA KDB which checks if both get-method implementations return the same result. _(Philipp Leeb @Gratla)_

## Build

### CMake

- CMake now automatically detects all JNA plugins that are added to Gradle. _(@kodebach)_

## Infrastructure

### Jenkins

- make copying of artifacts much faster _(Lukas Hartl)_
- fixed several problems _(Lukas Hartl)_

### Cirrus && GitHub Actions

- Fix wrong path for clang builds on macOS. _(Mihael Pranjić @mpranj)_

### Git

- We added a `.gitattributes` file to make it easier to build Elektra with WSL. _(@kodebach)_

### GitHub

- Added dependabot configuration _(Lukas Hartl @lukashartl)_

## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up-to-date. Furthermore, we changed:

- Overhauled the `Get Started` page by adding a brief `kdb` introduction. _(@Milangs)_

## Outlook

We are currently working on following topics:

- 1.0 API _(Stefan Hanreich)_ and _(Klemens Böswirth @kodebach)_
- Elektrify KDE and GNOME _(Mihael Pranjić @mpranj)_
- Elektrify XFCE _(Richard Stöckl @Eiskasten)_
- Mounting SQL databases _(Florian Lindner @flo91)_
- Recording Configuration _(Maximilian Irlinger)_
- Ansible-Elektra _(Lukas Hartl)_
- Improving Build Server Infrastructure _(Lukas Hartl)_ and _(Maximilian Irlinger)_
- Improve Java Development Experience _(Michael Tucek)_
- KDB access using FUSE _(Alexander Firbas)_
- Shell completion _(Ulrike Schäfer)_
- Rewriting tools in C _(Florian Lindner @flo91)_, _(Maximilian Irlinger)_ and _(Richard Stöckl @Eiskasten)_.

## Statistics

We closed [51 issues](https://github.com/ElektraInitiative/libelektra/milestone/31?closed=1) for this release.

About 25 authors changed 376 files with 39350 insertions(+) and 13609 deletions(-) in 393 commits.

Thanks to all authors for making this release possible!

## Join the Initiative!

We welcome new contributors!
Read [here](https://www.libelektra.org/devgettingstarted/ideas) about how to get started.

As first step, you could give us feedback about these release notes.
Contact us via our [issue tracker](https://issues.libelektra.org).

## Get the Release!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.10.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.10.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.10.tar.gz.hashsum?raw=true)

- name: elektra-0.9.10.tar.gz
- size: 9150058
- md5sum: c77f5bcf4e8202fd6d8b6ad6e7c841f4
- sha1: d63c24ea6c666b02d0bd9f059f2d73f96009496d
- sha256: ee50fb5e9814b45a8e99f39435b1461d4b7a7daa27eee240bdbfed98f2c4c0f5

The release tarball is also available signed using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.10.tar.gz.gpg) or on
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.10.tar.gz.gpg?raw=true)

The following GPG Key was used to sign this release: 12CC44541E1B8AD9B66AFAD55262E7353324914A

Already built API-Docu can be found [here](https://doc.libelektra.org/api/0.9.10/html/)
or on [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.9.10).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

If you also want to participate, or for any questions and comments
please contact us via our issue tracker [on GitHub](http://issues.libelektra.org).

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.9.10-release)

For more information, see [https://libelektra.org](https://libelektra.org).

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
