# 0.8.18 Release

- guid: 190576e0-9fef-486e-b8da-c4e75be08329
- author: Markus Raab
- pubDate: Fri, 16 Sep 2016 23:31:27 +0200
- shortDesc: adds intercept open, crypto plugins & improved git-resolver

## What is Elektra?

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

## Highlights

- Intercept open syscalls which allows Elektra to dynamically
  generate config files from Elektra’s database
- Experimental version of cryptographic plugins
- A new zsh completion file (next to the bash completion file)
- Gitresolver allows to directly read and write config files
  from git instead of files present in the file system.
- Survey completed successfully (and debts paid), we are now
  preparing raw data.

### Crypto Plugin

Gpg is now used to decrypt a master password, which is used
by the individual crypto backends. So all necessary parts
for encryption of decryption of individual keys is present.

Furthermore, a new [botan](https://botan.randombit.net) backend
was implemented.

[See here](https://master.libelektra.org/src/plugins/crypto)

Thanks to Peter Nirschl.

### Open Interception

When Elektra directly modifies config files which are on the disc,
and applications read the config files without Elektra, Elektra has
no control over the access, e.g. we cannot dynamically calculate
values. To avoid this, we wrote a library that
intercepts the `open`-call.

Together with the `mozprefs` plugin, we got control over the configuration
of Firefox and can dynamically change config values with all possibilities
Elektra provides.

For easy setup, we implemented the script `configure-firefox`.

[See here](https://master.libelektra.org/src/bindings/intercept)

Thanks to Thomas Waser.

### Resolver

Resolvers in Elektra are the code that are responsible to determine where
content should be read from and stored to. They are independent of the
actual configuration file syntax.

The [gitresolver](https://master.libelektra.org/src/plugins/gitresolver)
allows you to get/store config data in git.

The [blockresolver](https://master.libelektra.org/src/plugins/blockresolver)
allows Elektra to take control of parts of the configuration
file. This is useful for config files such as vim or zsh, which contain
program code. The plugin allows you to split config files with special markers
into parts containing code and others controlled by Elektra.

### zsh completion

Added zsh completion file, and a script (`kdb install-sh-completion`)
that installs bash+zsh completion when the default installation places
do not work (e.g. for macOS).

Thanks to Sebastian Bachmann.

## Documentation

- fix `kdb-import` man page, thanks to Kurt Micheli
- mark `keyIsSystem`/`keyIsUser` as internal
- fix doxygen reference to example
- better document that `global-mount` or `gmount` will overwrite
  previously mounted global plugins
- fix spelling mistake, thanks to René Schwaiger
- Wrote tutorial how to use Elektra-python bindings,
  thanks to Ulrike Schäfer

## Quality

- shell recorder test cases now run during `make test`, thanks to Kurt
  Micheli and René Schwaiger (Warning: might remove present keys
  when it conflicts with their mountpoints)
- find-tools now is pep and pyflakes happy, thanks to Kurt Micheli
- fix bashism, thanks to Thomas Waser and Kurt Micheli
- better error message for conditionals plugin, thanks to Thomas Waser
- better error message for augeas plugin, thanks to Felix Berlakovich
- Many compilation warnings fixed, thanks to Gabriel Rauter, Thomas Waser
- GSettings: fix double free, thanks to Gabriel Rauter
- Fix external links and implement an external link checker,
  thanks to Kurt Micheli
- Fix openwrt/musl warnings with wrong printf format, thanks to
  Thomas Waser
- Fix NODEP metadata, allows you to build all plugins that do not
  have dependencies.

## Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

### Libtools

Libtools got a new major version (SOVERSION 0 -> 1):

- backend/plugin configs are now validated by plugins (needed
  by gpg plugin, which checks if wrong key IDs are supplied during mount)
- resolveRecommends was never implemented and was now removed

### Plugins

The plugins conditionals and mathcheck are incompatible in some cases
because of changes in syntax.

### Proposal

New API: `keyRel2` which differs from `keyRel` by allowing you to
specify which relation should be checked.

## Development

- github descriptions+workflow (displayed by github when creating
  PRs and issues)
- new trigger phases for github, see
  [doc/GIT](https://master.libelektra.org/doc/GIT.md)
  thanks to Mihael Pranjić
- valgrind suppressions are great again, thanks to Peter Nirschl
- Plugins get a new namespace `internal` which can be used for meta-data
  that is not relevant for other plugins.
- kdberrors.h is only generated once, which allows us to use other build
  systems, thanks to René Schwaiger
- `INCLUDE_SYSTEM_DIRECTORIES` in add_plugin allows you to add an include
  path where warnings are suppressed (useful for boost).
- `infos/provides` now allows multiple entries

## Packaging

- Plugin-provider `CRYPTO` can be used to enable/disable all crypto
  plugin variants (not enabled by default because its experimental).
- Config option `ENABLE_OPTIMIZATIONS`, enable by default: trade more
  memory for speed (can be turned off on embedded systems)
- `INSTALL_SYSTEM_FILES` is now off by default on macOS.
- bash-completion is installed to where pkg-config tells us,
  thanks to Gabriel Rauter
  (fallback is now `/usr/share/bash-completion/completions/kdb`)
  was `/etc/bash_completion.d/kdb` (removed)
- zsh is now installed to `/usr/share/zsh/vendor-completions/_kdb`
  (except for Darwin, where `/usr/local/share/zsh/site-functions` is used)
- removed `/etc/profile.d/kdb.sh`: the script `elektraenv.sh` was
  removed (and is no longer installed), superseded by `elektrify-getenv`
- added scripts install-sh-completion configure-firefox elektrify-open
- added plugins libelektra-blockresolver.so libelektra-boolean.so
  libelektra-crypto_botan.so libelektra-crypto_openssl.so
  libelektra-desktop.so libelektra-mozprefs.so libelektra-passwd.so
- added tests testmod_blockresolver testmod_boolean
  testmod_crypto_botan testmod_crypto
  gcrypt testmod_crypto_openssl testmod_mozprefs testmod_passwd
  test_opmphm_vheap test_opmphm_vstack
- added test data blockresolver mozprefs passwd

## Other

- Conditionals and mathcheck plugins got support to specify relative
  keys, thanks to Thomas Waser
- `kdb` command-list: commands are written in bold
- GSettings backend can be build standalone, thanks to Gabriel Rauter
- first data structures for order preserving minimal perfect hash map,
  thanks to Kurt Micheli
- added a new passwd plugin, thanks to Thomas Waser
- boolean
  plugin to normalize boolean values, thanks to Thomas Waser
- [desktop](https://master.libelektra.org/src/plugins/desktop)
  plugin to detect which desktop currently is running (supports kde,
  gnome, tde, unity or any other XDG conformant desktop)
- `doc/paper` contains some info for [joss](https://github.com/openjournals/joss)

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz)
and also [here on github](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.18.tar.gz)

- name: elektra-0.8.18.tar.gz
- size: 2582183
- md5sum: 62fe0fbf9ee57ffaa58a982f602f596a
- sha1: 743484e16b102a00cd58956a49f0c558939d56a8
- sha256: 9ee65895ba5cba6736c13c264637664c1410b25f4aaaeac8f1f83712ff93d53b

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.18.tar.gz.gpg)

already built API-Docu can be found [here](https://doc.libelektra.org/api/0.8.18/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on github](https://git.libelektra.org/issues)
or by email elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/190576e0-9fef-486e-b8da-c4e75be08329.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus
