# 0.9.<<VERSION>> Release

This release did not happen yet.

- shortDesc: Key Name Improvements, Debian and Fedora Packaging

We are proud to release Elektra 0.9.<<VERSION>>.

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

You can also read the news [on our website](https://www.libelektra.org/news/0.9.<<VERSION>>-release)

## Highlights

- Important Breaking Changes to key names et al. _[see below](#hl-1)_
- Debian and Fedora Packaging with CPack _[see below](#hl-2)_

<a id="hl-1"></a>

### Important Breaking Changes

- The structure of key names has been changed. [see below](#br-1) _(Klemens Böswirth)_ <br/>
  **This change breaks mountpoint configurations.**
  Please follow the upgrade procedure [shown below](#mountpoint-upgrade).
- The backend fallback procedure introduced in Elektra 0.8.15 has been removed and the structure of the `warnings` metadata array has been changed. [see below](#br-2) _(Klemens Böswirth)_
- We removed the `ini` plugin (superseded by the TOML plugin), the `null` plugin (superseded by the base64 plugin) and the `tcl` plugin _(Markus Raab, Philipp Gackstatter)_

<a id="br-1"></a>

#### Important Changes to Key Names

There have been significant changes to Elektra's key names:

- The most important change is that you now need a `:` after the namespace.
  So instead of `system/elektra/version` you have to use `system:/elektra/version`.

- The second big change is to array elements.
  From now on `keyNew ("/array/#10", KEY_END)` will create a `Key` with name `/array/#_10`, to make arrays more user-friendly by preserving numerical ordering.

- The whole implementation for `keySetName`, `keyAddName`, etc. has been completely rewritten.
  If you rely on specific behaviour of Elektra's key names and have already taken the two changes above into account, please refer to the newly created [key name documentation](../KEYNAMES.md) and [Python reference implementation](../../scripts/keynames.py).

- Metakeys now use the namespace `meta:/`.
  The accessor functions `keyGetMeta` and `keySetMeta` automatically add this namespace to preserve compatibility.
  However, if you use the recently introduced `keyMeta` or otherwise directly access the key name of a metakey, you will have to update your code.

- `default:/` is a new namespace used for keys that exist purely to represent a default value (e.g. generated by the `spec` plugin).

  Looking up cascading keys with `ksLookup` now looks at namespaces in the following order:

  - `proc:/`
  - `dir:/`
  - `user:/`
  - `system:/`
  - `default:/`
  - `/` (cascading key itself)

  The final lookup of the cascading key itself, will be removed in a future release.
  Please update your code to generate `default:/` keys, if you rely on this feature.

  Note: The `spec` plugin already generates `default:/` keys.

- The function `keyInactive` has been removed.
  The concept of inactive keys no longer exists, use [comment/#](/doc/METADATA.ini) instead.

- `ElektraNamespace` is the new C++ `enum class` for the Elektra's namespaces.
  You should prefer it to using `KEY_NS_SYSTEM` et al. directly, if you use C++.

- `keyGetFullName` et al. have been removed. The concept of a "full name (with owner)" no longer exists.

A huge thanks to _(Klemens Böswirth)_ for doing these important changes and clean-ups.

<a id="mountpoint-upgrade"></a>

#### Mountpoint upgrade

The change to key names breaks existing mountpoint configurations.

It is not hard to fix the mountpoint configs even after the updating to the new version.

There are two places that will still contain the old syntax after the update:

1. Every key below (and including) `system:/elektra/mountpoints/<MOUNTPOINT>` uses an old key names as `<MOUNTPOINT>`, if the mountpoint was created with `kdb mount`.
2. The value of all keys matching `system:/elektra/mountpoints/*/mountpoint` must be valid key names.

Fixing the first instance is optional.
There the key name is just used to create a unique name for the mountpoint.

The second instance, however, must be fixed or Elektra will be unusable.

> **Disclaimer:** We cannot guarantee that the commands below work for all cases.
> We also make no guarantees that the command will not break things.
>
> Please report any [problems](https://issues.libelektra.org/3633).
>
> _You have been warned. Manually backup important data first._

For the migration you can use the following commands:

```sh
#! /usr/bin/env sh
kdb export system:/elektra/mountpoints ni > mountpoints.ini
sed -E 's~((^\[?|/mountpoint = )(user|system))((\\\\)?/)~\1:\4~g' mountpoints.ini > mountpoints_corrected.ini
kdb mv -r system:/elektra/mountpoints system:/elektra/mountpoints-backup
kdb import system:/elektra/mountpoints ni < mountpoints_corrected.ini
```

> _Note:_ The original `system:/elektra/mountpoints` data will be moved to `system:/elektra/mountpoints-backup`

<a id="hl-2"></a>

### Debian and Fedora Packaging with CPack

We are now using CPack to generate modular Debian, Ubuntu (DEB) and Fedora (RPM) packages. This simplifies the packaging process and solves problems where a PR, which introduces changes to installed files, fails. We can now also set distribution specific dependencies with CPack, which is needed for some packages. _(Robert Sowula)_

We now provide DEB and RPM packages for releases and for every commit on master in our own repositories using CPack for:

- DEB packages for Debian Buster
- DEB packages for Ubuntu Bionic
- DEB packages for Ubuntu Focal
- RPM packages for Fedora 33

A big thanks to _(Robert Sowula)_ for introducing CPack and creating the repositories.

#### Short Installation Guide

##### DEB packages

1. First, you need to obtain the repository key:

```sh
sudo apt-key adv --keyserver keys.gnupg.net --recv-keys F26BBE02F3C315A19BF1F791A9A25CC1CC83E839
```

2. Add `deb https://debs.libelektra.org/<DISTRIBUTION> <DISTRIBUTION> main` into `/etc/apt/sources.list`
   where `<DISTRIBUTION>` is the codename of your distributions e.g. `focal`, `bionic` or `buster`.

```sh
apt-get install libelektra5-all
```

##### RPM packages

Download our [.repo configuration file](https://rpms.libelektra.org/fedora-33/libelektra.repo) and add it to yum/dnf.

To get all packaged plugins, bindings and tools install:

```sh
dnf install libelektra5-all
```

For more available packages, further instructions on how to add our repositories or instructions on how to use our master built packages, please refer to our [install documentation](../INSTALL.md).

#### Version Bump

The 0.9.\* series of Elektra is for development of Elektra 1.0.
Elektra 1.0 will be incompatible to 0.8 and as such, we need a SO version bump.
We used this release to bump the SO version from 4 to 5 due to the breaking changes that are not visible in the API.

> _Note:_ that within 0.9.\* we likely introduce further breaking changes but we will not bump the SO version again.

The package names which consist of the SO Version also changed from libelektra4\* to libelektra5\*.
If you used our previous repository with master built packages, please make sure to migrate to our new package repositories described above or in our [install documentation](../INSTALL.md).

The version of the Java bindings was also bumped from 4 to 5, although the API is also work in progress.

A big thanks to _(Robert Sowula)_ for doing the necessary renamings.

## Plugins

The following section lists news about the [plugins](https://www.libelektra.org/plugins/readme) we updated in this release.

### jni

- Fix rare memleak when the `jni` plugin is closed. _(Mihael Pranjić)_

### mINI

- We changed the `provides` clause in the plugin contract. Now mINI offers support for the [properties format](https://en.wikipedia.org/wiki/.properties) (`storage/properties`) instead of the INI file format (`storage/ini`). This makes sense, since the plugin never supported the [section syntax][] of INI files. _(René Schwaiger)_

[section syntax]: https://en.m.wikipedia.org/wiki/INI_file#Sections

### Quickdump

- Support for the old quickdump v1 and v2 formats has been removed. _(Klemens Böswirth)_

### Simple INI

- The plugin contract now correctly states that the plugin offers support for the [properties format](https://en.wikipedia.org/wiki/.properties). Before it would state that the plugin offered support for the INI file format. This is not true, since the plugin does not support the [section syntax][] of the INI file format.

### YAML CPP

- We fixed an [use after free bug in the plugin](https://issues.libelektra.org/3561). _(René Schwaiger)_

### Yan LR

- The plugin now works (with and) requires [ANTLR `4.9`](https://github.com/antlr/antlr4/releases/tag/4.9). _(René Schwaiger)_

## Libraries

The text below summarizes updates to the [C (and C++)-based libraries](https://www.libelektra.org/libraries/readme) of Elektra.

### Compatibility

<a id="br-2"></a>

- We removed the fallback procedure introduced in Elektra 0.8.15 (using `KDB_DB_FILE` (`default.ecf`) for `system:/elektra`, if the bootstrap backend `KDB_DB_INIT` (`elektra.ecf`) isn't found).
  If you still rely on this feature, either use `kdb upgrade-bootstrap` **before** upgrading, or manually extract `system:/elektra` into `elektra.ecf`.
- There was an update to how warnings are generated.
  For users this means that the `warnings` metadata now forms a proper array.
  Specifically, the first 100 warnings are stored below to the meta keys `warnings/#0`, `warnings/#1`, ..., `warnings/#9`, `warnings/#_10`, ..., `warnings/#_99`.
  After that, warnings will wrap around, so the 101st warning will be stored as `warnings/#0`, 102nd as `warnings/#1` etc.

### Core

- `kdbSet` now properly handles, if the given `parentKey` is `NULL` or has read-only name, value or metadata. _(Klemens Böswirth)_

### Proposal

- Removed `elektraKeyGetMetaKeySet` and moved `keySetStringF` to the hosts plugin. _(Philipp Gackstatter)_
- Removed `ksPopAtCursor`. _(Philipp Gackstatter)_

## Bindings

Bindings allow you to utilize Elektra using [various programming languages](https://www.libelektra.org/bindings/readme). This section keeps
you up to date with the multi-language support provided by Elektra.

### Lua

- Remove ipairs support and add our own iterator to add support for Lua 5.4, since `__ipairs` was deprecated. _(Manuel Mausz)_

### JNA

- Fixed allocation not correctly conveyed on key set initialization _(Michael Tucek)_

### C++

- `ElektraNamespace` is the new C++ `enum class` for the Elektra's namespaces. You should prefer it to using `KEY_NS_SYSTEM` et al. directly, if you use C++.
  The array `ELEKTRA_NAMESPACES` can be used to iterate over all namespaces. _(Klemens Böswirth)_

### Ruby

- Enable `__declspec` attributes for Ruby 3.0. _(Mihael Pranjić)_

## Tools

- The kdb cmd-line tool outputs better error messages on wrong names like `user` or `user:` as `user:/` is now required. _(Markus Raab)_
- The QtGUI was updated to be compatible with the new key name structure. _(Klemens Böswirth)_

## Scripts

- We fixed the (possibly) infinitely running function `generate-random-string` in [check-env-dep](../../scripts/check-env-dep).
  _(René Schwaiger)_

## Documentation

- Finalize 1.0 [decisions](/doc/decisions). _(Markus Raab)_
- Update [API design document](/doc/DESIGN.md) _(Markus Raab and Stefan Hanreich)_
- Update [release instructions](../todo/RELEASE) _(Robert Sowula)_
- Changed API documentation terms [current, latest] to [latest, master].
  The API documentation of the latest release is now available at https://doc.libelektra.org/api/latest/html/ and of the current git master at https://doc.libelektra.org/api/master/html/. _(Robert Sowula)_

## Tests

- Tests that use additional executables can now be installed and run via `kdb <testname>`.
  Existing tests have been update to support this. _(Klemens Böswirth)_
- Update source formatting check to clang-format 11. _(Mihael Pranjić)_

## Build

### CMake

- Use Lua 5.4 when available. _(Mihael Pranjić)_
- Force `RTLD_NODELETE` on dlopen() when the `ENABLE_ASAN` CMake option is used. This enables ASAN to find symbols which otherwise might be unloaded. _(Mihael Pranjić)_

### Docker

- We added a Docker image for [building the documentation on Debian Sid](../../scripts/docker/debian/sid/doc.Dockerfile). _(René Schwaiger)_
- We removed the Docker image for building the documentation on Debian Stretch. _(René Schwaiger)_
- Add Fedora 33 Dockerfile for Cirrus and Jenkins CI. _(Mihael Pranjić)_
- Debian Sid: update to clang 11. _(Mihael Pranjić)_

## Infrastructure

### Cirrus

- Upgrade Cirrus Fedora docker image to Fedora 33. _(Mihael Pranjić)_
- Upgrade to Ruby 3.0 for macOS builds. _(Mihael Pranjić)_

### GitHub Actions

- We added a build job that translates Elektra with GCC on macOS. _(Mihael Pranjić, René Schwaiger)_

### Jenkins

- We refactored shared code between pipelines into a [Jenkins Shared Library](https://github.com/ElektraInitiative/jenkins-library). _(Robert Sowula)_
- We now use Debian Sid to build the documentation instead of Debian Stretch. The Doxygen version in Debian stretch [contains a bug](https://github.com/doxygen/doxygen/issues/6456) that causes the generation of the PDF documentation to fail. _(René Schwaiger)_
- Use Fedora 33 and 32, drop Fedora 31 use in Jenkins. _(Mihael Pranjić)_
- The Main and Release Pipeline now creates packages for Debian Buster, Ubuntu Bionic, Ubuntu Focal and Fedora-33. These packages are also installed and automatically tested before they are published. To install these packages, please refer to our [Install documentation](../INSTALL.md). _(Robert Sowula)_
- We updated our Release Pipeline to push changes directly to our git repositories. _(Robert Sowula)_

### Travis

- Move macOS GCC 10 build job to Github Actions. _(Mihael Pranjić)_

## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up to date.

## Outlook

We are currently working on following topics:

- Elektrify KDE _(Dardan Haxhimustafa)_, _(Felix Resch)_ and _(Mihael Pranjić)_
- 1.0 API _(Stefan Hanreich)_ and _(Klemens Böswirth)_
- Improve Java Development Experience _(Michael Tucek)_
- Elektrify GNOME _(Mihael Pranjić)_
- Continious Releases _(Robert Sowula)_
- KDB access using FUSE _(Alexander Firbas)_
- Default TOML plugin _(Jakob Fischer)_
- Improve Plugin Framework _(Vid Leskovar)_
- Improve 3-way merge _(Dominic Jäger)_
- Shell completion _(Ulrike Schäfer)_
- Ansible bindings _(Thomas Waser)_

## Statistics

<<`scripts/git-release-stats 0.9.VER-1 0.9.<<VERSION>>`>>

## Join the Initiative!

We welcome new contributors!
Read [here](https://www.libelektra.org/devgettingstarted/ideas) about how to get started.

As first step, you could give us feedback about these release notes.
Contact us via our [issue tracker](https://issues.libelektra.org).

## Get the Release!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.<<VERSION>>.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.<<VERSION>>.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.<<VERSION>>.tar.gz.hashsum?raw=true)

<<`scripts/generate-hashsums elektra-0.9.<<VERSION>>.tar.gz`>>

The release tarball is also available signed using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.<<VERSION>>.tar.gz.gpg) or on
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.<<VERSION>>.tar.gz.gpg?raw=true)

The following GPG Key was used to sign this release: 12CC44541E1B8AD9B66AFAD55262E7353324914A

Already built API-Docu can be found [here](https://doc.libelektra.org/api/0.9.<<VERSION>>/html/)
or on [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.9.<<VERSION>>).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

If you also want to participate, or for any questions and comments
please contact us via our issue tracker [on GitHub](http://issues.libelektra.org).

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.9.<<VERSION>>-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
