# 0.9.7 Release

- guid: 39F907DA-8B5B-4984-9D19-33BAB7B71B3D
- author: Mihael Pranjić
- pubDate: Fri, 09 Jul 2021 10:19:29 +0200
- shortDesc: FUSE Tool, TOML Improvements, ElektraSettings GSettings Bindings

We are proud to release Elektra 0.9.7.

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

You can also read the news [on our website](https://www.libelektra.org/news/0.9.7-release).

You can try out the latest Elektra release using our docker image [elektra/elektra](https://hub.docker.com/r/elektra/elektra).
This is the quickest way to get started with Elektra without compiling and other obstacles, simply run:

```sh
docker pull elektra/elektra
docker run -it elektra/elektra
```

## Highlights

### FUSE Tool

We added an **experimental** preview of the Filesystem in User Space [FUSE](../../src/tools/fuse/README.md) tool. This tool enables the inspection and modification of the KDB, in the form of a classical filesystem. _(Alexander Firbas)_

### ElektraSettings GSettings Backend

The **experimental** [ElektraSettings](../../src/bindings/gsettings/README.md) GSettings backend has been updated and is working well with GNOME 40. We do not recommend to use it on production systems yet, but we have been testing ElektraSettings as a replacement for `dconf` successfully and want to share the progess with you. If you want to try ElektraSettings back up all your data first. _(Mihael Pranjić)_

### TOML Improvements

Multiple critical bugs have been fixed in the **experimental** `TOML` plugin _[see below](#hl-1)_. We are currently working towards using the `TOML` plugin as the default [storage plugin](https://github.com/ElektraInitiative/libelektra/blob/master/src/plugins/README.md#storage) for Elektra. _(Klemens Böswirth and Jakob Fischer)_

## Plugins

The following section lists news about the [plugins](https://www.libelektra.org/plugins/readme) we updated in this release.

### [email](/src/plugins/email/README.md)

- Introduce email address validation plugin based on regex. _(a-kraschitzer)_

### Resolver

- Fix invalid cache key name. _(Mihael Pranjić)_

### Length

- Implement a plugin that validates that a string length is less or equal to given number. _(Philipp Oppel)_

### Blacklist

- Implement a blacklist plugin that rejects values specified in a metadata array. _(Robert Sowula)_

<a id="hl-1"></a>

### TOML

- Fixed a bug ([#3896](https://issues.libelektra.org/3896)) that caused the `toml` plugin to swallow the first letter of
  all keys (after the namespace), if the parent key was a root key (e.g. `user:/`). _(Klemens Böswirth)_
- The `type` metakey is now set for numbers on reading. _(Jakob Fischer)_
- Rewrote some error messages, to make them less technical. _(Jakob Fischer)_
- Fixed parsing of floats/empty keynames/multiline strings. _(Jakob Fischer)_

### Python

- Fix format string overflow and add error checking when appending to `sys.path`. _(Mihael Pranjić)_

## Libraries

The text below summarizes updates to the [C (and C++)-based libraries](https://www.libelektra.org/libraries/readme) of Elektra.

### Core

- A few rare bugs (mostly related to empty keyname parts `/%/`) in the keyname validation and canonicalization logic
  have been fixed. _(Klemens Böswirth)_
- Fix default backend key name for cache compatibility. _(Mihael Pranjić)_

## Bindings

Bindings allow you to utilize Elektra using [various programming languages](https://www.libelektra.org/bindings/readme). This section keeps
you up to date with the multi-language support provided by Elektra.

### JNA

- Currently the binding's automated clean-up of native keys and key sets is deactivated until JNI segmentation fault issues are resolved in an upcoming release. After these issues have been resolved, manual clean-up of native resources will be discouraged. Therefore the `Key::get*AndRelease` convenience methods introduced with the last release have been removed. _(Michael Tucek)_
- Upgrade Gradle to 7.1.1. _(Mihael Pranjić)_

### Gsettings

- Fix user and default (system) namespaces and key names. _(Mihael Pranjić)_
- Rewrite `dbus` change notification mechanism. _(Mihael Pranjić)_

## Scripts

- Add a script that automates the process of inserting source archive hashsums and git statistics into the release notes during a release. _(Robert Sowula)_

## Documentation

- JNI docu updates and small fixes. _(Markus Raab)_
- Small updates in notification tutorial. _(Markus Raab)_
- Add [tutorial about writing specifications](/doc/tutorials/specification.md). _(Aaron Abebe <aaron.abebe@gmail.com>)_
- Change GPG keyserver for receiving the apt key from keys.gnupg.net to keyserver.ubuntu.com _(Robert Sowula)_
- The manpages now use the date of the last change recorded in git. _(Klemens Böswirth)_

## Tests

- Upgrade GoogleTest frameworks to version 1.11.0. _(Mihael Pranjić)_
- Add additional test cases for module `key`. _(@lawli3t)_
- Add additional test cases for module `keyname`. _(@lawli3t)_
- Add additional test cases for module `keyvalue`. _(@lawli3t)_
- Add tests for module `keyset`. _(@lawli3t)_

## Packaging

- Add packages for following bindings: `glib`, `io_ev`, `io_glib` and `io_uv`. _(Robert Sowula)_

## Build

### Docker

- Upgrade Alpine Linux images to 3.14.0. _(Mihael Pranjić)_

## Infrastructure

### Jenkins

- Add the deployment of the [website](https://www.libelektra.org) to the release pipeline, therefore removing the need to wait until the main pipeline succeeds after a release. _(Robert Sowula)_
- Restructure the release job stages to make it more failsafe and enable a re-run without any version conflict until the last stage. _(Robert Sowula)_
- Fix invalid package artifact path in release pipeline. _(Robert Sowula)_
- Clean Jenkins workspaces after builds. _(Mihael Pranjić)_

## Outlook

We are currently working on following topics:

- Elektrify KDE _(Dardan Haxhimustafa)_, _(Felix Resch)_ and _(Mihael Pranjić)_
- 1.0 API _(Stefan Hanreich)_ and _(Klemens Böswirth)_
- Improve Java Development Experience _(Michael Tucek)_
- Elektrify GNOME _(Mihael Pranjić)_
- Continious Releases _(Robert Sowula)_
- KDB access using FUSE _(Alexander Firbas)_
- Default TOML plugin _(Jakob Fischer)_ and _(Klemens Böswirth)_
- Improve Plugin Framework _(Klemens Böswirth)_
- Improve 3-way merge _(Dominic Jäger)_
- Shell completion _(Ulrike Schäfer)_
- Ansible module _(Thomas Waser)_

## Statistics

We closed [40 issues](https://github.com/ElektraInitiative/libelektra/milestone/28?closed=1) for this release.

About 18 authors changed 307 files with 6547 insertions(+) and 1914 deletions(-) in 304 commits.

Thanks to all authors for making this release possible!

## Join the Initiative!

We welcome new contributors!
Read [here](https://www.libelektra.org/devgettingstarted/ideas) about how to get started.

As first step, you could give us feedback about these release notes.
Contact us via our [issue tracker](https://issues.libelektra.org).

## Get the Release!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.7.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.7.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.7.tar.gz.hashsum?raw=true)

- name: elektra-0.9.7.tar.gz
- size: 7712448
- md5sum: 4355e7df0dcf4178974097604f996747
- sha1: c418d344d72879dd2b3fd6fa8e9831c921cfaba5
- sha256: 12b7b046004db29317b7b937dc794abf719c400ba3115af8d41849127b562681

The release tarball is also available signed using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.9.7.tar.gz.gpg) or on
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.9.7.tar.gz.gpg?raw=true)

The following GPG Key was used to sign this release: 12CC44541E1B8AD9B66AFAD55262E7353324914A

Already built API-Docu can be found [here](https://doc.libelektra.org/api/0.9.7/html/)
or on [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.9.7).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

If you also want to participate, or for any questions and comments
please contact us via our issue tracker [on GitHub](http://issues.libelektra.org).

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.9.7-release)

For more information, see [https://libelektra.org](https://libelektra.org).

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
