# 0.8.7 release

- author: Markus Raab
- pubDate: Mon, 28 Jul 2014 12:00:00 +0100
- shortDesc: adds python2 bindings, 3-way merge & improvements

Again, we managed to have a great feature release with dozens of
corrections!

## New Features

Thanks to Manuel Mausz for further improving lua, python3 bindings
and the new python2 bindings.

The GSoC efforts have their first large contribution to Elektra, the 3
way merge finally arrives with this release. It is still a long way to
go, however, because augeas plugins can only be mounted with a
workaround and the package integration of the 3-way merge is still in
its infancy.

A special thanks to Felix Berlakovich for his contributions to the
3-way merge, including meta merging, conflict resolving strategies and
extensive testing.

Additionally, he added the plugins keytometa, ini and greatly improved
the glob plugin. These plugins are technical previews and will receive
some improvements in the next release, too.

Now a script for tab completion is available
[here](/scripts/completion/kdb-bash-completion), again thanks to Felix
Berlakovich.

The contextual values now got a [tutorial](https://master.libelektra.org/src/tools/pythongen)
and small fixes.

## Corrections

Thanks to Pino Toscano for fixing a lot of spelling errors, simplify
RPATH setting, respect `$HOME` and `$TMPDIR`, improvements of test cases,
and his debian-packaging efforts.

In the kdb tool not allowed subfolders are now checked properly
and the output of warnings comes before output of the error.
This fixes the problem that in the case of a longer list of
warnings one did not see the error anymore.

Fix compilation warnings on clang and gcc 4.9.
Also improve test coverage on kdb tool and some plugins.

Fix kdb import/export for some plugins (Should now work with any storage
plugin again).

kdb run_all should run flawlessly with this release. Remaining problems
with not installed test data were fixed. kdb run_all also checks if the
test cases do not modify any existing key and keeps a backup if this
happened.

Some remaining mem leaks in rare circumstances were fixed. Valgrind
should now never report any leaks, if it does, please report the issue.

## API Changes

Added delMeta() for C++, because setMeta() with NULL will set the
number 0 and not remove the meta.

Arguments of isBelow, isDirectBelow, isBelowOrSame are swapped for
better readability. k.isBelow(root) now means the obvious thing.
The change only effects the C++ binding, keyIsBelow is unaffected by
the change.

## Documentation

[Specification of metadata](/doc/METADATA.ini) and
[contracts](/doc/CONTRACT.ini) written/greatly improved.

[Decisions](/doc/decisions) are introduced again.

Most often the KeySet is ideal, e.g. when doing full iteration or when
performing set operations. In some cases, however, a hierarchical data
structure fits better. This is especially true for GUIs. Luckily, Keys
can be in multiple data structures because of their reference counting.

## Other Stuff

We now fully embrace github:

- We use its issue tracker (all issues from local text files were moved
  there)
- We have rewritten many READMEs to use GitHubs Markdown
- On pull requests the build server checks if the merge would break
  the build.
- All previous gitorious users are now at github. (Most had an account
  anyway)

Raffael Pancheri also made progress with its qt-gui. It now features a
model that implements great parts of Elektra’s features. Unfortunately
the model cannot be serialized and thus changes cannot made persistent.
Also undo and other important use-cases are still not there. The GUI
looks very clean and was evaluated in a SUS study on 23.07.2014.
The current implementation can be found [here](https://github.com/0003088/qt-gui).

Many distributions already have Elektra packages

- Gentoo
- [Arch Linux](https://aur.archlinux.org/packages/libelektra/)

In some distributions Elektra packages are available, but are not
up-to-date. Pino Toscano is working on get them (actually
Debian, but others are derived from it) up-to-date.

- [Ubuntu](https://launchpad.net/ubuntu/+source/elektra)
- Debian
- [Linux Mint](http://community.linuxmint.com/software/view/elektra)

A special thanks to Kai-Uwe Behrmann for providing packages for
[CentOS, Fedora, OpenSUSE, RHEL and
SLE](http://software.opensuse.org/download.html?project=home%3Abekun&package=elektra).

## Get It!

You can download the release from:

http://www.markus-raab.org/ftp/elektra/releases/elektra-0.8.7.tar.gz
size: 1566800
md5sum: 4996df62942791373b192c793d912b4c
sha1: 00887cc8edb3dea1bc110f69ea64f6b700c29402
sha256: 698ebd41d540eb0c6427c17c13a6a0f03eef94655fbd40655c9b42d612ea1c9b

already build API documentation can be found here:

https://doc.libelektra.org/api/0.8.7/html/

Best regards,
Markus
