# 0.8.12 Release

- guid: 98770541-32a1-486a-98a1-d02f26afc81a
- author: Markus Raab
- pubDate: Sun, 12 Jul 2015 20:14:09 +0200
- shortDesc: adds directory namespace & other improvements and fixes

Again we managed to release with new features, many build system
fixes and also other improvements.

## dir namespace

This namespace adds per-project or per-directory (hence the name) configurations.
E.g. think how Git works: not only /etc and ~ are relevant sources
for configuration but also the nearest .git directory.

This technique is, however, much more widely useful than just for git
repositories! Nearly every application can benefit from such a per-dir
configuration. Its almost certain that you have already run into the
problem that different projects have different guidelines
(e.g. coding conventions, languages, whitespace requirements, line breaks, ..).
Obviously, thats not a per-user configuration and
its also not a per-file issue (thats how its usually solved today).
So in fact you want, e.g., your editor to have an additional per-project layer
to choose between such settings.

The technique is useful for nearly every other tool:

- different color palettes in gimp, inkscape,..
- different languages for LibreOffice
- different security settings for media players, interpreters (e.g. when in Download folder)
- per-folder .htaccess in apache or other web servers
- any other per-dir configuration you can imagine..

It is simple to use, also for the administrative side. First, change to the folder to your
folder (e.g. where a project is):

```sh
cd ~/projects/abc
```

Then add some user (or system or spec) configuration to have some default.

```sh
kdb set user/sw/editor/textwidth 72
```

Then verify that we get this value back when we do a cascading lookup:

```sh
kdb get /sw/editor/textwidth
```

The default configuration file for the dir-namespace is `pwd`/KDB_DB_DIR/filename:

```sh
kdb file dir/sw/editor/textwidth
```

- KDB_DB_DIR can be modified at compile-time and is `.dir` per default
- filename can be modified by mounting, see below, and is `default.ecf` by default

We assume, that the project abc has the policy to use textwidth 120, so
we change the dir-configuration:

```sh
kdb set dir/sw/editor/textwidth 120
```

Now we will get the value 120 in the folder ~/projects/abc and its
subdirectories (!), but everywhere else we still get 72:

```sh
kdb get /sw/editor/textwidth
```

Obviously, that does not only work with kdb, but with every elektrified tool.

### mount files in dir namespaces

For cascading mountpoints, the dir name is also automatically mounted, e.g.:

```sh
kdb mount editor.ini /sw/editor ini
```

But its also possible to only mount for the namespace dir if no cascading mountpoint is
present already:

```sh
kdb mount app.ini dir/sw/app tcl
```

In both cases keys below dir/sw/editor would be in the INI file
`.dir/editor.ini` and not in the file `.dir/default.ecf`.

### dir together with spec namespace

In the project P we had the following issue: We needed on a specific computer the
configuration in /etc to be used in favor of the dir config.

We could easily solve the problem using the specification:

```sh
kdb setmeta spec/sw/P/current/org/base override/#0 /sw/P/override/org/base
```

Hence, we could create system/sw/P/override/org/base which would be in favor of dir/sw/P/current/org/base.
So we get system/sw/P/override/org/base when we do:

```sh
kdb get /sw/P/current/org/base
```

Alternatively, one could also use the specification:

```sh
kdb setmeta spec/sw/P/current/org/base namespace/#0 user
kdb setmeta spec/sw/P/current/org/base namespace/#1 system
kdb setmeta spec/sw/P/current/org/base namespace/#2 dir
```

Which makes dir the namespace with the least priority and system would be preferred.
This was less suitable for our purpose, because we needed the override
only on one computer. For all other computers we wanted dir
to be preferred with only one specification.

### Conclusion

The great thing is, that every elektrified application, automatically gets all the mentioned features.
Not even a recompilation of the application is necessary.

Especially the specification provides flexibility not present in other configuration systems.

## Qt-Gui 0.0.7

Raffael Pancheri again did a lot of stabilizing work:

- show errormessage on exception when starting gui
- Correctly update keyAreaView property when selecting item in TreeView
- Fix crash when creating key in MountingWizard
- Remove information on successful export
- Show error dialog on failed import
- Remove namefilters (every syntax can have any file extension)
- other namespaces (including dir) are included

The GUI can be handy for many purposes, e.g. we use it already as xml and json editor.
Note that there are still [some bugs](https://git.libelektra.org/issues).

## Other fixes

- constants now additionally gives information about SPEC and DIR.
- Doku about CMake variables `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD` fixed, thanks to Kurt Micheli
- Fixed compilation of `ELEKTRA_DEBUG_BUILD` and `ELEKTRA_VERBOSE_BUILD`, thanks to Manuel Mausz
- Example with error handling added, thanks to Kurt Micheli
- Add design decision about global plugins
- Split dependencies document to individual README.md, thanks to Ian Donnelly
- Fix nearly all compilation warnings of SWIG, thanks to Manuel Mausz
- CMake: Fix gtest to be build if `BUILD_TESTING` activated, but not `ENABLE_TESTING`
- CMake: Allow compilation without BUILD_STATIC
- Explain compilation options more, thanks to Kai-Uwe Behrmann for asking the question
- CMake: always build examples, allow one to only build documentation
- add common header file for C++ plugins (used by plugins struct and type)
- fix compilation of race tool under oS-11.4 thanks to Kai-Uwe Behrmann
- CMake: find python3 correctly
- CMake: fix BUILD_SHARED_LIBS
- Doxygen: remove `HTML_TIMESTAMP` to make build reproduceable
- Doxygen: rewrite of main page+add info about all five namespaces
- CMake: allow one to use qt-gui with qt built with -reduce-relocations
- fix kdb ls, get to list warnings during open
- during kdbOpen() use Configfile: to state phase
- add -f option to kdb check+improve docu
- improve readability of warning output
- run_all always uses dump for backups
- line plugin round-trips correctly
- untypical resolvers have their non-existant filename handled correctly + sync ignored them correctly
- cmake-3.0 fixes
- cascading merging, a big thanks to Felix Berlakovich for the last minute fix

## Compatibility

As always, the API and API is fully compatible. Because nothing was added, its even
possible to link against an older version of Elektra (if compiled against 0.8.12).

In plugins some small changes may effect compatibility:

- in rename the handling of parent key is different (see #206)
- resolving of spec absolute and relative paths are no more handled identical.
  Instead absolute paths will be searched absolutely, while relatives are below KDB_DB_SPEC (as before).
  This behavior is consistent to the behavior of the other namespaces.

These two points are also the only unit tests that fail when Elektra 0.8.12 is used with 0.8.11 unit tests.

## Build Server

- special GitHub command to build bindings "jenkins build bindings please", thanks to Manuel Mausz
- open build service update
  For [OpenSUSE, CentOS, Fedora, RHEL and SLE](https://build.opensuse.org/package/show/home:bekun:devel/elektra)
  Kai-Uwe Behrmann kindly provides packages [for download](http://software.opensuse.org/download.html?project=home%3Abekun%3Adevel&package=libelektra4).

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz)
and now also [here on GitHub](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.12.tar.gz)

- name: elektra-0.8.12.tar.gz
- size: 2102450
- md5sum: a40a33ae6661ebfa096378f0986ede6c
- sha1: 3594ef58b6e3b0ffa9589d787679b6e739fbb0dd
- sha256: 562432bea9455a61ff6e6b3263078ea9b26bef2ed177a04b5f9b181d605bc021

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.12.tar.gz.gpg)

already built API documentation can be found [here](https://doc.libelektra.org/api/0.8.12/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on GitHub](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/98770541-32a1-486a-98a1-d02f26afc81a.html)

For more information, see https://libelektra.org

Best regards,
Markus
