# 0.8.13 Release

- guid: 3c00a5f1-c017-4555-92b5-a2cf6e0803e3
- author: Markus Raab
- pubDate: Thu, 17 Sep 2015 17:32:16 +0200
- shortDesc: adds elektrify-getenv & other improvements

Again we managed to release with many new features, many fixes
and also other improvements.

## Elektrify-getenv

getenv(3) is one of the most popular ways to retrieve configuration,
even though it has many known problems:

- no standard way to modify it
- relogin (or restart of shell) necessary
- names are flat (no hierarchical structure)
- cannot be set for individual applications
- different in at, cron and similar scripts

With elektrify-getenv we wrote a solution which solves most of the
problems. We use the `LD_PRELOAD` technique to _additionally_ retrieve
values from Elektra, and not only the environment.

You simply can do:

```bash
kdb set user/env/override/HTTP_PROXY "http://my.proxy:8080"
```

This will set the `HTTP_PROXY` environment variable to `http://my.proxy:8080`.
Configuration can be retrieved with `kdb get`:

```bash
kdb get user/env/override/HTTP_PROXY
lynx   # or start another www-browser with the newly set HTTP_PROXY
```

Or using the man pages:

```sh
kdb elektrify-getenv man man --elektra:MANWIDTH=40
```

Will use MANWIDTH 40 for this invocation of man man.
This feature is handy, if an option is only available
by environment, but not by command-line arguments,
because sometimes environment variables are not trivial
to set (e.g. in Makefiles).

Some more examples:

```sh
kdb set user/env/override/MANOPT -- "--regex -LC"
kdb elektrify-getenv getenv MANOPT   # to check if it is set as expected
kdb getenv MANOPT   # if /etc/ld.so.preload is active
```

So is this the final solution for configuration and manual elektrification
of applications is not needed anymore?

The answer is: no and yes.

It is quite satisfactory for configuration that is inherently sharable
(not different from one application to another) _and_ needs the environment
semantics, i.e. some subprocesses should have different configuration
than others, e.g. in a specific terminal.

But it might not be a good solution for your own application, because
libgetenv(3) implies many architectural decision, that other elektrified
applications would decide differently, e.g.:

- it uses global variables (getenv(3) has no handle)
- it uses mutex for multi-threading safety
- the API getenv(3) only returns `char*` and has no support for other data types

For more information see [src/libgetenv/README.md](https://git.libelektra.org/blob/master/src/bindings/intercept/env/README.md)

## Compatibility

As always, the API and API is fully forward-compatible, i.e. programs compiled against an
older 0.8 versions of Elektra will continue to work.

Because `keyUnescapedName` and `keyGetUnescapedNameSize` is added in this release, it is not backward-compatible,
i.e. programs compiled against 0.8.13, might _not_ work with older 0.8 libraries.

The function `keyUnescapedName` provides access to an unescaped name, i.e. one where `/` and `\\` are
literal symbols and do not have any special meaning. `NULL` characters are used as path separators.
This function makes it trivial and efficient to iterate over all path names, as already exploited
in all bindings:

- [jna (java)](https://git.libelektra.org/blob/master/src/bindings/jna/HelloElektra.java)
- [lua](https://git.libelektra.org/blob/master/src/bindings/swig/lua/tests/test_key.lua)
- python2
- [python3](https://git.libelektra.org/blob/master/src/bindings/swig/python/tests/test_key.py)

Other small changes/additions in bindings:

- fix key constructor, thanks to Manuel Mausz
- add copy and deepcopy in python (+examples,+test cases), thanks to Manuel Mausz
- dup() in python3 returned wrong type (SWIG wrapper), thanks to Toscano Pino for reporting, thanks to Manuel Mausz for fixing it

Doxygen 1.8.8 is preferred and the configfile was updated to this version.

The symbols of nickel (for the ni plugin) do not longer leak from the Elektra library.
As such, old versions of testmod_ni won't work with Elektra 0.8.13.
A version-script is now in use to only export following symbols:

- `kdb*`
- `key*`
- `ks*`
- `libelektra*` for module loading system
- `elektra*` for proposed and other functions (no ABI/API compatibility here!)

In this release, ENABLE_CXX11 was changed to `ON` by default.

Note that in the next release 0.8.14 there will be two changes:

- According to [issue #262](https://git.libelektra.org/issues/262), we plan to remove the option ENABLE_CXX11
  and require the compiler to be C++11 compatible.
  If you have any system you are not able to build Elektra with -DENABLE_CXX11=ON (which is
  the default for 0.8.13) please report that immediately.
- the python3 bindings will be renamed to python

By not having to care for pre-C++11 compilers, we hope to attract more developers.
The core part is still in C99 so that Elektra can be used on systems where libc++ is not available.
Many new plugins are still written in C99, also with the purpose of not depending on C++.

## Python Plugins

A technical preview of [python3](https://git.libelektra.org/blob/master/src/plugins/python)
and python2 plugins has been added.

With them its possible to write any plugin with python scripts.

Note, they are a technical preview. They might have severe bugs
and the API might change in the future.
Nevertheless, it is already possible to, e.g. develop storage plugins
with it.

They are not included in `ALL` plugins. To use it, you have to specify it:

```sh
-PLUGINS="ALL;python;python2"
```

Thanks to Manuel Mausz for to this work on the plugins and the patience in all
the last minute fixes!

## Qt-gui 0.0.8

The GUI was improved and the most annoying bugs are fixed:

- only reload and write config files if something has changed
- use merging in a way that only a conflict free merge will be written, thanks to Felix Berlakovich
- made sure keys can only be renamed if the new name/value/metadata is different from the existing ones
- fixed 1) and 2) of #233
- fixed #235
- fixed qml warning when deleting key
- fixed qml typerror when accepting an edit

A big thanks to Raffael Pancheri!

## KDB Tool

The commandline tool `kdb` also got some improvements.
Most noteworthy is that `kdb get -v` now gives a complete trace for
every key that was tried. This is very handy if you have a complex
specification with many fallback and override links.

It also shows default values and warnings in the case of context-oriented
features.

Furthermore:

- Add `-v` for setmeta
- Copy will warn when it won't overwrite another key (behavior did not change)
- improve help text, thanks to Ian Donnelly

## Documentation Initiative

As Michael Haberler from [machinekit](http://www.machinekit.io/) pointed out it was certainly not easy for someone
to get started with Elektra. With the documentation initiative we are going to change that.

- The discussion in [GitHub issues](https://git.libelektra.org/issues) should clarify many things
- We start writing man pages in ronn-format(7), thanks to Ian Donnelly for current work
- Kurt Micheli is woring on improved doxygen documentation + pdf generation
- Daniel Bugl already restructed the main page
- Daniel Bugl also improved formatting
- doc: use @retval more, thanks to Pino Toscano
- doxygen: fix template to use `@` and not `\\`.
- SVG logo is preferred, thanks to Daniel Bugl
- doc: use @retval more, thanks to Pino Toscano
- many typo fixes, thanks to Pino Toscano
- fix broken links, thanks to Manuel Mausz, Daniel Bugl and Michael Haberler

Any further help is very welcome! This call is especially addressed to beginners in Elektra because
they obviously know best which documentation is lacking and what they would need.

## Portability

`kdb-full` and `kdb-static` work fine now for Windows 64bit, thanks to Manuel Mausz.
The wresolver is now more relaxed with unset environment.

All issues for macOS were resolved. With the exception of elektrify-getenv
everything should work now, thanks to Mihael Pranjic:

- fix mktemp
- testscripts
- recursive mutex simplification
- clearenv ifdef

and thanks to Daniel Bugl:

- RPATH fixed, so that `kdb` works

furthermore:

- fix `__FUNCTION__` to `__func__` (C99), thanks to Pino Toscano
- avoid compilation error when JNI_VERSION_1_8 is missing
- fix (twice, because of an accidental revert) the TARGET_CMAKE_FOLDER, thanks to Pino Toscano

Thanks to Manuel Mausz for to testing and improving portability!

## Packaging and Build System

- [0.8.12 packaged+migrated to testing](https://packages.qa.debian.org/e/elektra/news/20150726T155000Z.html), thanks to Pino Toscano
- fix build with external gtest, thanks to Pino Toscano
- switch from FindElektra.cmake to ElektraConfig.cmake, thanks to Pino Toscano
- use `cmake_parse_arguments` instead of `parse_arguments`, thanks to Manuel Mausz

## Further Fixes

- Key::release() will also work when Key holds a null-pointer
- Key::getName() avoids std::string exception
- support for copy module was introduced, thanks to Manuel Mausz
- be more POSIX compatible in shell scripts (`type` to `command -v` and avoid `echo -e`) thanks to Pino Toscano
- fix vararg type for KEY_FLAGS, thanks to Pino Toscano
- fix crash of example, thanks to Pino Toscano
- add proper licence file for Modules (COPYING-CMAKE-SCRIPTS), thanks to Pino Toscano
- fix XDG resolver issue when no given path in XDG_CONFIG_DIRS is valid
- make dbus example work again
- fix compiler warnings for gcc and clang
- fix Valgrind suppressions
- Installation of GI binding is fixed, thanks to Dāvis
- make uninstall is fixed and documentation improved

## Notes

There are some misconceptions about Elektra and semi structured data (like XML, JSON).
Elektra is a key-value storage, that internally represents everything with key and values.
Even though, Elektra can use XML and JSON files elegantly, there are limitations what
XML and JSON can represent. XML, e.g., cannot have holes within its structure, while this
is obviously easily possible with key-value. And JSON, e.g., cannot have non-array entries
within an array. This is a more general issue of that configuration files in general
are constrained in what they are able to express. The solution to this problem is
validation, i.e. keys that does not fit in the underlying format are rejected.
Note there is no issue the other way round: special characteristics of configuration
files can always be captured in Elektra’s metadata.

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz)
and now also [here on GitHub](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.13.tar.gz)

- name: elektra-0.8.13.tar.gz
- size: 2141758
- md5sum: 6e7640338f440e67aba91bd64b64f613
- sha1: ca58524d78e5d39a540a4db83ad527354524db5e
- sha256: f5c672ef9f7826023a577ca8643d0dcf20c3ad85720f36e39f98fe61ffe74637

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.13.tar.gz.gpg)

already built API documentation can be found [here](https://doc.libelektra.org/api/0.8.13/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on GitHub](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/3c00a5f1-c017-4555-92b5-a2cf6e0803e3.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus
