# 0.8.16 Release

- guid: 9c9247ee-ee9c-4f4a-a68e-76959def9b82
- author: Markus Raab
- pubDate: Fri, 29 Apr 2016 12:45:39 +0200
- shortDesc: adds stability improvements, configuration profiles & new plugins

In case you do not yet know about it, here is an abstract about Elektra:

Elektra serves as a universal and secure framework to access configuration
parameters in a global, hierarchical key database.
Elektra provides a mature, consistent and easily comprehensible API.
Its modularity effectively avoids code duplication across applications
and tools regarding configuration tasks. Elektra abstracts from
cross-platform-related issues and allows applications to be aware of other
applications' configurations, leveraging easy application integration.

Elektra consists of three parts:

1. _LibElektra_ is a modular configuration access toolkit to
   construct and integrate applications into a global,
   hierarchical key database. The building blocks are:
   - language bindings (inclusive high-level interfaces)
   - GenElektra, the code generator for type-safe bindings
   - plugins for configuration access behavior and validation
2. _SpecElektra_ is a configuration specification language
   that is easy to use and self-contained in the same key database (i.e.
   written in any of the configuration file formats Elektra supports).
3. Tools on top of LibElektra for administrators, such as CLI tools and GUIs.

See [https://libelektra.org](https://libelektra.org)

The same text as follows is also available
[here as html](https://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)
and
[here on GitHub](https://github.com/ElektraInitiative/libelektra/blob/master/doc/news/2016-04-29_0.8.16.md)

## Highlights

- Elektra now allows applications to support multiple
  profiles with a plugin, thus _without code modifications_ in
  Elektra applications.
  That means a user can select multiple configuration files to use,
  even if the application has no explicit support for it.
  It completes the cascading feature (level `$HOME` before /etc), to allows
  us also to select different configuration for the same level.
- Resolver can now better handle conflicts that happen
  when files are removed and others that happen
  within a single time tick (resolution of your clock)
  and also better handles NFS and older file systems
- Default storage and resolver can be changed by symlink.
  So no need to recompile Elektra to change the default storage
  from INI to dump.
  INI now works quite reliable as default plugin and already
  used by default by its author Thomas Waser.

## Other important features

- shell plugin allows you to execute shell commands on every KDB access
  and curlget plugin allows you to download configuration files
  from a URL during KDB access.
- Improvements in sync/merge of qt-gui with important fix
  (Usage of 0.8.15 qt-gui is discouraged)
- Add plugin for dpkg database (read-only)
- Assignment for conditionals using `assign/condition`.
- Support for multiple and nested statements
- Support for `condition/validsuffix` which allows you to suffix
  numbers with signs such as `%` or `$`.
  It does not check if the suffixes are identical.
- kdb mount now uses topological sorting to always
  find a dependency solution if there is one,
  many effort was put in that ordering is as requested, thanks to
  Thomas Waser for the topological sorting implementation
- Frontend generated by GenElektra now also can reload its
  values with taking the correct context into account.
- Source is now automatically formatted and formatting is checked on build server
- More flexible CMake syntax for PLUGINS

## Plugins

Many new or vastly improved plugins are waiting to be explored.

### curlget

The plugin curlget fetches a configuration file from a remote host before
the configuration is being accessed:

```sh
kdb mount -R noresolver /tmp/curltest.ini system/curltest ini curlget url="https://raw.githubusercontent.com/ElektraInitiative/libelektra/master/src/plugins/ini/ini/plainini"
kdb ls system/curltest  # every get access will redownload the file
```

Thanks to Thomas Waser!

### INI

The INI plugin is still under heavy development and
was again nearly rewritten:

- fixed key is below hacks
- fixed ordering
- custom delimiter
- use meta array for comments
- rewritten ordering
- best effort order
- fixed array support

Thanks to Thomas Waser!

### shell

This plugin allows you to executes shell commandos after kdbGet, kdbSet and kdbError (failing kdbSet):

```sh
kdb mount /tmp/test.ini system/shelltest ini array= shell 'execute/set=echo set >> /tmp/log,execute/get=echo get >> /tmp/log'
kdb set system/shelltest
cat /tmp/log
```

Thanks to Thomas Waser!

### validation

The validation plugin is not new, but got many new features.
It allows you to match values by a regex and set your own
error messages in case a validation did not match.

Up to now, the regex was given as is to regcomp, which means
that if the regex is contained _anywhere_ in the value, the
value is accepted.

Often this is not what we want, thus Thomas Waser added special
support for icase, word and line validation.
Additionally, flags allow you now to ignore the case or invert
the match. This can be changed for every individual value
or for the whole mountpoint.

Additionally, `kdb vset` validation was updated to use the new
metadata and correctly match against the whole value.

Thanks to Thomas Waser!

### hosts

Only minor improvements were necessary for the host plugin but
it is quite matured already. The contract was changed so that
ipv6 addresses for ipv4 addresses will be rejected:

```sh
# kdb mount --with-recommends /etc/hosts system/hosts hosts
# kdb set system/hosts/ipv4/localhost ::1
The command set failed...
Reason: localhost value: ::1 message: Address family not supported
# kdb set system/hosts/ipv6/localhost ::1
```

You can also comfortably and safely edit the hosts file
with: `kdb editor system/hosts hosts`, then you have the
functionality `visudo` for the hosts file.

### rename

Again not a new plugin, but the plugin was greatly improved
and many test cases were added.

Now you can set upper/lowercase individually for both sides:

1. What applications see.
2. What the configuration file contains.

For example, if you always want the keys in the configuration file upper case,
but for your application lower case you would use:

```sh
kdb mount caseconversion.ini /rename ini rename get/case=tolower,set/case=toupper
kdb set user/rename/section/key valu
cat ~/.config/caseconversion.ini
#> [SECTION]
#> KEY = value
```

Thanks to Thomas Waser!

### Resolver

Resolving by ~ as home directory now also for system and spec namespaces,
thanks to Thomas Waser.

Files keep their previous owner, useful when root edits configuration
files of others, thanks to Thomas Waser.

The resolver has many improvements to better detect conflicts.

The lock is now extended longer after the commit and already requested
in the temporary file.

The warnings were improved when `getcwd` fails.

Resolver now can correctly handle conflicts with empty files. It can also
better cope with frequent commits of the same binary. Elektra already
reached some limits filesystems have.

## Bindings

### Java

Marvin Mall improved the Java binding, fixed the appending
of keysets, added lots of documentation, and many unit tests.

### C++

Some kind of misusage of vaargs is now detected at compile-time instead
of crashing at runtime.

### Generated C++

Value now supports convenience activations.
Values can be used to activate context, no more layers are needed.
Topological sorting makes sure that values are activated in the
correct order, loops are not allowed anymore.

The `bool operator<` is now correctly inline (allows to use it in more than
one translation unit)

## Documentation

René Schwaiger<sanssecours> reworked most of the documentation and
fixed countless spelling mistakes and other problems.

- Peter Nirschl updated the status of the crypto-plugin
  and fixed a typo
- Daniel Bugl wrote a cascading tutorial
- Daniel Bugl fixed all broken links
- René Schwaiger also drew a new logo with SVG.
  It is already used on GitHub as avatar for the organization.
- make all é use the same code point 233.

## Testing

- Tests work if the build path contains spaces
- Tests: Fix problems locating memory checker
- remove obsolete TestScript.cmake

Thanks to René Schwaiger

## Maintainer

By default now ALL plugins except EXPERIMENTAL are included.
Plugins will be automatically excluded if dependencies are missing.

The PLUGINS syntax was vastly improved. Now many categories can be
intermixed freely and also categories can be used for exclusion.

E.g. to include all plugins without deps,
that provide storage (except yajl) and are maintained, but not include all plugins
that are experimental, you would use:

```sh
-DPLUGINS="NODEP;STORAGE;-yajl;MAINTAINED;-EXPERIMENTAL"
```

Details see [/doc/COMPILE.md](https://github.com/ElektraInitiative/libelektra/tree/master/doc/COMPILE.md).

### Renamed files:

/usr/include/elektra/merging/kdbmerge.hpp ->
/usr/include/elektra/merging/mergingkdb.hpp

/etc/profile.d/kdb -> /etc/profile.d/kdb.sh

(So that it works on arch linux, thanks to Gabriel Rauter)

### removed files:

- /usr/lib/elektra/libelektra-crypto.so

was only necessary because of limitations of the build system and is
now removed. It never had actual functionality, but was only a stub
without a crypto provider selected.

### new files:

- `/usr/include/kdbease.h`
- `/usr/lib/elektra4/libelektra-curlget.so*`
- `/usr/lib/elektra4/libelektra-dpkg.so*`
- `/usr/lib/elektra4/libelektra-profile.so*`
- `/usr/lib/elektra4/libelektra-resolver_fm_hpu_b.so`
- `/usr/lib/elektra4/libelektra-shell.so*`

more new files with ALL or EXPERIMENTAL:

- /usr/lib/elektra/libelektra-semlock.so

new tests all in folder /usr/lib/elektra/tool_exec:
testcpp_contextual_update testkdb_conflict test_keyname testmod_curlget
testmod_dpkg testmod_jni testmod_profile testmod_semlock testmod_shell
testtool_mergingkdb

Following Plugins are excluded on specific platforms:

- mathcheck on Intel compiler (reason: failing test cases)
- simpleini on non-glibc systems (reason: not portable printf extension)

### new symlinks:

- /usr/lib/elektra4/libelektra-storage.so
- /usr/lib/elektra4/libelektra-resolver.so

### new releases

The first release of the libraries libelektratools-full, libelektratools
and libelektragetenv. They now have SOVERSION 0.

## Development

You do not need to format the source manually anymore.
Make sure that you run scripts/reformat-source before
creating a PR.

`clang-tidy` helps you to add blocks to have better
maintainable code.

Felix Berlakovich improved the performance of the augeas plugin and
also contributed a script to benchmark different host plugin.
His thesis can be downloaded from [here](https://www.libelektra.org/ftp/elektra/publications/berlakovich2016universal.pdf).
It contains benchmarks and discussions about augeas.

The CMake function `add_plugin` was completely rewritten.
Now you do not have to register your plugin at multiple points
but instead information of README.md is parsed to correctly
register the plugin to categories as stated by `infos/status`
and `infos/provides`.

The code generator for errors also yields macros. This
avoids usage of the IDs, which can be problematic if
multiple pullrequests are prepared at once.

## Compatibility

This might be the last release supporting wheezy, because
it gets more and more time-intensive to find workarounds
for the old compiler. The C++11 regex do not work at all.

### Binary Compatibility Test

When you execute the test cases of 0.8.15 against Elektra 0.8.16
following test cases fail. None of them effect the API.

- test_splitget test_splitset .. Internal restructuring
- testmod_crypto .. not included by default now
- testmod_ini .. section handling changed, line 178:
  `nosectionkey contained no comment`
- testmod_rename .. internal API elektraKeyCreateNewName changed
- testmod_resolver .. internal data structure now contains more
  members to remember uid and gid
- testmod_template .. not present by default
- testtool_backend testtool_backendbuilder testtool_backendparser
- testtool_specreader .. changes in KDB tool before release
- check_kdb_internal_check .. experimental plugins are now excluded

### Added API

in libease René Schwaiger added:

```c
extern char const * elektraKeyGetRelativeName(Key const * cur, Key const * parentKey);
```

in libmeta Thomas Waser added (partly based on ideas/code from Felix Berlakovich):

```c
extern void elektraMetaArrayAdd(Key *, char const *, char const *);
extern KeySet * elektraMetaArrayToKS(Key *, char const *);
extern char * elektraMetaArrayToString(Key *, char const *, char const *);
extern int elektraSortTopology(KeySet *, Key * *);
```

## Tools

### Qt-gui

Raffael Pancheri fixed an important issue which broke the synchronization
because an key related to Elektra’s internal version information was missing.

Felix Berlakovich updated the qt-gui so that it uses a newly written sync-method
added in libtools.

Gabriel Rauter added a desktop file that uses the new svg logo from
René Schwaiger.

## Portability

- Peter Nirschl fixed code in the resolver that uses EBADMSG which was not
  available in BSD.
- Peter Nirschl improved detection of librt
- Felix Berlakovich fixed searching of FindSystemd
- MinGW64 resolver now handles conflicts correctly and does not ignore them
  anymore and now also is able to create empty files (but still not directories)

### macOS

A lot of effort was invested to all test cases also run on macOS:

- .template syntax
- linking errors
- fix regex in conditionals plugins

Thanks to René Schwaiger

## Bugs

- print null-environment correctly with `kdb getenv`
- keyIs(Direct)Below didn't work with cascading keys
- fix elektraKeyGetRelativeName (needed by ni) for cascading
  keys and move it to libease, thanks to René Schwaiger
- make nickel tests show correct test name, thanks to René Schwaiger
- glib: replace cursor_t with gssize so that GElektra-4.0.gir
  builds with gobject-introspection later than 1.47, thanks to Manuel Mausz
- fixed out-of-bounds bug in timeofday plugin
- elektraMetaArrayToKS correctly adds parent key, thanks to Thomas Waser
- kdb-shell: Do not abort ksOutput on binary data.
- some rework for global hooks, still not stable

## Get It!

You can download the release from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz)
and now also [here on GitHub](https://github.com/ElektraInitiative/ftp/tree/master/releases/elektra-0.8.16.tar.gz)

- name: elektra-0.8.16.tar.gz
- size: 2405443
- md5sum: ef0c138b4a4fda017aa8bb6f812671ce
- sha1: c6a6f9c26addd5fcc274cea635de02ef680cfb1a
- sha256: 3cf0624eb027e533192ca9d612618df3d38ec3674c9cd20474f04ff269fad77e
- sha512: b225e61379907365a423ea75ec7138e5257bb78c526bb05a1ec21f66a52eb4bad9e6f1eb23209d700670b21b86166497b47c3bc46bc9d45f6d366cd544afc326

This release tarball now is also available
[signed by me using gpg](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.16.tar.gz.gpg)

already built API documentation can be found [here](https://doc.libelektra.org/api/0.8.16/html/)

## Stay tuned!

Subscribe to the
[RSS feed](https://doc.libelektra.org/news/feed.rss)
to always get the release notifications.

For any questions and comments, please contact the
[Mailing List](https://lists.sourceforge.net/lists/listinfo/registry-list)
the issue tracker [on GitHub](https://git.libelektra.org/issues)
or by mail elektra@markus-raab.org.

[Permalink to this NEWS entry](https://doc.libelektra.org/news/9c9247ee-ee9c-4f4a-a68e-76959def9b82.html)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
Markus
