# 0.8.25 Release

We are proud to present Elektra 0.8.25.

## What is Elektra?

Elektra serves as a universal and secure framework to access
configuration settings in a global, hierarchical key database.
For more information, visit [https://libelektra.org](https://libelektra.org).

For a small demo see here:

[![asciicast](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r.png)](https://asciinema.org/a/cantr04assr4jkv8v34uz9b8r)

You can also read the news [on our website](https://www.libelektra.org/news/0.8.25-release)

## Metadata

- guid: 472392e0-cc4f-4826-a0a9-2764d90c5f89
- author: Markus Raab
- pubDate: Sun, 18 Nov 2018 21:24:34 +0100
- shortDesc: faster storage and lookup

## Highlight

This release is dedicated to drastically improve the speed of Elektra.
Two non-trivial features facilitate most of the improvement:

- mmap storage for very fast retrieval of configuration
- Hybrid Search Algorithm for `ksLookup (...)` for very fast access of configuration

### mmap storage

We added a new, binary and fast storage plugin called [`mmapstorage`](https://libelektra.org/plugins/mmapstorage).
It leverages the `mmap()` syscall and supports full Elektra semantics.
We provide two compile variants: `mmapstorage` and `mmapstorage_crc`.
The `mmapstorage_crc` variant enables CRC32 checksums for critical data,
while the `mmapstorage` variant omits the checksum for maximum performance.

We ran a synthetic benchmark with 257 iterations using 40k keys in a keyset,
and compared the performance to the `dump` storage plugin.

Median write time in microseconds:

| Plugin            | Time  |
| ----------------- | ----- |
| `dump`            | 71079 |
| `mmapstorage`     | 2964  |
| `mmapstorage_crc` | 7644  |

Median read time in microseconds:

| Plugin            | Time  |
| ----------------- | ----- |
| `dump`            | 82737 |
| `mmapstorage`     | 1145  |
| `mmapstorage_crc` | 5744  |

In our benchmark, the `mmapstorage` plugin writes more than 23x faster,
and reads more than 72x faster than the `dump` storage plugin.

For this release the plugin is marked as experimental,
even though it is already used as default storage plugin in a build job on our [build server](https://build.libelektra.org).

Thanks to Mihael Pranjić for this improvement.

### Hybrid Search Algorithm for `ksLookup (...)`

The hybrid search algorithm is now implemented, this concludes the extension of the `ksLookup (...)` search with the
[order preserving minimal perfect hash map (OPMPHM)](https://master.libelektra.org/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm).
The hybrid search combines the best properties of the binary search and the [OPMPHM](https://master.libelektra.org/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm).
The hybrid search decides dynamically which search algorithm to use.

Because of the automatic decision, usually nothing needs to be done by API users to take advantage of this improvement.
Advanced API user, however, can overrule the hybrid search by passing `KDB_O_OPMPHM` or `KDB_O_BINSEARCH` to `ksLookup (...)`.
The constants are defined in [kdbproposal.h](https://master.libelektra.org/src/include/kdbproposal.h).
For low-memory systems the building of the hash map can be disabled altogether at build-time by disabling the CMake variable `ENABLE_OPTIMIZATIONS` (by default enabled now).

The implemented randomized [OPMPHM](https://master.libelektra.org/doc/dev/data-structures.md#order-preserving-minimal-perfect-hash-map-aka-opmphm)
algorithm is in 99.5% of the measured random cases optimal. However the randomization property of the algorithm leaves an uncertainty.

The results made with random cases had shown that the hybrid search is, except for small keyset sizes, almost always faster
compared to the standalone binary search. The performance increase strongly depended on the measured hardware. In the random cases
where the hybrid search is faster, on average ~8.53% to ~20.92% of time was saved.
The implemented hybrid search works only above a keyset size of `599` to exclude the small keyset sizes.

Thanks to Kurt Micheli for this improvement.

## Plugins

The following section lists news about the [plugins](https://www.libelektra.org/plugins/readme) we updated in this release.

### Directory Value

We improved the performance of the [directoryvalue plugin](https://libelektra.org/plugins/directoryvalue). _(René Schwaiger)_
This plugin is used for configuration file formats that do not support that directories contain values, like it is the case in JSON.
A program manipulating a 13 MB JSON file which first did not succeed within 10 hours is now finished in 44 seconds.

### Process

There is a new, experimental plugin called [process](https://libelektra.org/plugins/process).
This plugin utilizes the pluginprocess library in order to execute arbitrary other
plugins in an own process, acting as a proxy itself. Therefore it is not required
to explicitly change a plugin's implementation if it shall be executed in an own
process. This plugin is not completely finished yet, as currently there is no way
for it to mimic the proxied plugin's contract in Elektra. It can be used with simple
plugins like `dump` however, check the limitations in the readme for more details. _(Armin Wurzinger)_

### FSTab

The detection of the `mntent` functions now also works correctly, if you use the compiler switch `-Werror`. _(René Schwaiger)_

### passwd

We fixed an issue with the passwd plugin not properly setting compile flags.
This resolves a problem with undefined functions when building with musl. _(Lukas Winkler)_

### gpgme

The experimental [gpgme plugin](https://libelektra.org/plugins/gpgme) was brought into existence to provide cryptographic functions using GnuGP via the `libgpgme` library. _(Peter Nirschl)_

### network

The `network` plugin now also allows for non-numerical hosts (i.e. "localhost") to be set and tries to resolve it via DNS. _(Michael Zronek)_

### YAMBi

This new plugin parses a subset of YAML using a parser generated by [Bison](https://www.gnu.org/software/bison). _(René Schwaiger)_

### YAML CPP

The build system now disables the plugin automatically, if you use a GCC compiler (`6.x` or earlier) and enable the option `ENABLE_ASAN`.
We updated the behavior, since otherwise the plugin will report memory leaks at runtime. _(René Schwaiger)_

### Yan LR

- The plugin does not modify the (original) parent key. As a consequence, setting values at the root of a mountpoint:

  ```sh
  sudo kdb mount config.yaml user/tests/yambi yambi
  kdb set user/tests/yanlr 'Mount Point Value'
  kdb get user/tests/yanlr
  #> Mount Point Value
  ```

  now works correctly. _(René Schwaiger)_

- We now use C++ code to test the plugin. _(René Schwaiger)_
- The CMake code of the plugin now also recognizes `antlr` as ANTLR executable, if `antlr4` is not available. _(René Schwaiger)_
- The build system now disables the unit test for the plugin, if you use GCC (`6.x` or earlier) to translate Elektra. We introduced this
  behavior, since the code generated by ANTLR (`YAML.h`) seems to contain a double free that causes a segmentation fault on systems that
  use the GNU C library. _(René Schwaiger)_
- The build system now disables the plugin automatically, if you use a GCC compiler (`6.x` or earlier) and enable the option `ENABLE_ASAN`.
  _(René Schwaiger)_

### YAwn

This new plugin parses a subset of YAML using the Earley Parser library YAEP. _(René Schwaiger)_

### Reference

This new plugin can be used to validate that the value of a key is a reference to another key. _(Klemens Böswirth)_

## Libraries

The text below summarizes updates to the [C (and C++)-based libraries](https://www.libelektra.org/libraries/readme) of Elektra.

### Compatibility

As always, the ABI and API of kdb.h is fully compatible, i.e. programs
compiled against an older 0.8 version of Elektra will continue to work
(ABI) and you will be able to recompile programs without errors (API).

This is the last release for which we have built Jessie packages:

```
deb     [trusted=yes] https://debian-stable.libelektra.org/elektra-stable/ jessie main
deb-src [trusted=yes] https://debian-stable.libelektra.org/elektra-stable/ jessie main
```

Obviously, we will continue to update the stretch package:

```
deb     [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
deb-src [trusted=yes] https://debian-stretch-repo.libelektra.org/ stretch main
```

### Infos for Package Maintainers

Following plugins got added:

- libelektra-gpgme.so
- libelektra-mmapstorage_crc.so
- libelektra-mmapstorage.so
- libelektra-process.so
- libelektra-reference.so
- libelektra-yambi.so

A new library got added (should be packaged privately for now):

- libelektra-globbing.so

### Core

Optimize elektraKsFilter to not duplicate keys _(Markus Raab)_

### Globbing

A new library which can be used to match keys against globbing patterns was introduced. _(Klemens Böswirth)_

The API is still experimental, so it should not be used externally for now.

### Ease

`libease` provides the function `elektraArrayValidateBaseNameString`, which can be used to validate that a
given string is an Elektra array name. _(Klemens Böswirth)_

## Bindings

Bindings allow you to utilize Elektra using [various programming languages](https://www.libelektra.org/bindings/readme). This section keeps
you up-to-date with the multi-language support provided by Elektra.

### Ruby

Do not use private Elektra headers for Ruby bindings as preparation for a Ruby `libelektra` gem. _(Bernhard Denner)_

## Tools

- Added benchmarks for storage plugins. The currently benchmarked plugins are `dump` and `mmapstorage`. _(Mihael Pranjić)_
- Avoid raw pointers in KDB tools. _(Markus Raab)_
- Improved error text of KDB tool `cp`. _(Markus Raab)_
- Document hidden feature of KDB tool `mount`. _(Markus Raab)_
- Add more tags to the KDB tools to be used with `kdb find-tools`. _(Markus Raab)_

## Scripts

- We now require [`clang-format`](https://clang.llvm.org/docs/ClangFormat.html) 6.0 for formatting C and C++ code. _(René Schwaiger)_
- The command `reformat-source` now displays information about the installed
  version of `clang-format`, if it is unable to locate a supported version of the tool. _(René Schwaiger)_
- We now also check the POSIX compatibility of our scripts with [`shfmt`][]. _(René Schwaiger)_
- The new command `reformat-shfmt` reformats Shell scripts using the tool [`shfmt`](https://github.com/mvdan/sh). _(René Schwaiger)_

[`shfmt`]: https://github.com/mvdan/sh

## Documentation

- We fixed some minor spelling mistakes in the documentation. _(René Schwaiger)_
- Improved the plugins documentation. _(Michael Zronek)_
- The ReadMe now includes two badges that show the latest released version of Elektra and the status of the Travis build. _(René Schwaiger)_
- Fixed documenation error on Ruby plugin Readme. _(Bernhard Denner)_
- Go into more detail in
  [BUILDSERVER.md](https://master.libelektra.org/doc/BUILDSERVER.md).
  _(Lukas Winkler)_

## Tests

- Fix potential parallel execution of maven tests, which write to KDB. _(Markus Raab)_
- The unit test for the [`dbus` plugin](https://www.libelektra.org/plugins/dbus) does not leak memory anymore, if it fails on macOS.
  _(Thomas Wahringer)_
- The tests `testkdb_allplugins` and `testscr_check_kdb_internal_check` do not test a plugin on an ASAN enabled build anymore, if you
  specify the status tag `memleak` in the plugin contract. _(René Schwaiger)_
- The [CFramework](https://master.libelektra.org/doc/TESTING.md) macro `compare_key` now also checks if the meta values of keys are equal.
  _(René Schwaiger)_
- The test `testscr_check_bashisms` does not print warnings about skipped files anymore. _(René Schwaiger)_
- We added a [Markdown Shell Recorder][] test for the [`shell` plugin ](https://www.libelektra.org/plugins/shell). _(René Schwaiger)_
- Added many storage plugin tests. Most tests use the keyset, key name and value APIs.
  Currently, the tests are only active for `dump` and `mmapstorage`. _(Mihael Pranjić)_
- The test `testcpp_contextual_basic` now compiles without warnings, if we use Clang 7 as compiler. _(René Schwaiger)_
- crypto, fcrypt and gpgme properly shut down the gpg-agent after the unit test is done. See #1973 . _(Peter Nirschl)_
- minor refactoring of the unit tests for crypto, fcrypt, gpgme: moved shared code to separate module in order to avoid code duplication. _(Peter Nirschl)_
- The CMake targets for plugin tests (`testmod_[plugin]`) now depend on the respective CMake targets for the plugins themselves
  (`elektra-[plugin]`). _(Klemens Böswirth)_
- Fixed bug in CMake plugin tests, if only `BUILD_FULL` but not `BUILD_SHARED` is used. _(Klemens Böswirth)_
- The test [`testscr_check_formatting`](https://master.libelektra.org/tests/shell/check_formatting.sh) now also checks the formatting of
  Shell code. _(René Schwaiger)_
- We pumped version numbers in XML-test files. _(Markus Raab)_
- We fixed a crash in the unit test of the [JNA](https://www.libelektra.org/bindings/jna) binding. _(René Schwaiger)_
- The command [`kdb run_all`](https://master.libelektra.org/tests/README.md) now only prints the output of tests that failed. To print the
  full output of all test, please use the option `-v`. _(René Schwaiger)_
- The [Shell Recorder][] does not use the non-POSIX grep option `--text` any more. _(René Schwaiger)_
- The test suite now uses [Google Test](https://github.com/google/googletest) `1.8.1`. _(René Schwaiger)_

[markdown shell recorder]: https://master.libelektra.org/tests/shell/shell_recorder/tutorial_wrapper
[shell recorder]: https://master.libelektra.org/tests/shell/shell_recorder

## Build

### CMake

- We improved the detection of Python 2 and Python 3 in the CMake code of the Python bindings/plugins. _(René Schwaiger)_
- We restructured the code of the CMake module we use to detect Haskell tools . _(René Schwaiger)_
- Building the Haskell binding should now work again. _(René Schwaiger)_
- The CMake configuration step now displays less debug messages about found libraries. _(René Schwaiger)_
- Provide a wrapper around `check_symbol_exists` that handles issues with
  `-Werror -Wpedantic`. _(Lukas Winkler)_
- The argument `INCLUDE_SYSTEM_DIRECTORIES` of the function `add_plugin` now supports multiple include directories. _(René Schwaiger)_
- We reformatted all CMake source files with cmake-format 0.4.3. _(René Schwaiger)_
- Generating coverage data (`ENABLE_COVERAGE=ON`) should now also work on macOS. _(René Schwaiger)_
- You can use the new target `run_checkshell` to run all shell checks (`testscr_check.*`). _(René Schwaiger)_
- The new target `run_nocheckshell` runs all tests except for shell checks. _(René Schwaiger)_
- The target `run_all` now runs tests that do not modify the key database in parallel. _(René Schwaiger)_
- Fix CMake inclusion logic for GLib/Gi _(Markus Raab)_

### Docker

- The Docker image for Debian stretch now contains all (optional) dependencies for Elektra. _(René Schwaiger)_
- The docker images used by our build system are now available to download from
  our systems without authentication.
  Try it out and list available images via `docker run --rm anoxis/registry-cli -r https://hub-public.libelektra.org`.
  You can search for images using `--images-like`, for example: `docker run --rm anoxis/registry-cli -r https://hub-public.libelektra.org --images-like alpine`.
  Afterwards pull your desired image as you would do from any public registry, for example: `docker pull hub-public.libelektra.org/build-elektra-alpine:201811-37597a34fed4988639cdaf4d6a2c54754d09918586f53389e4fde5fd3b3a7180`.
  _(Lukas Winkler)_

### Vagrant

- Added Vagrantfile for Ubuntu artful 32-bit. _(Mihael Pranjić)_

## Infrastructure

### Jenkins

- We enabled tests that write to the hard disk on the build job `alpine`. _(René Schwaiger)_
- The build jobs now print less non-relevant output. _(René Schwaiger)_
- Enable `-Werror` in `debian-stable-full`. _(Lukas Winkler)_
- We added the compiler switch `-Werror` to the build jobs:
  - `alpine`,
  - `debian-stable-full-i386`,
  - `debian-stable-full-mmap-asan`,
  - `debian-stable-full-mmap`,
  - `debian-stable-full-optimizations-off`,
  - `debian-stable-full-xdg`,
  - `debian-stable-minimal`,
  - `debian-stable-multiconf`,
  - `debian-unstable-clang-asan`,
  - `debian-unstable-full-clang`,
  - `debian-unstable-full`,
  - `ubuntu-xenial`, and
  - `debian-stable-asan`. _(René Schwaiger)_
- Build Artifacts for all PR's to detect issues before merging _(Lukas Winkler)_
- Stricter removal of temporary docker images on docker nodes _(Lukas Winkler)_
- Added jenkins build jobs `debian-stable-full-mmap` and `debian-stable-full-mmap-asan`
  with `mmapstorage` as the default storage. _(Mihael Pranjić)_
- We added basic support for coverage analysis via [Coveralls](http://coveralls.io). _(René Schwaiger)_

### Travis

- Travis now also checks the code for memory leaks in the build job `🍏 Clang ASAN`. _(René Schwaiger)_
- The Travis build jobs `🍏 Clang ASAN` and `🐧 GCC ASAN` now only translates a minimal set of plugins, since we had various timeout
  problems with these jobs before. We explicitly excluded plugins, to make sure that the build jobs still test newly added plugins.
  _(René Schwaiger)_
- Added travis build job `🍏 mmap` on macOS with `mmapstorage` as the default storage. _(Mihael Pranjić)_
- Travis now prints the CMake configuration for each build job. _(René Schwaiger)_
- We now test Elektra using the latest version of Xcode (`10.0`). _(René Schwaiger)_
- We added the build job `🍏 Check Shell`, which only runs shell checks such as `testscr_check_oclint`. This update allows us to
  remove the shell checks from the jobs `🍏 MMap` and `🍏 Clang`, which sometimes hit the
  [timeout limit for public repositories](https://docs.travis-ci.com/user/customizing-the-build#build-timeouts) before. _(René Schwaiger)_
- All Travis build jobs now use the compiler switch `-Werror`. _(René Schwaiger)_
- The new job `🍏 FULL` and the build job `🐧 FULL` build Elektra using the CMake options `BUILD_FULL=ON` and `BUILD_SHARED=OFF`.
  _(René Schwaiger)_
- The `script` stage of the build jobs print less non-relevant output. Usually the commands in this stage should now only print verbose
  output if a test fails. _(René Schwaiger)_

## Website

The website is generated from the repository, so all information about
plugins, bindings and tools are always up-to-date.

## Outlook

We are currently working on following topics:

- Global mmap cache: This feature will enable Elektra to return configuration without parsing configuration files or executing other plugins as long as the configuration files are not changed. _(Mihael Pranjić)_
- Finish high-level API. _(Klemens Böswirth)_
- Validation improvements. _(Michael Zronek)_
- Improve YAML plugins. _(René Schwaiger)_

## Statistics

Following authors made this release possible:

| Commits | Author                                             |
| ------- | -------------------------------------------------- |
| 1       | Thomas Wahringer <thomas.wahringer@libelektra.org> |
| 2       | Bernhard Denner <bernhard.denner@gmail.com>        |
| 7       | Kurt Micheli <e1026558@student.tuwien.ac.at>       |
| 12      | Michael Zronek <michael.zronek@gmail.com>          |
| 33      | Lukas Winkler <derwinlu+git@gmail.com>             |
| 28      | Klemens Böswirth <k.boeswirth+git@gmail.com>       |
| 30      | Armin Wurzinger <e1528532@student.tuwien.ac.at>    |
| 38      | Peter Nirschl <peter.nirschl@gmail.com>            |
| 100     | Markus Raab <markus@libelektra.org>                |
| 180     | Mihael Pranjic <mpranj@limun.org>                  |
| 418     | René Schwaiger <sanssecours@me.com>                |

849 commits, 581 files changed, 18503 insertions(+), 3192 deletions(-)

We welcome new contributors!

## Finished Thesis

- [Daniel Bugl](https://www.libelektra.org/ftp/elektra/publications/bugl2018web.pdf), see also [the web demo](https://webdemo.libelektra.org/).
- [Thomas Wahringer](https://www.libelektra.org/ftp/elektra/publications/wahringer2018notification.pdf).
- [Kurt Micheli](https://www.libelektra.org/ftp/elektra/publications/micheli2018hybrid.pdf)
- [Armin Wurzinger](http://repositum.tuwien.ac.at/urn:nbn:at:at-ubtuw:1-115452)

## Get It!

You can download the release from [here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.25.tar.gz)
or [GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.25.tar.gz?raw=true)

The [hashsums are:](https://github.com/ElektraInitiative/ftp/blob/master/releases/elektra-0.8.25.tar.gz.hashsum?raw=true)

- name: elektra-0.8.25.tar.gz
- size: 6233918
- md5sum: d5614b2049fb8431a80842a4909b140e
- sha1: c7dfb5fa87284d8f5ba4d4753e0e47a0e362c733
- sha256: 37829256e102e967fe3d58613a036d9fb9b8f9658e20c23fa787eac0bfbb8a79

The release tarball is also available signed by Markus Raab using GnuPG from
[here](https://www.libelektra.org/ftp/elektra/releases/elektra-0.8.25.tar.gz.gpg) or
[GitHub](https://github.com/ElektraInitiative/ftp/blob/master/releases//elektra-0.8.25.tar.gz.gpg?raw=true)

Already built API documentation can be found [here](https://doc.libelektra.org/api/0.8.25/html/)
or [GitHub](https://github.com/ElektraInitiative/doc/tree/master/api/0.8.25).

## Stay tuned!

Subscribe to the
[RSS feed](https://www.libelektra.org/news/feed.rss)
to always get the release notifications.

If you also want to participate, or for any questions and comments
please contact us via the issue tracker [on GitHub](http://issues.libelektra.org).

[Permalink to this NEWS entry](https://www.libelektra.org/news/0.8.25-release)

For more information, see [https://libelektra.org](https://libelektra.org)

Best regards,
[Elektra Initiative](https://www.libelektra.org/developers/authors)
