package org.libelektra.kdb

import io.mockk.*
import org.junit.Before
import org.junit.Test
import org.libelektra.KDB
import org.libelektra.Key
import org.libelektra.KeySet
import org.libelektra.kdbExt.withKDB
import kotlin.test.assertEquals

class OpenTest {

    @Before
    fun beforeEach() {
        setupKDBWith()
    }

    @Test
    fun `withKDB opens KDB and allows to interact with it`() {
        val parentKey = Key.create("/")

        withKDB {
            val keySet = get(parentKey)

            assertEquals(keySet.size, 3)
        }
    }

    private fun setupKDBWith() {
        mockkStatic(KDB::class)
        every { KDB.open() } answers {
            val mockedKDB: KDB = mockk()

            val parentKey = slot<Key>()
            every { mockedKDB.get(capture(parentKey)) } answers {
                KeySet.create(
                    Key.create("/key1", "value1"),
                    Key.create("/key2", "value2"),
                    Key.create("/key3", "value3")
                )
            }
            every { mockedKDB.close() } just runs

            mockedKDB
        }
    }
}
